<?php
Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Filas extends Elotech_Db_Table_Abstract
{

    protected $_name = 'filas';
    protected $_primary = 'fila_codigo';

    public function salvar($data)
    {
        return parent::salvar($data);
    }

    public function verificaSeJaExiste($fila_nome = null)
    {

        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("fila" => "filas"), "count(*) as qtde")
            ->where("fila_nome = '$fila_nome'");
        $query = $this->fetchRow($sql);
        if ($query->qtde > 0) {
            return false;
        } else {
            return true;
        }
    }

    public function listar($usr_codigo = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ord" => "filas"), array("fila_codigo", "fila_nome", "fila_tipo"));
        if ($usr_codigo) {
            $where->join(array("reg" => "filas_reguladores"), "ord.fila_codigo = reg.fila_codigo")
                ->where("reg.usr_codigo = $usr_codigo");
        }
        $where->order("fila_nome");

        $filas = $this->fetchAll($where);
        return $filas;
    }

    public function buscar($data = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ord" => "filas"));
        if ($data) {
            $where->where("fila_nome ilike '$data'");
        };
        $where->order("fila_nome");
        $filas = $this->fetchAll($where);
        return $filas;
    }

    public function listartudo($fila_nome)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ord" => "filas"))
            ->order("fila_nome");

        if ($fila_nome) {
            $where->where("fila_nome ILIKE '%$fila_nome%' OR fila_descricao ILIKE '%$fila_nome%'");
        }
        $listas = $this->fetchAll($where);
        return $listas;
    }

    public function getdados($id)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ord" => "filas"))
            ->order("fila_nome")
            ->where("fila_codigo = $id");
        $dados = $this->fetchRow($where);
        return $dados;
    }

    public function getRegulacao($id)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("fila" => "filas"), array("fila_regulacao"))
            ->where("fila_codigo = $id");
        $dados = $this->fetchRow($where);
        if($dados->fila_regulacao == 'S'){
            return true;
        }
        return false;
    }

    public function excluir($id)
    {
        $registro = $this->fetchRow("fila_codigo = $id");
        if ($registro) {
            $registro->delete();

            return true;
        }
    }
    public function ordenaFilaAction($fila)
    {

        $ordem = 1;

        $tbSoli = new Application_Model_FilasUsuario();
        $solicitacoes = $tbSoli->preparaOrdem($fila);

        $arrayOrdens = array();

        foreach ($solicitacoes as $solicitacao) {
            $arrayOrdens[$ordem] = $solicitacao->fiusu_codigo;
            $ordem++;
        }

        foreach ($arrayOrdens as $key => $valor) {
            $tbSoli->atualizaOrdem($key, $valor);
        }
        return true;
    }
}

