<?php

class Application_Model_FilasHistoricos extends Elotech_Db_Table_Abstract
{
    protected $_name = 'filas_historicos';
    protected $_primary = 'fihi_codigo';

    public function listar()
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("hist" => "filas_historicos"))
            ->order("fihi_codigo");

        $filas = $this->fetchAll($where);
        return $filas;
    }

    public function salvar($data)
    {
        return parent::salvar($data);
    }

    public function buscarOrdemHistorico($fiusu_codigo)
    {
        $where = $this->select(FALSE)
            ->from(array("fihi" => "filas_historicos"), array("MAX(fihi_ordem_historico) as max"))
            ->where("fiusu_codigo = $fiusu_codigo");
        $ultimo = $this->fetchRow($where);
        return $ultimo->max;
    }
    public function getDadosCadastrante($fiusu_codigo){
        $where = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("fihi" => "filas_historicos"))
            ->join(array("usr" => "usuarios"),"fihi.fihi_usr_historico = usr.usr_codigo" ,array("usr_nome"))
            ->where("fiusu_codigo = $fiusu_codigo")
            ->where("fihi_ordem_historico = 1");
            return $this->fetchRow($where)->toArray();

    }
}