<?php
Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_FilasReguladores extends Elotech_Db_Table_Abstract
{
    protected $_name = 'filas_reguladores';
    protected $_primary = 'fire_codigo';

    public function salvar($data)
    {
        $registro = $this->getReguladorExcluir($data['fila_codigo'], $data['usr_codigo']);
        if ($registro) {
            $data['fire_codigo'] = "$registro->fire_codigo";
        }
        return parent::salvar($data);
    }

    public function listar($data)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("reg" => "filas_reguladores"))
            ->join(array("usr" => "usuarios"), "reg.usr_codigo=usr.usr_codigo", array("usr_nome"))
            ->join(array("fila" => "filas"), "reg.fila_codigo=fila.fila_codigo", array("fila_nome"))
            ->where("fila.fila_codigo = $data")
            ->order("fila_nome");
        $filas = $this->fetchAll($where);
        return $filas;

    }

    public function excluir($fila_codigo, $usr_codigo)
    {
        $registro = $this->getReguladorExcluir($fila_codigo, $usr_codigo);
        if ($registro) {
            $registro->delete();
            return true;
        }
    }

    public function getRegulador($fila_codigo, $usr_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("reg" => "filas_reguladores"))
            ->join(array("usr" => "usuarios"), "reg.usr_codigo=usr.usr_codigo", array("usr_nome"))
            ->where("fila_codigo = $fila_codigo")
            ->where("reg.usr_codigo = $usr_codigo")
            ->order("fire_codigo");
        $regulador = $this->fetchRow($where);
        return $regulador;

    }

    // Função replicada devido ao Zend não permitir excluir ou salvar um registro com JOIN no SELECT
    public function getReguladorExcluir($fila_codigo, $usr_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("reg" => "filas_reguladores"))
            ->where("fila_codigo = $fila_codigo")
            ->where("usr_codigo = $usr_codigo");
        $regulador = $this->fetchRow($where);
        return $regulador;

    }

    public function getReguladorIncluir($fila_codigo, $usr_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("reg" => "filas_reguladores"), "count(*) as qtde")
            ->where("fila_codigo = $fila_codigo")
            ->where("usr_codigo = $usr_codigo");
        $regulador = $this->fetchRow($where);
        if ($regulador->qtde > 0) {
            return false;
        } else {
            return true;
        }
    }
    public function getReguladorFila($fila_codigo, $usr_codigo)
    {
        $where = $this->select()
            ->from(array("fire" => "filas_reguladores"), array("fire_regulador"))
            ->where("fire.usr_codigo = $usr_codigo")
            ->where("fire.fila_codigo = $fila_codigo");
        $regulador = $this->fetchRow($where);

        if ($regulador->fire_regulador == 'S') {
            return true;
        } else {
            return false;
        }
    }
}