<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_FilasUsuario extends Elotech_Db_Table_Abstract
{

    protected $_name = 'filas_usuario';
    protected $_primary = 'fiusu_codigo';

    public function salvar($data)
    {
        return parent::salvar($data);
    }

    public function listar($data_entrada = false, $fila_codigo = false, $usu_codigo = false, $status = false, $unidade = false, $especialidade = false, $procedimento = false, $profissional = false, $tipoatendimento = false, $prioridade = false, $tipo_ordenacao = false)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("fiusu" => "filas_usuario"), array("fiusu_ordem", "fiusu_data_entrada", "fiusu_codigo", "fiusu_status"))
            ->join(array("usu" => "usuario"), "fiusu.usu_codigo = usu.usu_codigo", array("usu_nome", "usu_mae", "usu_datanasc"))
            ->join(array("fipr" => "filas_prioridades"), "fiusu.fipr_codigo = fipr.fipr_codigo", array("fipr_nome", "fipr_codigo"))
            ->join(array("fiti" => "filas_tipoatendimentos"), "fiusu.fiti_codigo = fiti.fiti_codigo", array("fiti_nome", "fiti_codigo"))
            ->join(array("filas" => "filas"), "fiusu.fila_codigo = filas.fila_codigo", array("fila_nome", "fila_codigo", "fila_tipo"));


        if ($status) {
            $where->where("fiusu.fiusu_status = '$status'");
        }

        if ($data_entrada) {
            $where->where("CAST(fiusu_data_entrada AS DATE) = '$data_entrada'");
        }

        if ($fila_codigo) {
            $where->where("fiusu.fila_codigo = $fila_codigo");
        }

        if ($usu_codigo) {
            $where->where("fiusu.usu_codigo = $usu_codigo");
        }

        if ($unidade) {
            $where->where("fiusu.uni_codigo = $unidade");
        }

        if ($especialidade) {
            $where->where("fiusu.esp_codigo = $especialidade");
        }

        if ($procedimento) {
            $where->where("fiusu.proc_codigo = $procedimento");
        }

        if ($profissional) {
            $where->where("fiusu.usr_codigo = $profissional");
        }

        if ($tipoatendimento) {
            $where->where("fiusu.fiti_codigo = $tipoatendimento");
        }

        if ($prioridade) {
            $where->where("fiusu.fipr_codigo = $prioridade");
        }
        if ($tipo_ordenacao) {
            $where->order(new Zend_Db_Expr("fila_nome,CASE
	                WHEN fiusu_status = 'AR' THEN 1
	                WHEN fiusu_status = 'ES' THEN 2
	                WHEN fiusu_status = 'SA' THEN 3 END,fiusu_ordem, fipr_codigo, fiti_codigo"));
        } else {

            $where->order(new Zend_Db_Expr("fila_nome,CASE
	                WHEN fiusu_status = 'ES' THEN 1
	                WHEN fiusu_status = 'AR' THEN 2
	                WHEN fiusu_status = 'SA' THEN 3 END,fiusu_ordem, fipr_codigo, fiti_codigo"));

        }
        $solicitacoes = $this->fetchAll($where);

        return $solicitacoes;
    }

    public function preparaOrdem($fila_codigo = false)
    {

        $configFila = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("filas" => "filas"), array("fila_nome", "fila_codigo"))
            ->join(array("fior" => "filas_tipoordenacao"), "filas.fior_codigo = fior.fior_codigo", array("fior_prioridade", "fior_ordem_prioridade", "fior_tipoatendimento", "fior_ordem_tipoatendimento"))
            ->where("filas.fila_codigo = $fila_codigo");

        $config = $this->fetchRow($configFila);

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("fiusu" => "filas_usuario"), array("fiusu_ordem", "fiusu_data_entrada", "fiusu_codigo", "fiusu_status"))
            ->join(array("fipr" => "filas_prioridades"), "fiusu.fipr_codigo = fipr.fipr_codigo", array("fipr_nome", "fipr_peso"))
            ->join(array("fiti" => "filas_tipoatendimentos"), "fiusu.fiti_codigo = fiti.fiti_codigo", array("fiti_nome", "fiti_peso"))
            ->where("fiusu.fila_codigo = $fila_codigo")
            ->where("fiusu.fiusu_status = 'ES'");


        if ($config->fior_prioridade == 'S' && $config->fior_tipoatendimento == 'N') {
            $where->order(array("fipr_peso ASC", "fiusu_data_entrada ASC"));
        } elseif ($config->fior_prioridade == 'N' && $config->fior_tipoatendimento == 'S') {
            $where->order(array("fiti_peso ASC", "fiusu_data_entrada ASC"));
        } elseif ($config->fior_prioridade == 'S' && $config->fior_tipoatendimento == 'S') {
            if ($config->fior_ordem_prioridade < $config->fior_ordem_tipoatendimento) {
                $where->order(array("fipr_peso ASC", "fiti_peso ASC", "fiusu_data_entrada ASC"));
            } else {
                $where->order(array("fiti_peso ASC", "fipr_peso ASC", "fiusu_data_entrada ASC"));
            }
        } else {
            $where->order(array("fiusu_data_entrada ASC"));
        }
        $solicitacoes = $this->fetchAll($where);
        return $solicitacoes;
    }

    public function atualizaOrdem($ordem = null, $fiusu_codigo = null)
    {

        $where = $this->select()->where("fiusu_codigo = $fiusu_codigo")->getPart(Zend_Db_Table_Select::WHERE);
        $where = $where[0];
        $data = array('fiusu_ordem' => $ordem);
        return $this->update($data, $where);
    }

    public function excluir($id = FALSE)
    {
        $item = $this->fetchRow("fiusu_codigo = $id");
        try {
            if ($item) {
                $item->delete();
            }
        } catch (Exception $ex) {
            die($ex->getMessage());
            $ex->getMessage();
        }
        return true;
    }

    public function getdados($fiusu_codigo)
    {

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("fiusu" => "filas_usuario"))
            ->join(array("usu" => "usuario"), "fiusu.usu_codigo = usu.usu_codigo", array("usu_nome", "usu_codigo", "usu_mae", "usu_cartao_sus", "usu_datanasc", "usu_prontuario", "usu_cpf", "usu_rg"))
            ->join(array("fipr" => "filas_prioridades"), "fiusu.fipr_codigo = fipr.fipr_codigo", array("fipr_nome", "fipr_codigo"))
            ->join(array("fiti" => "filas_tipoatendimentos"), "fiusu.fiti_codigo = fiti.fiti_codigo", array("fiti_nome", "fiti_codigo"))
            ->join(array("filas" => "filas"), "fiusu.fila_codigo = filas.fila_codigo", array("fila_nome", "fila_codigo", "fila_tipo"))
            ->join(array("esp" => "especialidade"), "fiusu.esp_codigo = esp.esp_codigo", array("esp_nome", "esp_codigo"))
            ->join(array("uni" => "unidade"), "fiusu.uni_codigo = uni.uni_codigo", array("uni_desc", "uni_codigo"))
            ->joinLeft(array("usr" => "usuarios"), "fiusu.usr_codigo = usr.usr_codigo", array("usr_nome", "usr_codigo"))
            ->joinLeft(array("med" => "medico"), "fiusu.med_codigo = med.med_codigo", array("med_nome", "med_codigo"))
            ->joinLeft(array("dom" => "domicilio"), "usu.dom_codigo = dom.dom_codigo", array("rua_codigo", "dom_numero"))
            ->joinLeft(array("rua" => "rua"), "dom.rua_codigo = rua.rua_codigo", array("rua_nome"))
            ->where("fiusu.fiusu_codigo = $fiusu_codigo")
            ->order("fiusu_ordem", "fipr_codigo", "fiti_codigo", "fiusu_status");

        $solicitacoes = $this->fetchRow($where);

        return $solicitacoes;
    }

    public function verificaSolicitacoes($usu_codigo,$esp_codigo)
    {

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("fiusu" => "filas_usuario"))
            ->join(array("usu" => "usuario"), "fiusu.usu_codigo = usu.usu_codigo", array("usu_nome", "usu_codigo", "usu_mae", "usu_cartao_sus", "usu_datanasc", "usu_prontuario", "usu_cpf", "usu_rg"))
            ->join(array("fipr" => "filas_prioridades"), "fiusu.fipr_codigo = fipr.fipr_codigo", array("fipr_nome", "fipr_codigo"))
            ->join(array("fiti" => "filas_tipoatendimentos"), "fiusu.fiti_codigo = fiti.fiti_codigo", array("fiti_nome", "fiti_codigo"))
            ->join(array("filas" => "filas"), "fiusu.fila_codigo = filas.fila_codigo", array("fila_nome", "fila_codigo", "fila_tipo"))
            ->join(array("esp" => "especialidade"), "fiusu.esp_codigo = esp.esp_codigo", array("esp_nome", "esp_codigo"))
            ->join(array("uni" => "unidade"), "fiusu.uni_codigo = uni.uni_codigo", array("uni_desc", "uni_codigo"))
            ->joinLeft(array("usr" => "usuarios"), "fiusu.usr_codigo = usr.usr_codigo", array("usr_nome", "usr_codigo"))
            ->joinLeft(array("med" => "medico"), "fiusu.med_codigo = med.med_codigo", array("med_nome", "med_codigo"))
            ->joinLeft(array("dom" => "domicilio"), "usu.dom_codigo = dom.dom_codigo", array("rua_codigo", "dom_numero"))
            ->joinLeft(array("rua" => "rua"), "dom.rua_codigo = rua.rua_codigo", array("rua_nome"))
            ->where("fiusu.usu_codigo = $usu_codigo")
            ->where("fiusu.esp_codigo = $esp_codigo")
            ->where("fiusu.fiusu_status NOT IN ('CA','SA')")
            ->order("fiusu_ordem", "fipr_codigo", "fiti_codigo", "fiusu_status");

        $solicitacoes = $this->fetchAll($where)->toArray();

        return $solicitacoes;
    }

    public function setStatus($fiusu_codigo, $fiusu_status, $motivo = NULL)
    {
        $tbHist = new Application_Model_FilasHistoricos();
        $tbUsr = new Application_Model_Usuarios();
        $array = array(
            'fiusu_codigo' => $fiusu_codigo,
            'fiusu_status' => $fiusu_status

        );
        $arrayHist = array(
            'fiusu_codigo' => $fiusu_codigo,
            'fihi_status' => $fiusu_status

        );
        if ($fiusu_status == "CA") {
            $array['fiusu_ordem'] = null;
            $array['fiusu_motivo_saida'] = $motivo;
            $array['fiusu_data_saida'] = Date("d/m/Y H:i:s");
            $arrayHist['fihi_motivo_saida'] = $motivo;
            $arrayHist['fihi_data_saida'] = Date("d/m/Y H:i:s");
        }
        if ($fiusu_status == "SA") {
            $array['fiusu_ordem'] = null;
        }
        if ($fiusu_status == "ES") {
            $array['fiusu_ordem'] = null;
        }
        $arrayHist['fihi_usr_historico'] = $tbUsr->getUsrAtual()->usr_codigo;
        $arrayHist['fihi_datahora_historico'] = Date("d/m/Y H:i:s");
        $tbFilaUsu = new Application_Model_FilasUsuario();
        $tbFilaUsu->salvar($array);
        $ordemHist = ($tbHist->buscarOrdemHistorico($arrayHist['fiusu_codigo']) + 1);
        $arrayHist['fihi_ordem_historico'] = $ordemHist;
        $tbHist->salvar($arrayHist);

        return true;

    }

    public function imprimir($fiusu_codigo)
    {
        $fiUsu = $this->getdados($fiusu_codigo);

        // dados do paciente
        $tbUsu = new Application_Model_Usuario();
        $usu = $tbUsu->find($fiUsu->usu_codigo)->current();

        $dados = (object)array_merge($fiUsu->toArray(), $usu->toArray());
        $dados->codigo = $fiUsu->fiusu_codigo;

        $end = array();
        $end [] = $usu->usu_end_rua;
        $end [] = $usu->usu_end_nr;
        $end [] = $usu->usu_end_compl;
        $end [] = $usu->usu_end_bairro;
        $end [] = $usu->usu_end_cidade;
        foreach ($end as $k => $item) {
            if (empty($item))
                unset($end[$k]);
        }

        $dados->usu_nome = $usu->usu_nome;
        $dados->usu_endereco = implode(", ", $end);
        //$dados->usu_rua = $usu->usu_end_rua;
        $usuEnd = $tbUsu->getInfo($usu->usu_codigo);
        $dados->rua_nome = $usuEnd->rua_nome;
        $dados->rua_bairro = $usuEnd->rua_bairro;
        $dados->rua_numero = $usuEnd->dom_numero;

        // dados da unidade
        $tbUni = new Application_Model_Unidade();
        $uni = $tbUni->find($fiUsu->uni_codigo)->current();

        $dados->uni_desc = $uni->uni_desc;
        $dados->uni_endereco = $uni->uni_endereco;
        $dados->cnes_telefone = $uni->cnes_telefone;
        $dados->cnes_fax = $uni->cnes_fax;

        // dados da secretaria
        $tbSec = new Application_Model_Secretaria();
        $sec = $tbSec->getDadosSecSaude();

        $dados->secretaria = $sec->nome_secretaria;
        $dados->nome_cidade = $sec->nome_cidade;
        $dados->telefone_secretaria = $sec->telefone_secretaria;

        // dados Profissional Cadastrante
        $tbFilaHist = new Application_Model_FilasHistoricos();
        $usrCad = $tbFilaHist->getDadosCadastrante($fiusu_codigo);

        $dados->cadastrante = $usrCad['usr_nome'];
        return $dados;
    }

    public function getMotivo($fiusu_codigo){
        $where = $this->select()
                      ->from("filas_usuario","fiusu_motivo_saida")
                      ->where("fiusu_codigo = $fiusu_codigo");
        return $this->fetchRow($where);

    }

}