<?php
Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_FilasUsuarioProcedimento extends Elotech_Db_Table_Abstract
{

    protected $_name = 'filas_usuario_procedimento';
    protected $_primary = 'fiproc_codigo';

    public function salvar($data)
    {
        try {
            return parent::salvar($data);
        } catch (Exception $exc) {
            throw new Zend_Validate_Exception("Falha ao realizar a inserção! Erro: " . $exc->getMessage());
        }
    }

    public function excluir($id = FALSE)
    {
        $item = $this->fetchRow("fiproc_codigo = $id");
        try {
            if ($item) {
                $item->delete();
            }
        } catch (Exception $ex) {
            die($ex->getMessage());
            $ex->getMessage();
        }
        return true;
    }

    public function listar($fiusu_codigo){
        $sql = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("fiproc" =>"filas_usuario_procedimento", array("fiproc_codigo", "fiusu_codigo")))
            ->join(array("proc" =>"procedimento"),"fiproc.proc_codigo = proc.proc_codigo",array("proc_codigo","proc_nome", "proc_codigo_sus"))
            ->where("fiproc.fiusu_codigo = $fiusu_codigo");

        return $this->fetchAll($sql); 
    }

}