<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Fornecedor extends Elotech_Db_Table_Abstract {

	protected $_name = 'fornecedor';
	protected $_primary = 'for_codigo';
	protected $_sequence = "seq_for_codigo";

	/**
	 * Buscar os fornecedores
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("for" => "fornecedor"), array("for_codigo", "for_nome"))
			->where("retira_acentos(for_nome) ilike retira_acentos('%$term%')")
			->order("for_nome");

		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $for) {
			$out [] = array(
				"id" => $for->for_codigo,
				"label" => trim($for->for_nome),
				"data" => $for->toArray()
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array()
			);
		}

		return $out;
	}


	public function getFornecedorPorCodigo($codigo) {
		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("for" => "fornecedor"), array("for_nome", "for_cnpj"))
			->where("for_codigo = $codigo");
		return $this->fetchRow($sql)->toArray();
	}

	public function getFornecedorPorProdutoELote($pro_codigo, $lote) {
		if(!$pro_codigo && !$lote){
			return null;
		}
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("f" => "fornecedor"), array("for_nome", "for_cnpj"))
			->join(array("mov" => "movimento"), "f.for_codigo = mov.for_codigo", "")
			->join(array("ite" => "itens_movimento"), "mov.mov_codigo = ite.mov_codigo", "")
			->where("ite.pro_codigo = $pro_codigo")
			->where("ite.ite_lote = '$lote'")
			->where("f.for_nome != 'INVENTARIO'")
			->order("mov.mov_codigo DESC")
			->limit(1);
		return $this->fetchRow($sql);
	}

	// Métod o que salva os fornecedores em BD
	public function salvar(array $data) {
		$for_codigo = parent::salvar($data);
	}

	public function selectTag($id_select = FALSE, $for_codigo = FALSE) {
		if ($id_select == FALSE)
			$id_select = "for_codigo";
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("f" => "fornecedor"), array("for_codigo", "for_nome"))
			->order("for_nome");
		return parent::selectTag($where, "for_nome", NULL, TRUE, TRUE, NULL, $id_select, TRUE, $for_codigo);
	}

	public function getUltimoRegistro() {

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("for" => "fornecedor"), array("for_codigo", "for_nome"))
			->where("retira_acentos(for_nome) ilike retira_acentos('%$term%')")
			->order("for_codigo desc")
			->limit(1);

		$sql = $this->fetchRow($where)->toArray();
		return ($sql);

	}

}
