<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_GradePeriodo extends Elotech_Db_Table_Abstract {

    protected $_name = 'grade_periodo';
	protected $_primary = 'grap_codigo';

    public function salvar(array $data) {
	$this->notEmpty(array("coni_codigo","grap_dia","grap_hora_inicial","grap_hora_final"), $data);
        return parent::salvar($data);
    }
	
	
    public function getHorariosDia($coni_codigo=FALSE,$data=FALSE,$condiAgeCod=FALSE){
            //die("aabbba");
            $where = $this->select()
                             ->setIntegrityCheck(FALSE)
                             ->from(array("grap"=>"grade_periodo"),array("grap_hora_inicial as hora_inicial","grap_hora_final as hora_final"))
                             ->where("coni_codigo=?",$coni_codigo)
                             ->where("grap_dia=?",$data);

            $horarios = $this->fetchAll($where);
            if(count($horarios) < 1){
                if ($condiAgeCod) {
                    $tbConH = new Application_Model_ConvenioHorarios();
                    $horarios = $tbConH->getHorarios($coni_codigo,$condiAgeCod);
                } else {
                    $horarios = NULL;
                }
            }
            return $horarios;
    }
    
    public function getPeriodosGrade($coni_codigo = FALSE,$data = FALSE){
        $where = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("grade" => "grade_periodo"), array("grade_encaixe as conh_encaixe", "grade_cota as conh_cota_dia", "grade_intervalo as conh_intervalo"))
            ->where("coni_codigo=$coni_codigo AND grap_dia='$data'");
        $sql = $this->fetchAll($where)->toArray();
        return $sql;
    }
    
    public function excluir($coni_codigo=FALSE, $data=FALSE){

        $item = $this->fetchAll("coni_codigo=$coni_codigo AND grap_dia='$data'");
        if($item) { 
            foreach ($item as $value) {
                $value->delete();
            }
        }
    }

    public function excluirPorConiCodigo($coni_codigo){
        $item = $this->fetchAll("coni_codigo=$coni_codigo");
        if ($item) {
            foreach ($item as $i)
                $i->delete();
        }
        return true;
    }

  
}
