<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_HistoricoDataHora extends Elotech_Db_Table_Abstract {

    protected $_name = 'historico_data_hora';
    protected $_primary = 'hdh_codigo';
    // protected $_sequence = 'seq_hdh_codigo';
    // protected $_dependentTables = array('Atendimento');)

    public function salvar(array $data) {
		throw new Zend_Validate_Exception( "Este método ainda não possui validações", 1000);
        return parent::salvar($data);
    }

    // Pega dados unidade, usuarios, usuarios e os dados do seu domicilio
    public function getDadosHistoricoDataHora($usrCodigo = false, $uniCodigo = false, $dataInicio = false, $dataFim = false) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("hdh" => "historico_data_hora"), array("hdh_agendamento_cadastro","hdh_agendamento_recepcionado","hdh_preconsulta_inicio","hdh_preconsulta_fim","hdh_atendimento_inicio","hdh_atendimento_fim"))
                ->join(array("age" => "agendamento"), "age.age_codigo=hdh.age_codigo", "")
                ->join(array("uni" => "unidade"), "age.uni_codigo=uni.uni_codigo", "uni_desc")
                ->join(array("usu" => "usuario"), "usu.usu_codigo=age.usu_codigo", "usu_nome")
                ->join(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", "usr_nome")
                ->where("age.age_data >= '$dataInicio'")
                ->where("age.age_data <= '$dataFim'")
                ->order(array("uni.uni_desc","usr.usr_nome","age.age_data","usu.usu_nome"));
        if($uniCodigo){
            $sql->where("age.uni_codigo =$uniCodigo");
        }
        if($usrCodigo){
            $sql->where("usr.usr_codigo =$usrCodigo");
        }
//        die($sql);
        return $this->fetchAll($sql);
    }

    /**
     * Exclusão Lógica;
     * @param type $conv_codigo
     * @return type 
     */
    public function excluir($age_codigo) {
        $item = $this->fetchRow("age_codigo=$age_codigo");
        if ($item)
            $item->delete();
        return true;
    }

}
