<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_InstituicaoPermanencia extends Elotech_Db_Table_Abstract
{

    protected $_name = 'instituicao_permanencia';
    protected $_primary = 'ipe_codigo';

    public function salvar($dados)
    {
        try {
            return parent::salvar($dados);
        } catch (Exception $ex) {
            die($ex->getMessage());
            throw new Zend_Validate_Exception("Falha ao salvar Instituição de Permanência: " . $ex->getMessage());
        }
    }

    public function excluirPorDomicilio($dom_codigo)
    {
        $item = $this->fetchRow("dom_codigo = $dom_codigo");

        if ($item) {
            $item->delete();
        }
        return true;
    }

    public function getDadosPorDomicilio($dom_codigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("ipe" => "instituicao_permanencia"))
            ->where("dom_codigo =?", $dom_codigo);
        return $this->fetchRow($sql);
    }
}
