<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Inventario extends Elotech_Db_Table_Abstract {

  protected $_name = 'inventario';
  protected $_primary = 'inv_codigo';
  protected $_dependentTables = array();

  public function salvar(array $data) {
    throw new Zend_Validate_Exception("Este método ainda não possui validações", 1000);
    return parent::salvar($data);
  }

  public function getInventarioById($data, $grupo, $setor, $situacao = 'A') {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["inv" => "inventario"], "inv_codigo")
			->where("inv_data = ?", date("Y-m-d", strtotime(str_replace('/', '-', $data))))
			->where("gru_codigo = ?", $grupo)
			->where("set_codigo = ?", $setor)
			->where("inv_status = ?", $situacao)
      ->limit(1);
		return $this->fetchRow($sql);
	}

  public function getItensInventario() {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(["inv" => "inventario"], ["inv_codigo", "inv_data", "inv_responsavel", "inv_equipe", "inv_status", "inv_data_finalizacao"])
      ->join(["gru" => "grupo"], "gru.gru_codigo = inv.gru_codigo", ["gru_nome"])
      ->join(["set" => "setor"], "set.set_codigo = inv.set_codigo", ["set_nome"])
      ->order("inv.inv_codigo DESC")
      ->limit(40);
    return $this->fetchAll($sql);
  }

}
