<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_ItensMovimento extends Elotech_Db_Table_Abstract {

	protected $_name = 'itens_movimento';
	protected $_primary = 'ite_codigo';
	protected $_sequence = 'seq_ite_codigo';

	/**
	 * Persiste um item (insert ou update)
	 * @param array $data array de chave=>valor, cada chave corresponde a um atributo
	 * @return int primary key do item (nextVal para insert)
	 */
	public function salvar(array $data) {

		$this->emptyToUnset($data, false);

		try {
			$tbMov = new Application_Model_Movimento();
			$mov = $tbMov->getMovimento($data['mov_codigo']);
			if ($mov->mov_tipo != "E") {
				$data['set_codigo'] = $mov->set_saida;
				$this->verificaSeAindaTemEstoque($data);
				unset($data['set_codigo']);
                unset($data['qntd_anterior']);
			}

			return parent::salvar($data);
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao salvar os itens da movimentação!<br/>" . $ex->getMessage());
		}

	}

	private function verificaSeAindaTemEstoque($data) {
		$tbSal = new Application_Model_Saldo();
		$tbUsr = new Application_Model_Usuarios();
		$usr = $tbUsr->getUsrAtual();
		$val = $tbSal->getSaldoAtual($data['pro_codigo'], $data['set_codigo'], $data['ite_lote'], $data['ite_validade']);
		$val += $data['qntd_anterior'];

		if ($val < $data['ite_quantidade']) {
		    $pro_nome = (new Application_Model_Produto())->getProduto($data['pro_codigo'])->pro_nome;
			throw new Zend_Validate_Exception("Este produto já não possui saldo suficiente. <br/><br/>
			 <b>Produto:</b> $pro_nome<br/> <b>Lote:</b> $data[ite_lote] <br/> <b>Quantidade solicitada:</b> $data[ite_quantidade],<br/> <b>Quantidade em estoque:</b> $val <br/><br/> Atualize o mesmo para obter a quantidade correta.");
		} else {
			return true;
		}
	}

	public function salvarItensMovimentacaoRequisicao($dados) {
		try {
			return parent::salvar($dados);
		} catch (Exception $exc) {
			throw new Zend_Validate_Exception("Falha ao salvar os itens da movimentação!<br/>" . $exc->getMessage());
		}
	}

	public function getProdutosPorMovimento($mov_codigo = FALSE, $pro_codigo = FALSE) {

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("mov" => "movimento"), "mov_tipo")
			->join(array("ite" => "itens_movimento"), "mov.mov_codigo=ite.mov_codigo", array("ite_codigo", "pro_codigo", "ite_quantidade", "ite_validade", "ite_lote", "ite_vlrunit", "ite_dose", "ite_vlrtotal", "fab_descricao" => "(select fab_descricao from itens_movimento im join fabricante f on f.fab_codigo=im.fab_codigo where im.pro_codigo = ite.pro_codigo  and im.ite_lote = ite.ite_lote limit 1)"))
			->join(array("pro" => "produto"), "pro.pro_codigo=ite.pro_codigo", "pro_nome")
			->where("ite.mov_codigo=?", $mov_codigo);

		if ($pro_codigo)
			$where->where("ite.pro_codigo=$pro_codigo");

		return $this->fetchAll($where);
	}

	public function deletar($ite_codigo = FALSE) {
		$item = $this->fetchRow("ite_codigo=$ite_codigo");
		if ($item)
			$item->delete();

		return true;

	}

	public function deletarItem($ite_codigo = FALSE, $mov_codigo) {
		$item = $this->fetchRow("ite_codigo=$ite_codigo AND mov_codigo=$mov_codigo");
		if ($item)
			$item->delete();

		return true;

	}

	public function verificaSeMovimentou($ite_lote = FALSE, $ite_codigo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("im" => "itens_movimento"), array("(select count(*)
                                                                        from itens_movimento im2
                                                                        join movimento mov2
                                                                          on mov2.mov_codigo=im2.mov_codigo
                                                                        where im2.pro_codigo = im.pro_codigo
                                                                          and mov2.mov_data >= mov.mov_data
                                                                          and im2.ite_codigo <> $ite_codigo
                                                                          and im2.ite_codigo > $ite_codigo
                                                                          " . ($ite_lote != "" || $ite_lote != "SEM_LOTE" ? "and im2.ite_lote ilike '%$ite_lote%'" : "") . "
                                                                        ) as movs"))
			->join(array("mov" => "movimento"), "mov.mov_codigo=im.mov_codigo", "")
			->where("ite_codigo=$ite_codigo");


		return $this->fetchRow($where);
	}

	public function getValorPorProdutoLote($pro_codigo = FALSE, $ite_lote = FALSE) {
		$where_entrada = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ite" => "itens_movimento"), array("(coalesce(ite_quantidade,null,0) * coalesce(ite_vlrunit,null,0)) as t_entrada", "sum(ite_quantidade) as qtde_entrada"))
			->join(array("mov" => "movimento"), "mov.mov_codigo=ite.mov_codigo", "")
			->where("pro_codigo=$pro_codigo")
			->where("ite_lote='$ite_lote'")
			->where("ite_vlrunit is not null")
			->where("mov_tipo='E'")
			->where("mov_entrada in ('E-C', 'E-DL', 'E-CONV', 'E-P', 'E-EVENTUAL', 'E-O', 'E-TP', 'E-INEX', 'E')")
			->group("t_entrada");

		$where_saida = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ite" => "itens_movimento"), array("(coalesce(ite_quantidade,null,0) * coalesce(ite_custo_medio,null,0)) as t_saida", "sum(ite_quantidade) as qtde_saida"))
			->join(array("mov" => "movimento"), "mov.mov_codigo=ite.mov_codigo", "")
			->where("pro_codigo=$pro_codigo")
			->where("ite_lote='$ite_lote'")
			->where("mov_tipo='S'")
			->group("t_saida");
		$array_valores = array("entradas" => $this->fetchAll($where_entrada)->toArray(),
			"saidas" => $this->fetchAll($where_saida)->toArray());
		return $array_valores;
	}

	public function getDadosProdutoHorus($pro_codigo, $pro_lote) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from("itens_movimento", array("pro_codigo", "ite_lote", "ite_validade", "ite_vlrunit", "fab_codigo"))
			->where("pro_codigo = ?", $pro_codigo)
			->where("ite_lote = ?", $pro_lote)
			->order("ite_codigo")
			->limit(1);
		return $this->fetchRow($where);
	}

	public function getItensCurvaAbc($data_inicial = FALSE, $data_final = FALSE, $set_codigo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ite" => "itens_movimento"), array("sum(ite_quantidade) as total_qtde",
				" (select sum(ite_custo_medio) / count(ite_custo_medio)
                                                                        from itens_movimento im2
                                                                        join movimento m2
                                                                          on m2.mov_codigo=im2.mov_codigo
                                                                       where im2.pro_codigo = pro.pro_codigo
                                                                         and ite_custo_medio is not null
                                                                         AND (mov_data >= '$data_inicial')
                                                                         AND (mov_data <= '$data_final')
                                                                         AND set_saida = $set_codigo) as vlr_unitario",
				"COALESCE((select sum(COALESCE(ite_custo_medio,NULL,0)) / count(COALESCE(ite_custo_medio,NULL,0))
                                                                        from itens_movimento im2
                                                                        join movimento m2
                                                                          on m2.mov_codigo=im2.mov_codigo
                                                                       where im2.pro_codigo = pro.pro_codigo
                                                                         and ite_custo_medio is not null
                                                                         AND (mov_data >= '$data_inicial')
                                                                         AND (mov_data <= '$data_final')
                                                                         AND set_saida = $set_codigo),NULL,0) * sum(ite_quantidade) as vlr_total_item"))
			->join(array("mov" => "movimento"), "mov.mov_codigo=ite.mov_codigo", "")
			->join(array("pro" => "produto"), "ite.pro_codigo=pro.pro_codigo", array("pro_nome", "pro_codigo"))
			->group(array("pro.pro_codigo", "pro_nome", "vlr_unitario"))
			->order("vlr_total_item DESC")
			->where("mov_tipo IN ('S', 'T')");
		//die($where);
		if ($data_inicial)
			$where->where("mov_data >= '$data_inicial'");

		if ($data_final)
			$where->where("mov_data <= '$data_final'");

		if ($set_codigo)
			$where->where("set_saida = $set_codigo");
		return $this->fetchAll($where);
	}

	public function getItensMovimentacoesPorSetor($set_codigo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ite" => "itens_movimento"))
			->join(array("mov" => "movimento"), "ite.mov_codigo=mov.mov_codigo", array(""));

		if ($set_codigo)
			$where->where("mov.set_entrada = '$set_codigo' OR mov.set_saida = '$set_codigo'");

		return $this->fetchAll($where);
	}

	public function desabilitaTrigger01() {
		try {
			$sql = $this
				->getDefaultAdapter()
				->query("ALTER TABLE social.itens_movimento DISABLE TRIGGER atualizaestoque;")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao desabilitar trigger: " . $ex->getMessage());
		}
	}

	public function desabilitaTrigger02() {
		try {
			$sql = $this
				->getDefaultAdapter()
				->query("ALTER TABLE social.itens_movimento DISABLE TRIGGER atualizaestoquedel;")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao desabilitar trigger: " . $ex->getMessage());
		}
	}

	public function desabilitaTrigger03() {
		try {
			$sql = $this
				->getDefaultAdapter()
				->query("ALTER TABLE social.itens_movimento DISABLE TRIGGER atualizaestoqueupdate;")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao desabilitar trigger: " . $ex->getMessage());
		}
	}

	public function desabilitaTrigger04() {
		try {
			$sql = $this
				->getDefaultAdapter()
				->query("ALTER TABLE social.itens_movimento DISABLE TRIGGER atualizahorus;")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao desabilitar trigger: " . $ex->getMessage());
		}
	}

	public function habilitaTrigger01() {
		try {
			$sql = $this
				->getDefaultAdapter()
				->query("ALTER TABLE social.itens_movimento ENABLE TRIGGER atualizaestoque;")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao habilitar triggers: " . $ex->getMessage());
		}
	}

	public function habilitaTrigger02() {
		try {
			$sql = $this
				->getDefaultAdapter()
				->query("ALTER TABLE social.itens_movimento ENABLE TRIGGER atualizaestoquedel;")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao habilitar triggers: " . $ex->getMessage());
		}
	}

	public function habilitaTrigger03() {
		try {
			$sql = $this
				->getDefaultAdapter()
				->query("ALTER TABLE social.itens_movimento ENABLE TRIGGER atualizaestoqueupdate;")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao habilitar triggers: " . $ex->getMessage());
		}
	}

	public function habilitaTrigger04() {
		try {
			$sql = $this
				->getDefaultAdapter()
				->query("ALTER TABLE social.itens_movimento ENABLE TRIGGER atualizahorus;")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao habilitar triggers: " . $ex->getMessage());
		}
	}


	public function excluiItensMovimentacoesPorSetor($setores = FALSE, $data = FALSE) {
		// Se data vier preenchida faz consula por data
		if ($data)
			$sqlData = "AND mov_data <= '$data'";

		try {
			$sql = $this
				->getDefaultAdapter()
				->query("DELETE FROM social.itens_movimento WHERE mov_codigo IN (
                                            SELECT DISTINCT
                                                mov_codigo
                                            FROM
                                                social.movimento
                                            WHERE
                                                (set_entrada IN ($setores) OR
                                                set_saida IN ($setores))
                                                $sqlData)")
				->fetchAll();
			return $sql;
		} catch (Exception $ex) {
			throw new Zend_Validate_Exception("Falha ao excluir item: " . $ex->getMessage());
		}
		/*$item = $this->getItensMovimentacoesPorSetor($set_codigo);
		if ($item) {
			foreach ($item as $value){
				try{
					$value->delete();
				} catch (Exception $exc) {
					throw new Zend_Validate_Exception($exc->getMessage());
				}
			}
		}
		return true;*/
	}


	public function getCustoMedio($pro_codigo, $ite_lote) {
		$this->getValorPorProdutoLote($pro_codigo, $ite_lote);
	}

	public function verificaSeJaDispensou($params = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("im" => "itens_movimento"), "count(*) as qtde")
			->join(array("mov" => "movimento"), "mov.mov_codigo=im.mov_codigo", "")
			->where("mov_data='$params[mov_data]'")
			->where("usu_codigo='$params[usu_codigo]'")
			->where("pro_codigo='$params[pro_codigo]'")
			->where("ite_lote='$params[ite_lote]'");
		$qtde = $this->fetchRow($where);
		if ($qtde->qtde > 0) {
			throw new Zend_Validate_Exception("O medicamento deste lote, validade, data e paciente já foi retirado");
			return false;
		} else {
			//  throw new Zend_Validate_Exception("Esse medicamento neste lote nessa validade, nesta data, para esse paciente já foi pego".$exc->getMessage());
			return true;
		}
	}

	public function verificaSeJaDispensouParcial($params = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("im" => "itens_movimento"), "count(*) as qtde")
			->join(array("mov" => "movimento"), "mov.mov_codigo=im.mov_codigo", "")
			->where("mov_data='$params[mov_data]'")
			->where("usu_codigo='$params[usu_codigo]'")
			->where("pro_codigo='$params[pro_codigo]'")
			->where("ite_lote='$params[ite_lote]'");
		$qtde = $this->fetchRow($where);
		if ($qtde->qtde > 0 && $params['ite_qtde_pendente'] < 0) {
			throw new Zend_Validate_Exception("O medicamento deste lote, validade, data e paciente já foi retirado");
			return false;
		} else {
			//  throw new Zend_Validate_Exception("Esse medicamento neste lote nessa validade, nesta data, para esse paciente já foi pego".$exc->getMessage());
			return true;
		}
	}

	public function getValorRelatorioMovimentacaoClassificacaoSaida($lote = FALSE, $pro_codigo = FALSE) {

		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("ite" => "social.itens_movimento"), array("ite_vlrunit" => "ite_custo_medio"))
			->join(array("mov" => "social.movimento"), "ite.mov_codigo = mov.mov_codigo", "mov_data")
			->where("mov.mov_tipo = 'E' and ite.ite_lote = '$lote' and ite.pro_codigo = $pro_codigo")
			->order("mov.mov_data desc")
			->limit(1);

		return $this->fetchRow($sql);
	}

	public function getProtocoloHorus($ite_codigo=NULL){
		$protocolo = null;
		if($ite_codigo){
			$protocolo = $this->fetchRow("ite_codigo=$ite_codigo")->protocolo_horus;
		}
		return $protocolo;
	}

	public function getCodigoRegistroProtocoloHorus($protocolo){
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("hp" => "horus_protocolo"), "hp_registro")
			->where("hp_nu_protocolo = '$protocolo'");
//		die($sql);
		return $this->fetchRow($sql)->hp_registro;
	}

	public function getItensEntradaPorProduto($produto, $setor, $data_inicial, $desconsideraInventario) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("mov" => "movimento"), array("mov_data"))
			->join(array("ite" => "itens_movimento"), "ite.mov_codigo=mov.mov_codigo", array("ite_codigo", "COALESCE(ite_quantidade,0) as ite_quantidade", "COALESCE(ite_vlrunit,0) as ite_vlrunit", "ite_custo_medio", "pro_codigo", "mov_codigo"))
			->where("mov_tipo = 'E'")
			->order(array("mov_data ASC", "ite_codigo ASC"));

		if ($produto)
			$where->where("ite.pro_codigo = $produto");

		if ($setor)
			$where->where("mov.set_entrada = $setor");

		if ($data_inicial)
			$where->where("mov.mov_data >= '$data_inicial'");

		if ($desconsideraInventario)
			$where->where("mov.mov_entrada != 'I'");
			$where->where("mov.req_codigo IS NULL");

		//die($where);

		return $this->fetchAll($where);
	}

	public function getItensSaidaPorProduto($produto, $setor, $data_inicial) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("mov" => "movimento"), array("mov_data"))
			->join(array("ite" => "itens_movimento"), "ite.mov_codigo=mov.mov_codigo", array("ite_codigo", "pro_codigo", "ite_lote", "COALESCE(ite_quantidade,0) as ite_quantidade", "mov_codigo", "ite_validade"))
			->where("mov_tipo = 'S'")
			->order(array("mov_data ASC", "ite_codigo ASC"));

		if ($produto)
			$where->where("ite.pro_codigo = $produto");

		if ($setor)
			$where->where("mov.set_saida = $setor");

		if ($data_inicial)
			$where->where("mov.mov_data >= '$data_inicial'");

		//die($where);

		return $this->fetchAll($where);
	}

	public function calculaCustoMedio($valor_unitario, $quantidade, $data_movimento, $produto) {

		/*
		 *
		 * Para cálculo do custo médio está sendo usada a seguinte fórmula:
		 *
		 *             CM = (VTE - VTS) / (NQTD)
		 *
		 * Onde:
		 *
		 * VTE (Valor total de entrada) = Valor unitário * Quantidade do item
		 * VTS (Valore total de saída) = 0, já que não é informado o valor na saída
		 * NQTD (Nova quantidade) = Posição de estoque na data do movimento + Quantidade informada
		 *
		 */

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("pro" => "produto"), array(
				"(
				(SELECT SUM(COALESCE(sal.sal_qtde,0)) FROM saldo sal WHERE sal.pro_codigo = $produto)
				-
                (COALESCE(SUM(CASE WHEN (mov.mov_tipo in ('E','T')) THEN ite.ite_quantidade ELSE 0 END),0))
                +
                (COALESCE(SUM(CASE WHEN (mov.mov_tipo in ('S','T')) THEN ite.ite_quantidade ELSE 0 END),0))
                ) as saldo_inicial"
			))
			->join(array("ite" => "itens_movimento"), "ite.pro_codigo = $produto", "")
			->join(array("mov" => "movimento"), "ite.mov_codigo = mov.mov_codigo", "")
			->where("mov.mov_data >= '$data_movimento'")
			->where("pro.pro_codigo = $produto")
			->group(array("pro.pro_codigo", "pro.pro_nome"))
			->order("pro_nome");

		$saldo = $this->fetchRow($where)->saldo_inicial;

		$custo_medio = 0;
		if ($saldo >= 0) {
			$saldo_total = $saldo + $quantidade;

			$custo_total = $quantidade * $valor_unitario;

			$custo_medio = $custo_total / $saldo_total;
		}
		return round($custo_medio,4);

	}

	public function buscaCustoMedioEValorUnitario($lote, $produto, $data_movimento) {

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ite" => "itens_movimento"), array("COALESCE(ite_custo_medio, 0) as ite_custo_medio", "ite_vlrunit"))
			->join(array("mov" => "movimento"), "ite.mov_codigo = mov.mov_codigo", "")
			->where("mov.mov_data <= '$data_movimento'")
			->where("ite.pro_codigo = $produto");
		if($lote){
			$where->where("ite.ite_lote = '$lote'");
		}else{
			$where->where("ite.ite_lote is null");
		}
		$where->where("mov.mov_tipo = 'E'")
			->where("ite.ite_custo_medio IS NOT NULL")
			->order("ite_codigo DESC");

//		die($where);
		$valores = $this->fetchRow($where);
		return array(
			"ite_custo_medio" => round($valores->ite_custo_medio,4),
			"ite_vlrunit" => round($valores->ite_vlrunit,4)
		);

	}

	public function buscaCustoMedio($lote, $produto, $data_movimento) {

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("ite" => "itens_movimento"), array("COALESCE(ite_custo_medio, 0) as ite_custo_medio"))
			->join(array("mov" => "movimento"), "ite.mov_codigo = mov.mov_codigo", "")
			->where("mov.mov_data <= '$data_movimento'")
			->where("ite.pro_codigo = $produto");
			if($lote){
				$where->where("ite.ite_lote = '$lote'");
			}else{
				$where->where("ite.ite_lote is null");
			}
			$where->where("mov.mov_tipo = 'E'")
			->where("ite.ite_custo_medio IS NOT NULL")
			->order("ite_codigo DESC");

		$custo_medio = $this->fetchRow($where)->ite_custo_medio;
		return round($custo_medio,4);

	}

	public function atualizaCustoMedio($dados)
	{
		return parent::salvar($dados);
	}

}
