<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_ItensMovimentoAux extends Elotech_Db_Table_Abstract {

    protected $_name = 'itens_movimento_aux';
    protected $_primary = 'ite_aux_codigo';
    protected $_sequence = 'itens_movimento_aux_ite_aux_codigo_seq';

	/**
	 * Persiste um item (insert ou update)
	 * @param array $data array de chave=>valor, cada chave corresponde a um atributo
	 * @return int primary key do item (nextVal para insert) 
	 */
    public function salvar(array $data) {
        $this->peloMenosUm(array("ite_aux_quantidade"), $data);
        $this->emptyToUnset($data);

        try{
            $tbMov = new Application_Model_Movimento();
            $mov = $tbMov->getMovimento($data['mov_codigo']);
            
            if($mov->mov_tipo != "E"){
                $data['set_codigo'] = $mov->set_saida;
                $this->verificaSeAindaTemEstoque($data);
                unset($data['set_codigo']);
            }
            return parent::salvar($data);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao salvar os itens da movimentação na tabela auxiliar!".$ex->getMessage());
        }
        
    }
    
    private function verificaSeAindaTemEstoque($data){
        $tbSal = new Application_Model_Saldo();
        $tbUsr = new Application_Model_Usuarios();
        $usr = $tbUsr->getUsrAtual();
        $val = $tbSal->getSaldoAtual($data['pro_codigo'], $data['set_codigo'], $data['ite_lote'], $data['ite_validade']);
        //die($val ."<". $data[ite_quantidade]);
        if($val < $data[ite_quantidade]){
            throw new Zend_Validate_Exception("Este produto já não possui saldo suficiente. Atualize o mesmo para obter a quantidade correta.");
        }else{
            return true;
        }
    }

    public function deletar($ite_codigo=FALSE){
        $item = $this->fetchRow("ite_aux_codigo=$ite_codigo");
        if($item)
            $item->delete();

        return true;

    }

    public function deletarItem($ite_codigo=FALSE, $mov_codigo){
        $item = $this->fetchRow("ite_aux_codigo=$ite_codigo AND mov_codigo=$mov_codigo");
        if($item)
            $item->delete();
        
        return true;
        
    }

    public function deletarItemPorProduto($pro_codigo=FALSE, $mov_codigo){
        $item = $this->fetchRow("pro_codigo=$pro_codigo AND mov_codigo=$mov_codigo");
        if($item)
            $item->delete();

        return true;

    }

    public function getByUsuarios($usrCodigo){
        $tbUsr = new Application_Model_Usuarios();
        $set_codigo = $tbUsr->getUsrAtual()->set_codigo;
        $where = $this->select(FALSE)
            ->distinct()
            ->from(array("im" => "itens_movimento_aux"))
            ->join(array("mov"=>"movimento"),"mov.mov_codigo=im.mov_codigo","")
            ->where("im.usr_codigo=?", $usrCodigo);
            //->where("( mov.set_entrada=$set_codigo OR mov.set_saida=$set_codigo )");
//        die($where);
        return $this->fetchAll($where);
    }

}
