<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Leito extends Elotech_Db_Table_Abstract {

    protected $_name = 'leito';
    protected $_primary = 'lei_codigo';
    protected $_dependentTables = array('LeitoGrade');
    protected $_referenceMap = array(
        'Paciente' => array(
            'columns' => 'usu_codigo',
            'refTableClass' => 'Application_Model_Usuario',
            'refColumns' => 'usu_codigo'
        )
    );

    public function salvar(array $data) {
        return parent::salvar($data);
    }

    public function buscar($lei_codigo=FALSE, $usu_codigo=FALSE){
		if(!$usu_codigo && !$lei_codigo)
			throw new Zend_Validate_Exception( "É preciso informar o código do leito, ou o código do paciente" );
		
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("lei"=>"leito"))
				->joinLeft(array("pac"=>"paciente_leito"),"pac.lei_codigo=lei.lei_codigo","usu_codigo");
		
		if($usu_codigo)
			$where->where("usu_codigo=?",$usu_codigo);
		
		if($lei_codigo)
			$where->where("lei.lei_codigo=?",$lei_codigo);
		
		return $this->fetchRow($where);
	}
        
    public function buscarLeitoLivre($qua_codigo=FALSE){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("lei"=>"leito"))
                      ->where("lei_codigo not in (select pl.lei_codigo 
                                                    from paciente_leito pl
                                                    join internacao_observacao io
                                                      on io.io_codigo = pl.io_codigo
                                                   where io_situacao_internacao = 2)")
                      ->where("qua_codigo=?",$qua_codigo);
        return $this->fetchRow($where);
    }
    
    public function buscarTodosLeitosLivres($lei_codigo){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("l"=>"leito"),array("lei_numero","lei_codigo"))
                      ->joinLeft(array("q"=>"quarto"),"l.qua_codigo = q.qua_codigo",array("apt_codigo","qua_andar","qua_numero"))
                      ->where("lei_ocupado != true or lei_codigo = ?",$lei_codigo);
        return $this->fetchAll($where)->toArray();
    }
    
    public function atualizaLeito($antigo, $leito){
        $this->atualiza2($antigo);
        $this->atualiza1($leito);
    }
    
    public function atualiza1($leito){
        $data = array ('lei_ocupado' => true);
        return $this->update($data, 'lei_codigo = '.$leito);
    }
    
    public function atualiza2($antigo){
        $data = array ('lei_ocupado' => 0);
        return $this->update($data, 'lei_codigo = '.$antigo);
    }

}
