<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_LeitoGradeCategoria extends Elotech_Db_Table_Abstract {

  protected $_name = 'leito_grade_categoria';
  protected $_primary = 'lgc_codigo';

  public function salvar(array $data) {
    if(empty($data['lgc_codigo']))
      $this->notEmpty(array("lgc_descricao"), $data);

    $this->peloMenosUm(array("lgc_descricao"), $data);
    return parent::salvar($data);
  }
  /**
  * Retorna o nome da categoria
  * @param int $lgc_codigo
  * @return string
  */

  public function getNomeCategoria($lgc_codigo){
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("lgc"=>"leito_grade_categoria"))
      ->where("lgc_codigo = ?",$lgc_codigo);
    return $this->fetchRow($where)->lgc_descricao;
  }

  public function getCategorias(){
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("lgc"=>"leito_grade_categoria"))
      ->order("lgc_descricao");
    return $this->fetchAll($sql);
  }

  public function getCategoriasById($lgc_codigo){
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(["lgc" => "leito_grade_categoria"])
      ->where("lgc_codigo = ?", $lgc_codigo)
      ->order("lgc_descricao");
    return $this->fetchAll($sql);
  }

  public function pesquisarCategoria($dados) {
    $where = $this->select(true);
    if (is_string($dados))
      $where->where("lgc_descricao ilike '%$dados%'");

    return $this->fetchAll($where);
  }

  public function editar($id){
    $line = $this->fetchRow("lgc_codigo=$id");
    return $line;
  }

  public function excluir($id){
    $tbLGM = new Application_Model_LeitoGradeModelo();
    $filhos = $tbLGM->fetchAll("lgc_codigo = $id")->toArray();
    if(!empty($filhos)){
      throw new Zend_Validate_Exception("Existem medicamentos vinculados a este modelo. Remova-os antes de excluir esse modelo.");
      return false;
    }

    $item = $this->fetchRow("lgc_codigo = $id");
    if ($item)
      $item->delete();

    return true;
  }

}
