<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_LeitoGradeModelo extends Elotech_Db_Table_Abstract {

  protected $_name = 'leito_grade_modelo';
  protected $_primary = 'lgm_codigo';
  // protected $_dependentTables = array('LeitoGradeModeloItens');

  public function salvar(array $data) {
    if($data['lgm_codigo'] == "_empty")
      unset($data['lgm_codigo']);

    return parent::salvar($data);
  }

  public function getModelos($lgc_codigo) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(['lgm' => 'leito_grade_modelo'])
      ->join(['pro' => 'produto'], 'lgm.pro_codigo = pro.pro_codigo', 'pro_nome')
      ->join(['adm' => 'tb_administracao_produto'], 'lgm.adm_codigo = adm.adm_codigo', ['adm_nome', 'adm_sigla'])
      ->where('lgc_codigo = ?', $lgc_codigo)
      ->order('lgm_codigo');
    return $this->fetchAll($sql);
  }

  /**
  * Retorna o nome da categoria
  * @param int $lgc_codigo
  * @return string
  */
  public function getNomeCategoria($lgc_codigo) {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("lgc"=>"leito_grade_categoria"))
      ->where("lgc_codigo = ?",$lgc_codigo);
    return $this->fetchRow($where)->lgc_descricao;
  }

  public function getCategorias() {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("lgc"=>"leito_grade_categoria"))
      ->order("lgc_descricao");
    return $this->fetchAll($where);
  }

  public function getModelo($lgm_codigo) {
    $tbLGMI = new Application_Model_LeitoGradeModeloItens();

    $modelo = $this->fetchRow("lgm_codigo=$lgm_codigo");
    $produtos = $tbLGMI->getModelo($lgm_codigo);

    $out = array(
      "intervalo" => $modelo->lgm_intervalo,
      "repeticoes" => $modelo->lgm_repeticoes,
      "produtos" => $produtos->toArray()
    );
    return $out;
  }

  public function excluir($id) {
    $item = $this->fetchRow("lgm_codigo = " . $id);
    $item->delete();
    return true;
  }

  public function getModeloByCategoria($lgc_codigo){
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(["lgm" => "leito_grade_modelo"])
      ->where("lgc_codigo = ?", $lgc_codigo)
      ->order("lgm_codigo");
    return $this->fetchAll($sql);
  }

}
