<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_LeitoGradeProdutos extends Elotech_Db_Table_Abstract
{

    protected $_name = 'leito_grade_produtos';
    protected $_primary = 'lgp_codigo';


    public function salvar($data)
    {

        return parent::salvar($data);
    }

    public function cancelar($lgra_codigo)
    {

        // se houver medicamentos reservados: devolver
        $reservados = $this->buscarRerservados($lgra_codigo);
           foreach ($reservados as $pro){
               $pro['lgp_status'] = "C";
               $this->salvar($pro);
           }
    }

    /**
     * Altera o status da grade
     * @param Zend_Db_Table_Row_Abstract $grade
     * @param int $status
     * @return bool
     */
    public function alterarStatus($produtos, $status = 'R')
    {

        foreach ($produtos as $pro) {

            $pro['lgp_status'] = $status;

            try {
                return $this->salvar($pro);
            } catch (Exception $exception) {
                return $exception->getMessage();
            }

        }
    }


    public function buscarRerservas($lgra_codigo)
    {
        $sql = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("lgp" => "leito_grade_produtos"))
            ->join(array("pro" => "produto"), "lgp.pro_codigo = pro.pro_codigo", array("pro_nome"))
            ->where("lgra_codigo =?", $lgra_codigo )
            ->where("lgp_status = 'R'");

		return $this->fetchAll($sql);
	}

    public function buscarRerservados($lgra_codigo)
    {
        $sql = $this->select()
            ->from(array("lgp" => "leito_grade_produtos"))
            ->where("lgra_codigo =?", $lgra_codigo )
            ->where("lgp_status = 'R'");

        return $this->fetchAll($sql)->toArray();
    }


}
