<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Medico extends Elotech_Db_Table_Abstract {

	protected $_name = 'medico';
	protected $_primary = 'med_codigo';
	protected $_sequence = 'seq_med_codigo';

	/**
	* Prestador de serviço
	*/
	const LABORATORIO = "L";
	const MEDICO = "M";
	const HOSPITAL = "H";

	public function salvar(array $data) {
		return parent::salvar($data);
	}

	public function salvarPrestadorDeServico(array $data) {
		try {
			$this->emptyToNull($data);
			return parent::salvar($data);
		} catch (Exception $exc) {
			throw new Zend_Validate_Exception("Falha ao cadastrar Prestado de Serviço: " . $exc->getMessage());
		}
	}

	/**
	* Buscar os médicos externos
	* usado para alimentar o plugin de busca (jquery)
	* @return json
	*/
	public function buscar($term = FALSE, $prestador = array('M')) {
		if ($term) {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(["med" => "medico"], ["med_codigo", "med_nome"])
				->where("prestador_servico IN (?)", $prestador)
				->where("retira_acentos(med_nome) ilike retira_acentos('%$term%')", "S")
				->order(["med_nome"])
				->limit(15);
		}
		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $usu) {
			$data = array();
			foreach ($usu as $key => $value) {
				foreach($prestador as $prest)
				$data [$key . "_" . $prest] = $value;
			}

			$out [] = array(
				"id" => $usu->med_codigo,
				"label" => $usu->med_nome,
				"data" => $data
			);
		}

		if (!count($out)) {
			$out [] = [
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => [
					"med_codigo" => "0",
					"med_nome" => ""
				]
			];
		}

		return $out;
	}

	public function buscarPrestador($term = FALSE) {
		if ($term) {
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(["med" => "medico"], ["med_codigo", "med_nome"])
				->join(["conv" => "convenio"], "conv.med_codigo = med.med_codigo", "")
				->where("retira_acentos(med_nome) ilike retira_acentos('%$term%')")
				->order(["med_nome"])
				->limit(15);
		}
		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $usu) {
			$out [] = array(
				"id" => $usu->med_codigo,
				"label" => $usu->med_nome,
				"data" => $usu->toArray()
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("med_codigo" => "0", "med_nome" => "")
			);
		}

		return $out;
	}

	public function getInfoMedico($med_codigo = FALSE) {
		if(!$med_codigo) {
			return false;
		}

		return $this->fetchRow ("med_codigo=$med_codigo");
	}

	public function getQtdPrestadorAtivosCnes() {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["med" => "medico"], ["COUNT(med_codigo) AS qtd_prest"])
			->where("cnes_ativo = 'S'");
		return $this->fetchRow($sql);
	}

	public function getPrestadorPorCnes($cnes) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["med" => "medico"], ["med_codigo", "med_nome"])
			->where("med_cnes = ?",$cnes);
		return $this->fetchRow($sql);
	}

	public function buscaPrestadorPorNome($nome_fantasia = FALSE, $nome_fantasia_quebrado = FALSE, $razao_social = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["med" => "medico"], ["med_codigo", "med_nome"]);
		foreach ($nome_fantasia_quebrado as $nome) {
			$nomes_provavel .= $nome." ";
			$sql->orWhere("med.med_nome ilike retira_acentos('%".trim($nomes_provavel)."%')");
		}

		return $this->fetchAll($sql);
	}

	public function buscaPrestadorParaBpa() {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(["med" => "medico"], ["med_codigo", "med_nome"])
			->where("prestador_servico in ('L','H')")
			->order('med_nome ASC');
		return $this->fetchAll($sql);
	}

	public function getDadosMedicoPorId($med_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["med" => "medico"])
			->where("med.med_codigo = ?", $med_codigo);

		return $this->fetchRow($sql);
	}

	public function getDadosMedicoPorNome($med_nome) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("med" => "medico"), array("med_codigo", "med_nome", "med_crm" => "(CASE WHEN med_crm = 'NAOTEM' THEN 'Não possui' ELSE med_crm END)", "med_tipo_pessoa"))
			->where("med.med_nome ilike retira_acentos('%".trim($med_nome)."%')")
			->order("med_codigo DESC");
		return $this->fetchAll($sql);
	}

	public function getAllMedicos() {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("med" => "medico"), array("med_codigo", "med_nome", "med_crm" => "(CASE WHEN med_crm = 'NAOTEM' THEN 'Não possui' ELSE med_crm END)", "med_tipo_pessoa"))
			->order("med_codigo DESC");
		return $this->fetchAll($sql);
	}

	public function getDadosAgentic() {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["med" => "medico"], ["med_nome", "med_codigo", "med_especialidade", "med_end_uf", "med_end_cidade"])
			->order("med_codigo DESC");

		return $this->fetchAll($sql)
			->toArray();
	}

}
