<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Movimento extends Elotech_Db_Table_Abstract
{

    protected $_name = 'movimento';
    protected $_primary = 'mov_codigo';
    protected $_sequence = 'seq_mov_codigo';

    /**
     * mov_tipo
     */
    const ENTRADA = "E";
    const SAIDA = "S";
    const TRANSFERENCIA = "T";

    /**
     * mov_entrada
     */
    const NORMAL = "E";
    const AJUSTE = "A";
    const EMPRESTIMO = "M";
    const INVENTARIO = "I";
    const DOACAO = "D";
    const PERMUTA = "P";
    const OUTRAS = "O";
    //const TRANSFERENCIA = "T";
    const DEVOLUCAO = "V";

    /**
     * mov_saida
     */
    const CONSUMO = "S";
    const DISPENSACAO = "D";
    //const EMPRESTIMO = "M";
    //const PERMUTA = "P";
    //const INVENTARIO = "I";
    //const AJUSTE = "A";
    const PERDAS = "R";

    //const OUTRAS = "O";
    //const TRANSFERENCIA = "T";

    public function salvar(array $data)
    {
	    $this->valoresPadrao($data);

	    // validação:
	    if (!in_array($data['mov_tipo'], array(self::ENTRADA, self::SAIDA, self::TRANSFERENCIA))) {
		    throw new Zend_Validate_Exception("\"mov_tipo\" precisa ser: ENTRADA, SAIDA ou TRANSFERENCIA");
	    }

	    $this->emptyToUnset($data);
	    $this->peloMenosUm(array("mov_entrada", "mov_saida"), $data);
	    // $this->peloMenosUm(array("set_entrada", "set_saida"), $data);

	    return parent::salvar($data);
    }

    public function atualizaNotaMovimento($mov_codigo, $mov_nr_nota){
	    $movimento = $this->getMovimento($mov_codigo)->toArray();
	    if ($movimento) {
		    $movimento["mov_nr_nota"] = $mov_nr_nota;
		    $this->salvar($movimento);
	    }else{
		    throw new Zend_Validate_Exception("Movimento não encontrado!");
	    }
    }

    public function salvarMovimentacaoRequisicao($dados)
    {
        try {
            return parent::salvar($dados);
        } catch (Exception $exc) {
            throw new Zend_Validate_Exception("Falha ao cadastrar a movimentação!" + $exc->getMessage());
        }
    }

    private function valoresPadrao(&$data)
    {
        $tbUsr = new Application_Model_Usuarios;
        $usu = $tbUsr->getUsrAtual();


        if (empty($data['mov_data']) && empty($data['mov_codigo'])) {
            $data['mov_data'] = date("Y-m-d");
        }

        if (empty($data['usr_codigo'])) {
            $data['usr_codigo'] = $usu->usr_codigo;
        }

        if (empty($data['mov_ip'])) {
            $fun = new Application_Model_Funcoes();
            $data['mov_ip'] = (string)$fun->getIp();
        }

        if ($data['mov_tipo'] == self::ENTRADA && empty($data['set_entrada'])) {
            $data['set_entrada'] = $usu->set_codigo;
        }

        if ($data['mov_tipo'] == self::SAIDA && empty($data['set_saida'])) {
            $data['set_saida'] = $usu->set_codigo;
        }
    }

    public function getMedicamentosDispensados($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $limit = FALSE)
    {
        // produtos "inteiros"
        $where1 = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"), array("unidade" => "COALESCE('1','1')", "mov_codigo", "mov_data"))
            ->join(array("i" => "itens_movimento"), "i.mov_codigo=m.mov_codigo", array("ite_quantidade", "ite_lote"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", "")
            ->join(array("u" => "unidade"), "u.uni_codigo=s.uni_codigo", "uni_desc")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=m.usr_codigo", "usr_nome")
            ->where("mov_tipo='S'")
            ->where("usu_codigo=?", $usu_codigo);

        if ($data_inicial)
            $where1->where("m.mov_data >= ?", $data_inicial);

        if ($data_final)
            $where1->where("m.mov_data <= ?", $data_final);
        // produtos fracionados
        $where2 = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("vac" => "vacina_usuario"), array("unidade" => "COALESCE('0','0')", "vac_usu_codigo", "mov_data" => "vac_data", "ite_quantidade" => "vac_qtde"))
            ->join(array("cont" => "controlefracionado"), "cont.cont_codigo=vac.cont_codigo", "")
            ->join(array("ite" => "itens_movimento"), "ite.ite_codigo=cont.ite_codigo", "ite_lote")
            ->join(array("pro" => "produto"), "pro.pro_codigo=ite.pro_codigo", "pro_nome")
            ->join(array("mov" => "movimento"), "mov.mov_codigo=ite.mov_codigo", "")
            ->join(array("set" => "setor"), "set.set_codigo=mov.set_saida", "")
            ->join(array("uni" => "unidade"), "uni.uni_codigo=set.uni_codigo", "uni_desc")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=mov.usr_codigo", "usr_nome")
            ->where("vac.usu_codigo=?", $usu_codigo);

        if ($data_inicial)
            $where2->where("mov.mov_data >= '$data_inicial'");

        if ($data_final)
            $where2->where("mov.mov_data <= '$data_final'");


        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->union(array($where1, $where2), Zend_Db_Select::SQL_UNION_ALL)
            ->order(array("mov_data DESC"));

        //die($where);
        if ($limit)
            $where->limit($limit);

        return $this->fetchAll($where);
    }

    public function getProntuarioMedicamentosDispensados($usu_codigo, $data_inicial = FALSE, $data_final = FALSE, $limit = FALSE)
    {
        // CONSULTAS MOVIMENTO
        $where1 = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"), array("unidade" => "COALESCE('1','1')", "mov_codigo", "mov_data"))
            ->join(array("i" => "itens_movimento"), "i.mov_codigo=m.mov_codigo", array("ite_quantidade", "ite_lote"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", "")
            ->join(array("u" => "unidade"), "u.uni_codigo=s.uni_codigo", "uni_desc")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=m.usr_codigo", "usr_nome")
            ->where("mov_tipo='S'")
            ->where("usu_codigo=?", $usu_codigo);

        if ($data_inicial)
            $where1->where("m.mov_data >= ?", $data_inicial);

        if ($data_final)
            $where1->where("m.mov_data <= ?", $data_final);

        // CONSULTAS MOVIMENTO BACKUP
        $where2 = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento_bkp"), array("unidade" => "COALESCE('1','1')", "mov_codigo", "mov_data"))
            ->join(array("i" => "itens_movimento_bkp"), "i.mov_codigo=m.mov_codigo", array("ite_quantidade", "ite_lote"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", "")
            ->join(array("u" => "unidade"), "u.uni_codigo=s.uni_codigo", "uni_desc")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=m.usr_codigo", "usr_nome")
            ->where("mov_tipo='S'")
            ->where("usu_codigo=?", $usu_codigo);

        if ($data_inicial)
            $where2->where("m.mov_data >= ?", $data_inicial);

        if ($data_final)
            $where2->where("m.mov_data <= ?", $data_final);


        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->union(array($where1, $where2), Zend_Db_Select::SQL_UNION_ALL)
            ->order(array("mov_data DESC"));

        if ($limit)
            $where->limit($limit);

        return $this->fetchAll($where);
    }

    public function relDispensados($set_codigo, $data_inicial = FALSE, $data_final = FALSE, $usu_codigo = FALSE, $gru_codigo = FALSE)
    {
        // produtos "inteiros"
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"), array("mov_codigo", "mov_data"))
            ->join(array("i" => "itens_movimento"), "i.mov_codigo=m.mov_codigo", array("ite_quantidade", "ite_lote", "pro_codigo", "COALESCE((SELECT AVG(item.ite_custo_medio) FROM itens_movimento item INNER JOIN movimento mov ON item.mov_codigo = mov.mov_codigo AND mov.mov_tipo = 'E' AND i.ite_lote=item.ite_lote AND i.pro_codigo=item.pro_codigo GROUP BY i.ite_lote),0) AS ite_custo_medio"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", "")
            ->join(array("usu" => "usuario"), "usu.usu_codigo=m.usu_codigo", array("usu_nome", "usu_codigo"))
            ->order(array("usu_nome", "m.usu_codigo", "mov_data", "pro_nome"));

        if ($data_inicial) {
            $where->where("mov_data >= '$data_inicial'");
        }
        if ($data_final) {
            $where->where("mov_data <= '$data_final'");
        }
        if ($set_codigo) {
            $where->where("set_saida = $set_codigo");
        }
        if ($usu_codigo) {
            $where->where("m.usu_codigo = $usu_codigo");
        }
        if ($gru_codigo) {
            $where->where("p.gru_codigo = $gru_codigo");
        }
        //die($where);
        return $this->fetchAll($where);
    }

    public function getRelMovimentacaoPrograma($set_codigo, $data_inicial = FALSE, $data_final = FALSE, $prg_codigo)
    {
        // produtos "inteiros"
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"), "")
            ->join(array("i" => "itens_movimento"), "i.mov_codigo=m.mov_codigo", array("sum(ite_quantidade) as ite_quantidade", "pro_codigo"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", "")
            ->join(array("ppt" => "programa_produto"), "ppt.pro_codigo = i.pro_codigo", "")
            ->join(array("pat" => "programa_atendimento"), "pat.prg_codigo = ppt.prg_codigo", array("prg_nome", "prg_codigo"))
            ->group(array("prg_nome", "pat.prg_codigo", "pro_nome", "i.pro_codigo"))
            ->order(array("prg_nome", "pat.prg_codigo", "pro_nome"));

        if ($data_inicial) {
            $where->where("mov_data >= '$data_inicial'");
        }
        if ($data_final) {
            $where->where("mov_data <= '$data_final'");
        }
        if ($set_codigo) {
            $where->where("set_saida = $set_codigo");
        }
        if ($prg_codigo) {
            $where->where("ppt.prg_codigo = $prg_codigo");
        }
        //die($where);
        return $this->fetchAll($where);
    }

    public function getRelMovimentacaoProgramaPaciente($set_codigo, $data_inicial = FALSE, $data_final = FALSE, $prg_codigo)
    {
        // produtos "inteiros"
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"), "")
            ->join(array("i" => "itens_movimento"), "i.mov_codigo=m.mov_codigo", array("sum(ite_quantidade) as ite_quantidade", "pro_codigo"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", "")
            ->join(array("usu" => "usuario"), "usu.usu_codigo=m.usu_codigo", array("usu_nome", "usu_datanasc"))
            ->join(array("ppt" => "programa_produto"), "ppt.pro_codigo = i.pro_codigo", "")
            ->join(array("pat" => "programa_atendimento"), "pat.prg_codigo = ppt.prg_codigo", array("prg_nome", "prg_codigo"))
            ->group(array("prg_nome", "pat.prg_codigo", "usu_nome", "usu_datanasc", "pro_nome", "i.pro_codigo"))
            ->order(array("prg_nome", "pat.prg_codigo", "usu_nome", "pro_nome"));

        if ($data_inicial) {
            $where->where("mov_data >= '$data_inicial'");
        }
        if ($data_final) {
            $where->where("mov_data <= '$data_final'");
        }
        if ($set_codigo) {
            $where->where("set_saida = $set_codigo");
        }
        if ($prg_codigo) {
            $where->where("ppt.prg_codigo = $prg_codigo");
        }
        //die($where);
        return $this->fetchAll($where);
    }

    public function getNumPacientesAtendidosPorPeriodoSetor($codUnidade = FALSE, $codSetor = FALSE, $dataInicial = FALSE, $dataFinal = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("mov" => "movimento"), array("COUNT(DISTINCT mov.mov_codigo) AS qtd_atendimento"))
//            ->join(array("ite" => "itens_movimento"), "mov.mov_codigo=ite.mov_codigo", array(""))
//            ->join(array("pro" => "produto"), "ite.pro_codigo=pro.pro_codigo", array())
            ->join(array("set" => "setor"), "mov.set_saida=set.set_codigo", array(""))
            ->where("set.uni_codigo =?", $codUnidade)
            ->where("mov.mov_tipo = 'S'")
            ->where("mov.mov_saida = 'D'");
        if ($codSetor)
            $sql->where("set.set_codigo =?", $codSetor);
        if ($dataInicial)
            $sql->where("mov.mov_data >= '$dataInicial'");
        if ($dataFinal)
            $sql->where("mov.mov_data <= '$dataFinal'");
        return $this->fetchRow($sql);
    }

    public function getNumPacientesAtendidosPorIdade($codUnidade = FALSE, $codSetor = FALSE, $dataInicial = FALSE, $dataFinal = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("mov" => "movimento"), "")
            ->join(array("usu" => "usuario"), "mov.usu_codigo=usu.usu_codigo", array("EXTRACT(YEAR FROM age(now(),usu_datanasc)) as idade, count(EXTRACT(YEAR FROM age(now(),usu_datanasc))) as quantidade"))
            ->join(array("set" => "setor"), "mov.set_saida=set.set_codigo", array(""))
            ->where("set.uni_codigo =?", $codUnidade)
            ->where("mov.mov_tipo = 'S'")
            ->where("mov.mov_saida = 'D'");
        $sql->group(array("EXTRACT(YEAR FROM age(now(),usu_datanasc))"));
        $sql->order(array("EXTRACT(YEAR FROM age(now(),usu_datanasc))"));
        if ($codSetor)
            $sql->where("set.set_codigo =?", $codSetor);
        if ($dataInicial)
            $sql->where("mov.mov_data >= '$dataInicial'");
        if ($dataFinal)
            $sql->where("mov.mov_data <= '$dataFinal'");
        return $this->fetchAll($sql);
    }

    public function getNumPacientesAtendidosPorMedicamentoDispensado($codUnidade = FALSE, $codProd = FALSE, $codSetor = FALSE, $dataInicial = FALSE, $dataFinal = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("pro" => "produto"), array("pro_codigo", "pro_nome"))
            ->join(array("ite" => "itens_movimento"), "pro.pro_codigo=ite.pro_codigo", "")
            ->join(array("mov" => "movimento"), "ite.mov_codigo=mov.mov_codigo", array("COUNT(mov.mov_codigo) AS soma"))
            ->join(array("set" => "setor"), "mov.set_entrada=set.set_codigo OR mov.set_saida=set.set_codigo", array("set_nome"))
            ->where("pro.pro_situacao = 'A'")
            //->where("set.uni_codigo =?", $codUnidade)
            ->where("mov.mov_tipo = 'S'")
            ->where("mov.mov_saida = 'D'");
        if ($codProd)
            $sql->where("pro.pro_codigo =?", $codProd);
        if ($codSetor)
            $sql->where("set.set_codigo =?", $codSetor);
        $sql->where("mov.mov_data >= '$dataInicial'");
        $sql->where("mov.mov_data <= '$dataFinal'");
        $sql->group(array("pro.pro_codigo", "pro.pro_nome", "set.set_nome"));
        $sql->order(array("set.set_nome", "pro.pro_nome"));
        return $this->fetchAll($sql);
    }

    public function getNumPacientesAtendidosPorMedicamentoDispensadoAnalitico($codUnidade = FALSE, $codProd = FALSE, $codSetor = FALSE, $dataInicial = FALSE, $dataFinal = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("pro" => "produto"), array("pro_codigo", "pro_nome"))
            ->join(array("ite" => "itens_movimento"), "pro.pro_codigo=ite.pro_codigo", array("ite_lote", "ite_quantidade"))
            ->join(array("mov" => "movimento"), "ite.mov_codigo=mov.mov_codigo", array("COUNT(mov.mov_codigo) AS soma", "mov_data"))
            ->join(array("usu" => "usuario"), "mov.usu_codigo=usu.usu_codigo", "usu_nome")
            ->join(array("set" => "setor"), "mov.set_entrada=set.set_codigo OR mov.set_saida=set.set_codigo", array("set_nome"))
            ->where("pro.pro_situacao = 'A'")
            //->where("set.uni_codigo =?", $codUnidade)
            ->where("mov.mov_tipo = 'S'")
            ->where("mov.mov_saida = 'D'");
        if ($codProd)
            $sql->where("pro.pro_codigo =?", $codProd);
        if ($codSetor)
            $sql->where("set.set_codigo =?", $codSetor);
        $sql->where("mov.mov_data >= '$dataInicial'");
        $sql->where("mov.mov_data <= '$dataFinal'");
        $sql->group(array("pro.pro_codigo", "pro.pro_nome", "set.set_nome", "usu.usu_nome", "ite_lote", "ite_quantidade", "mov_data"));
        $sql->order(array("set.set_nome", "pro.pro_nome"));
        return $this->fetchAll($sql);
    }

    public function getMovimentos($limit = FALSE, $term = FALSE, $mov_tipo = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("mov" => "movimento"), array("mov_codigo",
                "mov_data",
                "mov_tipo" => "(CASE WHEN mov_tipo='E' THEN 'Entrada' WHEN mov_tipo='S' THEN 'Saída'  WHEN mov_tipo='T' THEN 'Transferência' END)",
                "mov_saida" => "(CASE WHEN mov_saida = 'D' THEN 'Dispensação' WHEN mov_saida = 'S-VV' THEN 'Saída por Validade Vencida' WHEN mov_saida = 'T' THEN 'Transferência' WHEN mov_saida='S-PE' THEN 'Saida por Perda' WHEN mov_saida='S-AEA' THEN 'Saída por Amostra, Exposição e Análise' WHEN mov_saida='S-DEP' THEN 'Saída por Devolução de produto' WHEN mov_saida = 'S-D' THEN 'Saída por Doação' WHEN mov_saida = 'S-TR' THEN 'Saída por Transferência e Remanejamento' WHEN mov_saida = 'S-AS' THEN 'Saída por Apreenção Sanitária' WHEN mov_saida = 'S-E' THEN 'Saída por Empréstiomo' WHEN mov_saida = 'S-P' THEN 'Saída para Paciente' WHEN mov_saida = 'S-AE' THEN 'Saída por Ajuste' WHEN mov_saida = 'S' THEN 'Saída por Consumo' WHEN mov_saida = 'O' THEN 'Outras Saídas'  END)",
                "mov_entrada" => "(CASE WHEN mov_entrada = 'T' THEN 'Transferência' WHEN mov_entrada='E-SI' THEN 'Entrada por Saldo de Implantação' WHEN mov_entrada='E-C' THEN 'Entrada por Concorrência' WHEN mov_entrada='E-DL' THEN 'Entrada por Dispensa de Licitação' WHEN mov_entrada = 'E-CONV' THEN 'Entrada por Convite' WHEN mov_entrada = 'E-D' THEN 'Entrada por doação' WHEN mov_entrada = 'E-P' THEN 'Entrada por Pregão' WHEN mov_entrada = 'E-AE' THEN 'Entrada por Ajuste de Estoque' WHEN mov_entrada = 'E-EVENTUAL' THEN 'Entrada por Entrada Eventual' WHEN mov_entrada = 'E-O' THEN 'Entrada Ordinária' WHEN mov_entrada = 'E-TP' THEN 'Entrada por Tomada de Preços' WHEN mov_entrada = 'E-INEX' THEN 'Entrada por Inexigibilidade' WHEN mov_entrada = 'E-PER' THEN 'Entrada por Permuta' WHEN mov_entrada = 'E' THEN 'Entrada por Nota Fiscal de Compra' WHEN mov_entrada = 'M' THEN 'Entrada por Emprestimo' WHEN mov_entrada= 'I' THEN 'Entrada por Inventário' WHEN mov_entrada = 'O' THEN 'Outras Entradas' WHEN mov_entrada = 'V' THEN 'Entrada por Devolução' END)",
                "mov_tipo as tipo",
                "mov_observacao",
                "mov_nr_nota",
                "req_codigo",
  	            "set_entrada",
  	            "set_saida"))
            ->join(array("im" => "itens_movimento"), "im.mov_codigo=mov.mov_codigo", "")
            ->joinLeft(array("f" => "fornecedor"), "mov.for_codigo=f.for_codigo", "for_nome")
            ->order("mov_data DESC")
            ->order("mov_codigo DESC");

        if ($mov_tipo != "A" && $mov_tipo != "") {
            $where->where("mov_tipo='$mov_tipo'");
        }
        if ($term) {
            if ($this->validaDataNormal($term)) {
                $where->where("mov_data='$term'");
            } else if (is_numeric($term)) {
                $where->where("(mov.mov_codigo=$term OR mov_nr_nota='$term')");
            } else {
                $where->where("mov_observacao ilike'%$term%' OR for_nome ilike '%$term%'");
            }
        }

        $tbUsr = new Application_Model_Usuarios();
        $usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;
        $tbUsrSet = new Application_Model_UsuariosSetores();
        $setores = "";
        foreach ($tbUsrSet->getSetoresPorUsuario($usr_codigo) as $setor) {
            $setores .= $setor['set_codigo'] . ",";
        }
        $setores = substr($setores, 0, -1);
        $where->where("set_entrada in ($setores) OR set_saida in ($setores)");
        $where->where("(mov_saida <> 'D' OR mov_saida IS NULL)");

        if ($limit)
            $where->limit($limit);

        return $this->fetchAll($where);
    }

    public function validaDataNormal($dat)
    {
        $data = explode("/", "$dat"); // fatia a string $dat em pedados, usando / como referência
        $d = $data[0];
        $m = $data[1];
        $y = $data[2];
        $res = checkdate($m, $d, $y);
        if ($res == 1) {
            return true;
        } else {
            return false;
        }
    }

    public function ValidaData($dat)
    {
        $data_br = date('d/m/Y', strtotime($dat));
        $data = explode("/", "$data_br"); // fatia a string $dat em pedados, usando / como referência
        $d = $data[0];
        $m = $data[1];
        $y = $data[2];

        // verifica se a data é válida!
        // 1 = true (válida)
        // 0 = false (inválida)
        if ($y == "") {
            return false;
        } else {
            $res = checkdate($m, $d, $y);
            if ($res == 1) {
                return true;
            } else {
                return false;
            }
        }
    }

    public function getMovimento($mov_codigo = FALSE)
    {
        if (!$mov_codigo)
            return false;

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("mov" => "movimento"))
            ->joinLeft(array("usu" => "usuario"), "usu.usu_codigo=mov.usu_codigo", array("usu_nome", "usu_datanasc", "usu_cartao_sus", "usu_prontuario"))
            ->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo=mov.med_codigo_interno", "usr_nome")
            ->joinLeft(array("med" => "medico"), "med.med_codigo=mov.med_codigo_externo", "med_nome")
            ->where("mov_codigo=$mov_codigo");
//        die($where);
        return $this->fetchRow($where);
    }

    public function getDadosMovimento($mov_codigo = FALSE)
    {
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("mov" => "movimento"), array("mov_codigo", "mov_tipo", "mov_data", "mov_nr_nota", "trim(mov_entrada) as mov_entrada", "trim(mov_saida) as mov_saida", "mov_observacao", "mov_nr_nota"))
            ->joinLeft(array("sets" => "setor"), "mov.set_saida=sets.set_codigo", array("set_nome AS setor_saida"))
            ->joinLeft(array("sete" => "setor"), "mov.set_entrada=sete.set_codigo", array("set_nome AS setor_entrada"))
            ->joinLeft(array("forn" => "fornecedor"), "mov.for_codigo=forn.for_codigo", array("for_codigo", "for_nome"))
            ->where("mov.mov_codigo=$mov_codigo");
//            die($sql);
        return $this->fetchRow($sql);
    }

	public function getDadosMovimentoHorus($pro_codigo, $lote)
	{
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("mov" => "movimento"), array("mov_codigo", "mov_tipo", "mov_data", "mov_nr_nota", "mov_entrada", "mov_saida", "mov_observacao", "mov_nr_nota"))
			->join(array("itemov" => "itens_movimento"), "mov.mov_codigo = itemov.mov_codigo", "")
			->join(array("fab" => "fabricante"), "itemov.fab_codigo = fab.fab_codigo", array("fab_descricao", "fab_cnpj"))
			->join(array("forn" => "fornecedor"), "mov.for_codigo = forn.for_codigo", array("for_nome", "for_cnpj"))
			->where("itemov.pro_codigo = ?", $pro_codigo)
			->where("itemov.ite_lote = ?", $lote)
			->order("mov.mov_data DESC");
		return $this->fetchRow($sql);
	}

    public function getEntradas($set_codigo = FALSE, $data_inicial = FALSE, $data_final = FALSE, $psi = FALSE, $portaria = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("mov" => "movimento"), array("mov_nr_nota"))
            ->join(array("forn" => "fornecedor"), "forn.for_codigo=mov.for_codigo", array("for_nome", "for_cnpj"))
            ->join(array("ite" => "itens_movimento"), "ite.mov_codigo=mov.mov_codigo", "SUM(ite_quantidade) as ite_quantidade")
            ->join(array("pro" => "produto"), "pro.pro_codigo=ite.pro_codigo", array("pro_nome", "pro_codigo_dcb", "pro_descricao_dcb", "pro_apresentacao_concentracao"))
            ->joinLeft(array("psi" => "psicotropicos"), "psi.psico_codigo=pro.psico_codigo", array("psico_nome"))
            ->where("mov_data >= '$data_inicial'")
            ->where("mov_data <= '$data_final'")
            ->where("set_entrada=$set_codigo")
            ->where("mov_tipo='E'")
            ->group(array("mov_nr_nota", "for_nome", "for_cnpj", "pro_nome", "pro_codigo_dcb", "pro_descricao_dcb", "pro_apresentacao_concentracao", "psico_nome"));

        if ($psi == "s") {
            $where->where("pro.psico_codigo is not null");
        }
        if ($portaria)
            $where->where("pro.psico_codigo in ($portaria)");

        return $this->fetchAll($where);
    }

    public function getUltimosDispensados($usu_codigo = FALSE)
    {
        $tbConf = new Application_Model_Configuracao();
        $dias = $tbConf->getConfig("FARMACIA_TEMPO_HISTORICO");

        // CONSULTA DISPENSADO MOVIMENTO
        $where1 = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"), array("unidade" => "COALESCE('1','1')", "mov_codigo", "mov_data", "duracao" => "to_char(mov_data + COALESCE(i.ite_duracao,null,0),'DD/MM/YYYY')"))
            ->join(array("i" => "itens_movimento"), "i.mov_codigo=m.mov_codigo", array("ite_quantidade", "ite_lote"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", array("set_nome"))
            ->join(array("u" => "unidade"), "u.uni_codigo=s.uni_codigo", "uni_desc")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=m.usr_codigo", "usr_nome")
            ->where("mov_tipo='S'")
            ->where("usu_codigo=?", $usu_codigo)
            ->where("mov_saida='D'")
            ->where("mov_data > CURRENT_DATE - $dias");

        // CONSULTA DISPENSADO BACKUP
        $where2 = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento_bkp"), array("unidade" => "COALESCE('1','1')", "mov_codigo", "mov_data", "duracao" => "to_char(mov_data + COALESCE(i.ite_duracao,null,0),'DD/MM/YYYY')"))
            ->join(array("i" => "itens_movimento_bkp"), "i.mov_codigo=m.mov_codigo", array("ite_quantidade", "ite_lote"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", array("set_nome"))
            ->join(array("u" => "unidade"), "u.uni_codigo=s.uni_codigo", "uni_desc")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=m.usr_codigo", "usr_nome")
            ->where("mov_tipo='S'")
            ->where("usu_codigo=?", $usu_codigo)
            ->where("mov_saida='D'")
            ->where("mov_data > CURRENT_DATE - $dias")
            ->order("mov_data DESC");

        // REALIZANDO UNION

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->union(array($where1, $where2), Zend_Db_Select::SQL_UNION_ALL);
        return $this->fetchAll($where);
    }

    public function getObservacao($usu_codigo = FALSE)
    {

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"), array("mov_observacao"))
            ->where("mov_tipo='S'")
            ->where("usu_codigo=?", $usu_codigo)
            ->where("mov_saida='D'")
            ->order(array("mov_data DESC", "mov_codigo DESC"))
            ->limit(1);
        return $this->fetchAll($where);
    }

    public function getDispensados($usu_codigo = FALSE)
    {
        // produtos "inteiros"
        $where1 = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"), array("unidade" => "COALESCE('1','1')", "mov_codigo", "mov_data", "duracao" => "to_char(mov_data + COALESCE(i.ite_duracao,null,0),'DD/MM/YYYY')"))
            ->join(array("i" => "itens_movimento"), "i.mov_codigo=m.mov_codigo", array("ite_quantidade", "ite_lote"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", "set_nome")
            ->join(array("u" => "unidade"), "u.uni_codigo=s.uni_codigo", "uni_desc")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=m.usr_codigo", "usr_nome")
            ->where("mov_tipo='S'")
            ->where("usu_codigo=?", $usu_codigo)
            ->where("mov_saida='D'");

        $where2 = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento_bkp"), array("unidade" => "COALESCE('1','1')", "mov_codigo", "mov_data", "duracao" => "to_char(mov_data + COALESCE(i.ite_duracao,null,0),'DD/MM/YYYY')"))
            ->join(array("i" => "itens_movimento_bkp"), "i.mov_codigo=m.mov_codigo", array("ite_quantidade", "ite_lote"))
            ->join(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", "pro_nome")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_saida", "set_nome")
            ->join(array("u" => "unidade"), "u.uni_codigo=s.uni_codigo", "uni_desc")
            ->join(array("usr" => "usuarios"), "usr.usr_codigo=m.usr_codigo", "usr_nome")
            ->where("mov_tipo='S'")
            ->where("usu_codigo=?", $usu_codigo)
            ->where("mov_saida='D'")
            ->order("mov_data DESC");

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->union(array($where1, $where2), Zend_Db_Select::SQL_UNION_ALL);
        //die($where);
        return $this->fetchAll($where);
    }

    public function getMovimentacoesPorSetor($set_codigo = FALSE)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("m" => "movimento"));
        if ($set_codigo)
            $where->where("set_entrada = '$set_codigo' OR set_saida = '$set_codigo'");

        return $this->fetchAll($where);
    }

    public function excluiMovimentacaoPorSetor($setores = FALSE, $data = FALSE)
    {
        // Se data vier preenchida faz consula por data
        if ($data)
            $sqlData = "AND mov_data <= '$data'";

        try {
            $sql = $this
                ->getDefaultAdapter()
                ->query("DELETE FROM social.movimento WHERE (set_entrada IN ($setores) OR set_saida IN ($setores)) $sqlData")
                ->fetchAll();
            return $sql;
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao excluir movimentação: " . $ex->getMessage());
        }
    }

    public function getMovimentosEntrada($set_codigo = FALSE, $data_inicial = FALSE, $data_final = FALSE, $pro_codigo = FALSE, $usr_codigo, $pros_codigo)
    {
        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("m" => "movimento"), array("mov_data",
                "mov_entrada" => "(CASE WHEN mov_entrada = 'T' THEN 'Transferência' WHEN mov_entrada='E-SI' THEN 'Entrada por Saldo de Implantação' WHEN mov_entrada='E-C' THEN 'Entrada por Concorrência' WHEN mov_entrada='E-DL' THEN 'Entrada por Dispensa de Licitação' WHEN mov_entrada = 'E-CONV' THEN 'Entrada por Convite' WHEN mov_entrada = 'E-D' THEN 'Entrada por doação' WHEN mov_entrada = 'E-P' THEN 'Entrada por Pregão' WHEN mov_entrada = 'E-AE' THEN 'Entrada por Ajuste de Estoque' WHEN mov_entrada = 'E-EVENTUAL' THEN 'Entrada por Entrada Eventual' WHEN mov_entrada = 'E-O' THEN 'Entrada Ordinária' WHEN mov_entrada = 'E-TP' THEN 'Entrada por Tomada de Preços' WHEN mov_entrada = 'E-INEX' THEN 'Entrada por Inexigibilidade' WHEN mov_entrada = 'E-PER' THEN 'Entrada por Permuta' WHEN mov_entrada = 'E' THEN 'Entrada por Nota Fiscal de Compra' WHEN mov_entrada = 'M' THEN 'Entrada por Emprestimo' WHEN mov_entrada= 'I' THEN 'Entrada por Inventário' WHEN mov_entrada = 'O' THEN 'Outras Entradas' WHEN mov_entrada = 'V' THEN 'Entrada por Devolução' END)", "mov_codigo"))
            ->join(array("f" => "fornecedor"), "f.for_codigo=m.for_codigo", "for_nome")
            ->join(array("u" => "usuarios"), "u.usr_codigo=m.usr_codigo", "usr_nome")
            ->join(array("ite" => "itens_movimento"), "ite.mov_codigo=m.mov_codigo", "")
            ->join(array("s" => "setor"), "s.set_codigo=m.set_entrada")
            ->join(array("p" => "produto"), "p.pro_codigo=ite.pro_codigo", "")
            ->where("mov_tipo = 'E'")
            ->order("set_codigo")
            ->order("mov_data");

        if ($data_inicial)
            $where->where("mov_data >= '$data_inicial'");

        if ($data_final)
            $where->where("mov_data <= '$data_final'");

        if ($set_codigo)
            $where->where("set_entrada = $set_codigo");

        if ($usr_codigo)
            $where->where("usr_codigo = $usr_codigo");

        if ($pro_codigo)
            $where->where("p.pro_codigo = $pro_codigo");

        if ($pros_codigo)
            $where->where("pros_codigo=$pros_codigo");

        return $this->fetchAll($where);
    }

    public function relMovimentacaoMateriais($set_codigo, $gru_codigo, $pros_codigo, $pro_codigo, $data_inicial, $data_final)
    {
        $datai = " AND mov_data >= '$data_inicial'";
        $datafSaldoInicial = "AND mov_data < '$data_inicial'";

        $dataf = " AND mov_data <= '$data_final'";

        $setSaida = "AND set_saida = $set_codigo";
        $setEntrada = "AND set_entrada = $set_codigo";

	    $subselect = $this->select(FALSE)
		    ->setIntegrityCheck(FALSE)
		    ->from(array("prod2" => "produto"), array("pro_codigo",
			    "(
				(SELECT SUM(COALESCE(sal.sal_qtde,0)) FROM saldo sal WHERE sal.pro_codigo = prod2.pro_codigo AND sal.set_codigo = $set_codigo)
				-
                (COALESCE(SUM(CASE WHEN (mov.mov_tipo in ('E','T') AND mov.set_entrada = $set_codigo) THEN ite.ite_quantidade ELSE 0 END),0))
                +
                (COALESCE(SUM(CASE WHEN (mov.mov_tipo in ('S','T') AND mov.set_saida = $set_codigo) THEN ite.ite_quantidade ELSE 0 END),0))
                ) as saldo_inicial"
		    ))
		    ->joinLeft(array("psi" => "psicotropicos"), "psi.psico_codigo=prod2.psico_codigo", array("psico_nome"))
		    ->join(array("ite" => "itens_movimento"), "ite.pro_codigo=prod2.pro_codigo", "")
		    ->join(array("mov" => "movimento"), "ite.mov_codigo=mov.mov_codigo", "")
		    ->where("mov.set_entrada = '" . $set_codigo . "' OR mov.set_saida = '" . $set_codigo . "'")
		    ->group(array("prod2.pro_codigo","prod2.pro_nome", "psi.psico_nome"))
		    ->order("pro_nome");

	    if ($data_inicial)
		    $subselect->where("mov.mov_data >= '$data_inicial'");

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("pro" => "produto"), array("pro_nome",
                "(SUM(CASE WHEN (mov_tipo = 'E' AND mov_entrada <> 'E-AE' $setEntrada) THEN ite.ite_quantidade ELSE 0 END)::integer) AS entrada",
                "(SUM(CASE WHEN (mov_tipo = 'E' AND mov_entrada = 'E-AE' $setEntrada) THEN ite.ite_quantidade ELSE 0 END)::integer) AS ajusteentrada",
                "(SUM(CASE WHEN (mov_tipo = 'S' AND mov_saida = 'D' $setSaida) THEN ite.ite_quantidade ELSE 0 END)::integer) AS dispensacao",
                "(SUM(CASE WHEN (mov_tipo = 'S' AND mov_saida = 'S-AE' $setSaida) THEN ite.ite_quantidade ELSE 0 END)::integer) AS ajustesaida",
                "(SUM(CASE WHEN (mov_tipo = 'T' $setEntrada) THEN ite.ite_quantidade ELSE 0 END)::integer) AS transferenciaentrada",
                "(SUM(CASE WHEN (mov_tipo = 'T' $setSaida) THEN ite.ite_quantidade ELSE 0 END)::integer) AS transferenciasaida",
                "((SELECT
                        round(coalesce(SUM(ite_quantidade),0))
                     FROM
                        produto p2
                     JOIN
                        itens_movimento i2 ON i2.pro_codigo = p2.pro_codigo
                     JOIN
                        movimento m2 ON m2.mov_codigo = i2.mov_codigo
                     WHERE
                         (mov_tipo = 'E' or mov_tipo = 'T')
                         AND mov_entrada IS NOT NULL
                         $datafSaldoInicial
                         $setEntrada
                         AND pro.pro_codigo = p2.pro_codigo) -
                        (SELECT
                                round(coalesce(SUM(ite_quantidade),0))
                            FROM
                                produto p2
                            JOIN
                                itens_movimento i2 ON i2.pro_codigo = p2.pro_codigo
                            JOIN
                                movimento m2 ON i2.mov_codigo = m2.mov_codigo
                            WHERE
                                (mov_tipo = 'S' OR mov_tipo = 'T') AND mov_saida IS NOT NULL
                                $datafSaldoInicial $setSaida AND pro.pro_codigo = p2.pro_codigo)) as saldo_inicial"))
            ->join(array("ite" => "itens_movimento"), "ite.pro_codigo=pro.pro_codigo", "")
            ->join(array("mov" => "movimento"), "mov.mov_codigo=ite.mov_codigo", "")
	        ->join(array("saldo" => $subselect), "saldo.pro_codigo=pro.pro_codigo", "saldo_inicial")
            ->group(array("pro_nome", "pro.pro_codigo", "saldo_inicial"))
            ->order(array("pro_nome"));

        if ($set_codigo)
            $where->where("mov.set_entrada= $set_codigo OR mov.set_saida = $set_codigo");

        if ($data_inicial)
            $where->where("mov.mov_data>= ?", $data_inicial);

        if ($data_final)
            $where->where("mov.mov_data <= ?", $data_final);

        if ($gru_codigo)
            $where->where("pro.gru_codigo = ?", $gru_codigo);

        if ($pros_codigo)
            $where->where("pro.pros_codigo = ?", $pros_codigo);

        if ($pro_codigo)
            $where->where("pro.pro_codigo = ?", $pro_codigo);
        return $this->fetchAll($where);
    }

    public function relMovimentacaoMateriaisAnalitico($set_codigo, $gru_codigo, $pros_codigo, $pro_codigo, $data_inicial, $data_final)
    {
        $datafSaldoInicial = "AND mov_data < '$data_inicial'";

        $setSaida = " AND set_saida = $set_codigo";
        $setEntrada = " AND set_entrada = $set_codigo";

        if ($pro_codigo) {
            $produto = " AND pro_codigo = $pro_codigo";
        } else {
            $produto = "";
        }

	    $subselect = $this->select(FALSE)
		    ->setIntegrityCheck(FALSE)
		    ->from(array("prod2" => "produto"), array("pro_codigo",
			    "(
				(SELECT SUM(COALESCE(sal.sal_qtde,0)) FROM saldo sal WHERE sal.pro_codigo = prod2.pro_codigo AND sal.set_codigo = $set_codigo)
				-
                (COALESCE(SUM(CASE WHEN (mov.mov_tipo in ('E','T') AND mov.set_entrada = $set_codigo) THEN ite.ite_quantidade ELSE 0 END),0))
                +
                (COALESCE(SUM(CASE WHEN (mov.mov_tipo in ('S','T') AND mov.set_saida = $set_codigo) THEN ite.ite_quantidade ELSE 0 END),0))
                ) as saldo_inicial"
		    ))
		    ->joinLeft(array("psi" => "psicotropicos"), "psi.psico_codigo=prod2.psico_codigo", array("psico_nome"))
		    ->join(array("ite" => "itens_movimento"), "ite.pro_codigo=prod2.pro_codigo", "")
		    ->join(array("mov" => "movimento"), "ite.mov_codigo=mov.mov_codigo", "")
		    ->where("mov.set_entrada = '" . $set_codigo . "' OR mov.set_saida = '" . $set_codigo . "'")
		    ->group(array("prod2.pro_codigo","prod2.pro_nome", "psi.psico_nome"))
		    ->order("pro_nome");

	    if ($data_inicial)
		    $subselect->where("mov.mov_data >= '$data_inicial'");

        $where = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("mov" => "movimento"), array("mov_codigo", "mov_data", "mov_tipo", "mov_entrada", "mov_saida"))
            ->join(array("ite" => "itens_movimento"), "ite.mov_codigo=mov.mov_codigo", "ite_quantidade")
            ->join(array("pro" => "produto"), "ite.pro_codigo=pro.pro_codigo", array("pro_nome"))
            ->joinLeft(array("setentrada" => "setor"), "setentrada.set_codigo = mov.set_entrada", array("setentrada" => "set_nome", "setentradacod" => "set_codigo"))
            ->joinLeft(array("setsaida" => "setor"), "setsaida.set_codigo = mov.set_saida", array("setsaida" => "set_nome", "setsaidacod" => "set_codigo"))
            ->joinLeft(array("usu" => "usuario"), "mov.usu_codigo = usu.usu_codigo", "usu_nome")
            ->joinLeft(array("fornec" => "fornecedor"), "mov.for_codigo = fornec.for_codigo", "for_nome")
	        ->join(array("saldo" => $subselect), "saldo.pro_codigo=pro.pro_codigo", "saldo_inicial")
            ->order(array("mov_data", "setsaida.set_nome", "pro_nome", "mov_codigo"));

        if ($set_codigo)
            $where->where("mov.set_entrada= $set_codigo OR mov.set_saida = $set_codigo");

        if ($data_inicial)
            $where->where("mov.mov_data>= ?", $data_inicial);

        if ($data_final)
            $where->where("mov.mov_data <= ?", $data_final);

        if ($gru_codigo)
            $where->where("pro.gru_codigo = ?", $gru_codigo);

        if ($pros_codigo)
            $where->where("pro.pros_codigo = ?", $pros_codigo);

        if ($pro_codigo)
            $where->where("pro.pro_codigo = ?", $pro_codigo);

        // echo "<pre>".print_r($where,1); exit;
        //die($where->__toString());
        //return $where;
        //die($where);
        return $this->fetchAll($where);
    }

	public function getSetorMovimento($mov_codigo, $transferencia=FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"))
			->join(array("mov" => "movimento"), "mov.set_entrada = set.set_codigo OR mov.set_saida = set.set_codigo", "mov_tipo")
			->join(array("uni" => "unidade"), "uni.uni_codigo = set.uni_codigo", array("uni_cnpj", "uni_cnes"))
			->where("mov.mov_codigo = $mov_codigo");
//		die($sql);
		if($transferencia){
			return $this->fetchAll($sql)->toArray();
		}
		return $this->fetchRow($sql);
    }

    //Dispensação
	public function listarDispensacoes($usr_codigo, $pesquisa=FALSE){
    	$subsql = "select cod_setor from logon where id_login = $usr_codigo order by dt_entrada desc limit 1";
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("mov" => "movimento"), array("mov_codigo", "to_char(mov_data_insercao, 'DD/MM/YYYY HH24:MI') as mov_data"))
			->join(array("set" => "setor"), "mov.set_saida=set.set_codigo", array("set_nome", "set_codigo"))
			->join(array("usu" => "usuario"), "mov.usu_codigo=usu.usu_codigo", array("usu_nome"))
			->where("mov.set_saida in ($subsql)")
			->where("mov.mov_saida = 'D'");
		if($pesquisa){
			if(strpos($pesquisa, "/") !== FALSE){
				$sql->where("to_char(mov_data, 'DD/MM/YYYY') = '$pesquisa'");
			}elseif(is_numeric($pesquisa)){
				$sql->where("mov.mov_codigo = $pesquisa");
			}else{
				$sql->where("(usu.usu_nome ilike '%$pesquisa%' OR set.set_nome ilike '%$pesquisa%')");
			}
			$sql->order(array("mov.mov_codigo DESC", "mov.mov_data"));
		}else{
			$sql->order(array("mov.mov_codigo DESC", "mov.mov_data"))
				->limit(50);
		}
		return $this->fetchAll($sql);
	}

	public function getDadosEdicaoDispensacao($mov_codigo) {
		$dados = array();
		$select = "mov.mov_codigo,
				  set.set_nome,
				  usu.usu_codigo,
				  usu.usu_nome,
				  CASE WHEN mov.med_codigo_interno ISNULL THEN '0' ELSE '1' END AS interno,
				  COALESCE(mov.med_codigo_interno,mov.med_codigo_externo) AS usr_codigo,
				  CASE WHEN mov.med_codigo_interno ISNULL THEN med.med_nome ELSE usr.usr_nome END AS usr_nome,
				  mov_data, tr_codigo";
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("mov" => "movimento"), $select)
			->join(array("set" => "setor"), "mov.set_saida = set.set_codigo", "")
			->join(array("usu" => "usuario"), "usu.usu_codigo = mov.usu_codigo", "")
			->joinLeft(array("usr" => "usuarios"), "(usr.usr_codigo = mov.med_codigo_interno OR usr.usr_codigo = mov.med_codigo_externo)", "")
			->joinLeft(array("med" => "medico"), "(med.med_codigo = mov.med_codigo_interno OR med.med_codigo = mov.med_codigo_externo)", "")
			->where("mov.mov_codigo=$mov_codigo");
		$dados['movimento'] = $this->fetchRow($sql)->toArray();

		if(count($dados['movimento']) > 0){
			$sqlItem = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("ite" => "itens_movimento"))
				->join(array("mov" => "movimento"), "ite.mov_codigo=mov.mov_codigo", "set_saida")
				->join(array("pro" => "produto"), "ite.pro_codigo=pro.pro_codigo")
				->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo = ite.usr_codigo","usr_nome")
				->where("ite.mov_codigo = $mov_codigo");
			$dados['movimento']['itens'] = $this->fetchAll($sqlItem)->toArray();
			if(count($dados['movimento']['itens']) > 0){
				foreach ($dados['movimento']['itens'] as $k => $d){
					$sqlSaldo = $this->select(FALSE)
						->setIntegrityCheck(FALSE)
						->from(array("sal" => "saldo"))
						->where("sal_lote = '" . $d['ite_lote']."'")
						->where("pro_codigo = " . $d['pro_codigo'])
						->where("sal_validade = '" . $d['ite_validade']."'")
						->where("sal_validade = '" . $d['ite_validade']."'")
						->where("set_codigo = '" . $d['set_saida']."'")
						->order("sal_codigo DESC")
						->limit(1);
//					die($sqlSaldo);
					$dados['movimento']['itens'][$k]['pro_saldo'] = $this->fetchRow($sqlSaldo)->sal_qtde;
				}
			}
		}
		return $dados;
	}

}
