<?php
Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_OdontoProcedimentos extends Elotech_Db_Table_Abstract {
    
    protected $_name = "odonto_procedimentos";
    protected $_primary = "odo_proc_codigo";
    protected $_dependentTables = array();
    
    // Lista procedimento a ser realizados
    public function listaProcedimentos($tratCodigo = FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("odp"=>"odonto_procedimentos"),array("odo_proc_codigo","odo_proc_dentenum","odo_proc_denteface","odo_proc_sextante","odo_proc_boca","odo_proc_denteanot","odo_proc_dtprogramada"))
                    ->join(array("proc"=>"procedimento"),"odp.proc_codigo=proc.proc_codigo",array("trim(proc.proc_nome) AS proc_nome"))
                    ->join(array("odpc"=>"odonto_procedimentos_controle"),"odp.odo_pcon_codigo=odpc.odo_pcon_codigo","")
                    ->where("odpc.odo_trat_codigo =?",$tratCodigo)
                    ->where("odp.odo_proc_status = FALSE");
        return $this->fetchAll($sql);
    }
    
    // Pega os dados de um procedimento em especifico
    public function getProcedimento($procCodigo = FALSE) {
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("odp"=>"odonto_procedimentos"),array("odo_proc_dentenum","odo_proc_denteface","odo_proc_denteanot","odo_proc_marcacao","odo_proc_sextante","odo_proc_boca","odo_proc_exodontia","proc_codigo"))
                    ->join(array("proc"=>"procedimento"),"odp.proc_codigo=proc.proc_codigo",array("proc.proc_nome"))
                    ->where("odp.odo_proc_codigo =?",$procCodigo);
        //die($sql);
        return $this->fetchRow($sql);
    }
    
    public function getProcedimentosOdontologicos(){
        $tbUsr = new Application_Model_Usuarios();
        $esp_codigo = $tbUsr->getUsrAtual()->esp_codigo;
        
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("proc"=>"procedimento"),array("proc_codigo","proc_nome","proc_codigo_sus"))
                    ->join(array("rl"=>"rl_procedimento_ocupacao"), "rl.co_procedimento=proc.proc_codigo_sus","")
                    ->join(array("esp"=>"especialidade"),"esp.cod_cbo=rl.co_ocupacao","")
                    ->where("esp_codigo=$esp_codigo")
                    ->order("proc_nome");
        return $this->fetchAll($sql);
    }
    
    // Lista apenas o último procedimento inserido
    public function getUltimoProcedimento($tratCodigo = FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("odp"=>"odonto_procedimentos"),array("odp.odo_proc_codigo"))
                    ->join(array("odpc"=>"odonto_procedimentos_controle"),"odp.odo_pcon_codigo = odpc.odo_pcon_codigo","")
                    ->join(array("odt"=>"odonto_tratamento"),"odpc.odo_trat_codigo=odt.odo_trat_codigo","")
                    ->where("odt.odo_trat_codigo =?",$tratCodigo)
                    ->order("odp.odo_proc_codigo DESC")
                    ->limit(1);
        return $this->fetchRow($sql);
    }

    public function buscaProcedimentosOdontologicos($tipo, $term = false){
        $tbUsr = new Application_Model_Usuarios();
        $esp_codigo = $tbUsr->getUsrAtual()->esp_codigo;
        $cod_cbo = $tbUsr->getUsrAtual()->cod_cbo;
        $where = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->distinct()
                    ->from(array("proc"=>"procedimento"),array("proc_codigo","proc_nome","proc_codigo_sus"))
                    ->join(array("rl"=>"rl_procedimento_ocupacao"), "rl.co_procedimento=proc.proc_codigo_sus AND rl.co_ocupacao = '$cod_cbo'","")
                    ->where("proc.proc_tipo_odonto in ('G', '$tipo')")
                    ->where("proc.proc_ativo = 'A'");
                    if($term){
	                    $where->where("proc_nome ilike '%$term%' OR proc_codigo_sus ilike '%$term%'");
                    }
                $where->order("proc_nome");
       return $this->fetchAll($where)->toArray();

    }
}

?>
