<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_PostoEnfermagem extends Elotech_Db_Table_Abstract {

  protected $_name = 'posto_enfermagem';// nome da tabela do banco
  protected $_primary = 'pe_codigo'; // pk da tabela
  protected $_dependentTables = array();

  // esse métod o é para tratar a ação sendo ela incluir ou alterar
  public function salvar(array $data) {
    $this->addRealName(array(
      "pe_descricao" => "descrição",
      "pe_observacao" => "observação"
    )); // isso serve para deixar bonitinho quando der erro por falta de um campo. De: 'O campo pe_descricao deve ser preenchido' para "O campo descrição deve ser preenchido"

    $this->valoresPadrao($data);

    if (empty($data['pe_codigo'])) {
      $this->notEmpty(array("pe_descricao", "ate_codigo"), $data);
      $data['pe_status'] = "A";
    }

    $this->emptyToUnset($data);
    $this->minLength(array("pe_descricao" => "10", "pe_observacao" => 3), $data, array("pe_observacao" => true));// tudo eu passo como array nas validações

    // verifica se há procedimentos
    if (!empty($data['proc_codigo'])) {
      $tbPat = new Application_Model_ProcedimentoAtendimento();
      $dados = array(
        "pe_codigo" => $data['pe_codigo'],
        "proc_codigo" => $data['proc_codigo']
      );
      $tbPat->salvar($dados);

      unset($data['proc_codigo']);
    }

    return parent::salvar($data); // ele retorna para a classe extendida com o "parent" os dados para dentro do "PAI" ele executar a query
  }

  private function valoresPadrao(&$data) {
    if (empty($data['ate_codigo']) || !isset($data['ate_codigo'])) {
      $tbAte = new Application_Model_Atendimento();
      $ate = $tbAte->temAtendimento();
      $data['ate_codigo'] = $ate->ate_codigo;
    }
  }

  public function buscarAtual() {
    $tbAte = new Application_Model_Atendimento();
    $ate = $tbAte->temAtendimento(); // descobre o atendimento que está na Session.
    return $this->fetchRow("ate_codigo=" . $ate->ate_codigo); // descobre o codigo do atendimento queestá na Session
  }

  public function buscar($pe_codigo = FALSE) {
    if (!$pe_codigo)
      return $this->buscarAtual();

    return $this->fetchRow("pe_codigo IN($pe_codigo)");
  }
  public function buscarTodas($pe_codigo = FALSE) {
    if (!$pe_codigo)
      return $this->buscarAtual();

    return $this->fetchAll("pe_codigo IN($pe_codigo)");
  }

  public function getLista($uni_codigo = FALSE, $posto_enfermagem = FALSE) {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("pe" => "posto_enfermagem"))
      ->join(array("ate" => "atendimento"), "ate.ate_codigo=pe.ate_codigo", "ate_data")
      ->join(array("age" => "agendamento"), "age.age_codigo=ate.age_codigo")
      ->join(array("usu" => "usuario"), "usu.usu_codigo=ate.usu_codigo", array("usu_codigo", "usu_nome", "usu_datanasc", "usu_mae", "usu_end_cidade", "usu_prontuario"))
      ->join(array("usr"=>"usuarios"), "usr.usr_codigo = ate.med_codigo", array("usr_nome"))
      ->joinLeft(array("pe_usr"=>"usuarios"), "pe_usr.usr_codigo = pe.usr_codigo", array("usr_pe"=>"usr_nome"))
      ->where("pe_status=?", "A")
      ->where("age.uni_codigo=?", $uni_codigo)
      ->where("age.age_atendido=?", "A")
      ->order("ate_data")
      ->order("pe_codigo");

    return $this->fetchAll($where);
  }

  public function finalizar($pe_codigo) {
    $pe = $this->fetchRow("pe_codigo=" . $pe_codigo);
    $pe->pe_status = "E";
    return $pe->save();
  }

  public function getHistorico($usu_codigo = FALSE, $data_inicial = FALSE, $data_final = FALSE, $limit = FALSE, $term = FALSE) {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("pe" => "posto_enfermagem"), array("pe_codigo", "pe_descricao", "pe_descricao_enfermagem", "pe_observacao"))
      ->join(array("ate" => "atendimento"), "ate.ate_codigo=pe.ate_codigo", array("ate_data", "ate_hora"))
      ->join(array("age" => "agendamento"), "ate.age_codigo=age.age_codigo", "age_data")
      ->joinLeft(array("hdh" => "historico_data_hora"), "hdh.age_codigo=age.age_codigo", "hdh_atendimento_fim")
      ->joinLeft(array("uni" => "unidade"), "uni.uni_codigo=age.uni_codigo", "uni_desc")
      ->joinLeft(array("usr" => "usuarios"), "usr.usr_codigo=age.med_codigo", "usr_nome")
      ->joinLeft(array("esp" => "especialidade"), "esp.esp_codigo=age.esp_codigo", "esp_nome")
      ->joinLeft(array("usr2" => "usuarios"), "usr2.usr_codigo=pe.usr_codigo", "usr_nome as usr_nome_enf")
      ->joinLeft(array("esp2" => "especialidade"), "esp2.esp_codigo=pe.esp_codigo", "esp_nome as esp_nome_enf")
      ->where("age.usu_codigo=?", $usu_codigo)
      ->order(array("ate.ate_data DESC"));

    if ($data_inicial)
      $where->where("age.age_data >= ?", $data_inicial);

    if ($data_final)
      $where->where("age.age_data <= ?", $data_final);

    if ($limit)
      $where->limit($limit);

    return $this->fetchAll($where);
  }

  public function getUltima($age_codigo){
      $tbAte = new Application_Model_Atendimento();

      if(!$age_codigo){
          $age_codigo = $tbAte->temAtendimento()->age_codigo; // descobre o atendimento que está na Session.
      }

      $sql = $this->select(FALSE)
          ->setIntegrityCheck(FALSE)
          ->from(array("pe" => "posto_enfermagem"))
          ->join(array("ate" => "atendimento"), "ate.ate_codigo = pe.ate_codigo")
          ->where("ate.age_codigo=$age_codigo")
          ->order("ate.ate_codigo DESC")
          ->order(" 1 DESC")
          ->limit(1);
      return $this->fetchRow($sql);

  }


}
