<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Procedimento extends Elotech_Db_Table_Abstract {

    protected $_name = 'procedimento';
    protected $_primary = 'proc_codigo';
    protected $_dependentTables = array();
    protected $_sequence = 'seq_proc_codigo';

    public function salvar(array $data) {
        $this->addRealName(array("proc_nome" => "descriÃ§Ã£o", "proc_sexo_novo" => ""));

        $this->notEmpty(array("proc_nome", "proc_sexo_novo"), $data);

        $data['proc_nome'] = strtoupper($data['proc_nome']);
        $this->emptyToUnset($data);

        return parent::salvar($data);
    }

    public function salvarApelido($data = false) {
        return parent::salvar($data);
    }

    /**
     * Retorna um select com as especialidades vinculadas ao profissional logado
     * Obs.: somente os procedimentos vinculados Ã  especialidade logada.
     * @return string <select>
     */
    public function selectTag() {
        $tbUsr = new Application_Model_Usuarios();
        $usr = $tbUsr->getUsrAtual();
        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("p" => "procedimento"), array("proc_codigo", "proc_nome"))
                ->join(array("rl" => "rl_procedimento_ocupacao"), "rl.co_procedimento=p.proc_codigo_sus", "")
                ->join(array("e" => "especialidade"), "e.cod_cbo=rl.co_ocupacao", "")
                ->joinLeft(array("pa" => "procedimento_atendimento"), "pa.proc_codigo=p.proc_codigo", "")
                ->joinLeft(array("a" => "atendimento"), "a.ate_codigo=pa.ate_codigo", "ate_data")
                ->where("e.esp_codigo=?", $usr->esp_codigo)
                ->group(array("p.proc_codigo", "a.ate_data"))
                ->order("proc_nome");
        return parent::selectTag($where, "proc_nome", NULL, TRUE, TRUE, NULL, NULL, TRUE);
    }

    /**
     * Buscar os procedimentos
     * usado para alimentar o plugin de busca (jquery)
     * @return json
     */
    public function buscar($term, $esp_codigo = FALSE) {
        if ($esp_codigo) {
            $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_vlsa", "proc_codigo_sus", "proc_apelido"))
                ->join(array("rpo" => "rl_procedimento_ocupacao"), "rpo.co_procedimento=proc.proc_codigo_sus", "co_procedimento")
                ->join(array("esp" => "especialidade"), "esp.cod_cbo=rpo.co_ocupacao", "")
                ->where("esp.esp_codigo = ?", $esp_codigo);
        } else {
            $where = $this->select(FALSE)
                ->distinct()
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_vlsa", "proc_codigo_sus", "proc_apelido", "(proc_codigo)||'' AS co_procedimento"));
        }

        if (is_numeric($term)) {
            $where->where("proc_codigo_sus ilike '$term%'");
        } else {
            $where->where("retira_acentos(proc_nome) ilike retira_acentos('%$term%') OR retira_acentos(proc_apelido) ilike retira_acentos('%$term%')");
        }
        
        $especiais = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_vlsa", "proc_codigo_sus", "proc_apelido"))
                ->join(array("rpo" => "rl_procedimento_ocupacao"), "rpo.co_procedimento=proc.proc_codigo_sus", "co_procedimento")
                ->where("rpo.co_procedimento IS NULL")
                ->order("proc_nome");
        
        if (is_numeric($term)) {
            $especiais->where("proc_codigo_sus ilike '$term%' AND proc_ativo = 'A'");
        } else {
            $especiais->where("(retira_acentos(proc_nome) ilike retira_acentos('%$term%') OR retira_acentos(proc_apelido) ilike retira_acentos('%$term%')) AND proc_ativo = 'A'");
        }
        
        $geral = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->union(array($where, $especiais), Zend_Db_Select::SQL_UNION);

        $all = $this->fetchAll($geral);

        $out = array();
        foreach ($all as $proc) {
            if ($proc->proc_apelido) {
                $out [] = array(
                    "id" => $proc->proc_codigo,
                    "label" => trim($proc->proc_nome."(".$proc->proc_apelido.")"),
                    "data" => $proc->toArray()
                );
            } else {
                $out [] = array(
                    "id" => $proc->proc_codigo,
                    "label" => trim($proc->proc_nome),
                    "data" => $proc->toArray()
                );
            }
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array()
            );
        }

        return $out;
    }

    private function buscaOrientacaoProcedimento($proc_codigo){
        $orientacoes = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("po" => "procedimento_orientacoes"))
            ->join(array("ori" => "orientacoes_exames"), "po.ori_exa_codigo = ori.ori_exa_codigo", "ori_exa_orientacoes")
            ->where("po.proc_codigo = $proc_codigo")
            ->where("ori_exa_status = 'A'");
//        die($orientacoes);
        return $this->fetchAll($orientacoes);
    }
    
    public function buscarAtivos($term, $esp_codigo = FALSE) {
        if ($esp_codigo) {
            $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_vlsa", "proc_codigo_sus", "proc_apelido"))
                ->join(array("rpo" => "rl_procedimento_ocupacao"), "rpo.co_procedimento=proc.proc_codigo_sus", "co_procedimento")
                ->join(array("esp" => "especialidade"), "esp.cod_cbo=rpo.co_ocupacao", "")
                ->where("esp.esp_codigo = ?", $esp_codigo);
        } else {
            $where = $this->select(FALSE)
                ->distinct()
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_vlsa", "proc_codigo_sus", "proc_apelido", "(proc_codigo)||'' AS co_procedimento"));
        }

        if (is_numeric($term)) {
            $where->where("proc_codigo_sus ilike '$term%' AND proc_ativo = 'A'");
        } else {
            $where->where("(retira_acentos(proc_nome) ilike retira_acentos('%$term%') OR retira_acentos(proc_apelido) ilike retira_acentos('%$term%')) AND proc_ativo = 'A'");
        }
        
        $especiais = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_vlsa", "proc_codigo_sus", "proc_apelido"))
                ->joinLeft(array("rpo" => "rl_procedimento_ocupacao"), "rpo.co_procedimento=proc.proc_codigo_sus", "COALESCE(co_procedimento, (proc_codigo)||'') AS co_procedimento")
                ->where("rpo.co_procedimento IS NULL")
                ->order("proc_nome");
        
        if (is_numeric($term)) {
            $especiais->where("proc_codigo_sus ilike '$term%' AND proc_ativo = 'A'");
        } else {
            $especiais->where("(retira_acentos(proc_nome) ilike retira_acentos('%$term%') OR retira_acentos(proc_apelido) ilike retira_acentos('%$term%')) AND proc_ativo = 'A'");
        }
        
        $geral = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->union(array($where, $especiais), Zend_Db_Select::SQL_UNION);
        $all = $this->fetchAll($geral);

        $out = array();
        foreach ($all as $proc) {
            $dtProc = $proc->toArray();
            $dtProc['orientacoes'] = $this->buscaOrientacaoProcedimento($proc->proc_codigo)->toArray();
            if ($proc->proc_apelido) {
                $out [] = array(
                    "id" => $proc->proc_codigo,
                    "label" => trim($proc->proc_nome."(".$proc->proc_apelido.")"),
                    "data" => $dtProc
                );
            } else {
                $out [] = array(
                    "id" => $proc->proc_codigo,
                    "label" => trim($proc->proc_nome),
                    "data" => $dtProc
                );
            }
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array()
            );
        }

        return $out;
    }

    public function buscarProcedimentoNaoSelecionadoNoCombo($term, $esp_codigo = false, $procedimentos = false) {

        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_vlsa", "proc_codigo_sus", "proc_apelido"))
                ->order("proc_nome");

        if ($esp_codigo) {
            $where->where("esp.esp_codigo = ?", $esp_codigo)
                    ->join(array("rpo" => "rl_procedimento_ocupacao"), "rpo.co_procedimento=proc.proc_codigo_sus", "")
                    ->join(array("esp" => "especialidade"), "esp.cod_cbo=rpo.co_ocupacao", "");
        } else {
            $where->distinct();
        }

        if (is_numeric($term)) {
            $where->where("proc_codigo_sus ilike '$term%'");
        } else {
            $where->where("retira_acentos(proc_nome) ilike retira_acentos('%$term%') OR retira_acentos(proc_apelido) ilike retira_acentos('%$term%')");
        }

        if ($procedimentos) {
            $where->where("proc.proc_codigo not in ($procedimentos)");
        }
        //echo $where;
        $all = $this->fetchAll($where);

        $out = array();
        foreach ($all as $proc) {
            if ($proc->proc_apelido) {
                $out [] = array(
                    "id" => $proc->proc_codigo,
                    "label" => trim($proc->proc_nome."(".$proc->proc_apelido.")"),
                    "data" => $proc->toArray()
                );
            } else {
                $out [] = array(
                    "id" => $proc->proc_codigo,
                    "label" => trim($proc->proc_nome),
                    "data" => $proc->toArray()
                );
            }
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array()
            );
        }

        return $out;
    }

    public function buscarProcNaoRealizado($term, $esp_codigo = FALSE, $age = FALSE, $usu = FALSE) {

        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_vlsa", "proc_codigo_sus", "proc_apelido"))
                ->order("proc_nome");

        if ($age) {
            $where->where("proc.proc_codigo not in
                            (
                            select pat.proc_codigo
                            from procedimento_atendimento as pat
                            join atendimento as ate
                              on pat.ate_codigo = ate.ate_codigo
                            join agendamento as age
                              on ate.age_codigo = age.age_codigo
                            where age.age_codigo = $age
                            and pat.usr_codigo = $usu)");
        }

        if ($esp_codigo) {
            $where->where("esp.esp_codigo = ?", $esp_codigo)
                    ->join(array("rpo" => "rl_procedimento_ocupacao"), "rpo.co_procedimento=proc.proc_codigo_sus", "")
                    ->join(array("esp" => "especialidade"), "esp.cod_cbo=rpo.co_ocupacao", "");
        } else {
            $where->distinct();
        }

        if (is_numeric($term)) {
            $where->where("proc_codigo_sus ilike '$term%'");
        } else {
            $where->where("retira_acentos(proc_nome) ilike retira_acentos('%$term%') OR retira_acentos(proc_apelido) ilike retira_acentos('%$term%')");
        }

        $all = $this->fetchAll($where);

        $out = array();
        foreach ($all as $proc) {
            if ($proc->proc_apelido) {
                $out [] = array(
                    "id" => $proc->proc_codigo,
                    "label" => trim($proc->proc_nome."(".$proc->proc_apelido.")"),
                    "data" => $proc->toArray()
                );
            } else {
                $out [] = array(
                    "id" => $proc->proc_codigo,
                    "label" => trim($proc->proc_nome),
                    "data" => $proc->toArray()
                );
            }
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array()
            );
        }
        return $out;
    }

    public function buscarExames($term, $esp_codigo = FALSE) {

        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo as exame_codigo", "proc_nome as exame_nome", "proc_codigo_sus as exame_cod_sus", "proc_apelido as exame_apelido"))
                ->order("proc_nome");

        if ($esp_codigo) {
            $where->where("esp.esp_codigo = ?", $esp_codigo)
                    ->join(array("rpo" => "rl_procedimento_ocupacao"), "rpo.co_procedimento=proc.proc_codigo_sus", "")
                    ->join(array("esp" => "especialidade"), "esp.cod_cbo=rpo.co_ocupacao", "");
        } else {
            $where->distinct();
        }

        if (is_numeric($term)) {
            $where->where("proc_codigo_sus ilike '$term%'");
        } else {
            $where->where("retira_acentos(proc_nome) ilike retira_acentos('%$term%') OR retira_acentos(proc_apelido) ilike retira_acentos('%$term%')");
        }

        $all = $this->fetchAll($where);

        $out = array();
        foreach ($all as $proc) {
            if ($proc->exame_apelido) {
                $out [] = array(
                    "id" => $proc->exame_codigo,
                    "label" => trim($proc->exame_nome."(".$proc->exame_apelido.")"),
                    "data" => $proc->toArray()
                );
            } else {
                $out [] = array(
                    "id" => $proc->exame_codigo,
                    "label" => trim($proc->exame_nome),
                    "data" => $proc->toArray()
                );
            }
        }

        if (!count($out)) {
            $out [] = array(
                "id" => 0,
                "label" => "Nenhum item encontrado",
                "data" => array()
            );
        }

        return $out;
    }

    public function getCboPorCodigoSus($codigoSus) {

        $sql = $this->select(FALSE)
                ->distinct(TRUE)
                ->setIntegrityCheck(FALSE)
                ->from(array("p" => "procedimento"), array(""))
                ->join(array("rpo" => "rl_procedimento_ocupacao"), "rpo.co_procedimento = p.proc_codigo_sus", "")
                ->join(array("e" => "especialidade"), "e.cod_cbo = rpo.co_ocupacao", "e.cod_cbo")
                ->where("p.proc_codigo_sus = '$codigoSus'")
                ->order("e.cod_cbo ASC");

        return $this->fetchAll($sql)->toArray();
    }
    
    public function buscaOutrosProcedimentosColetivos() {
        
        $sql = $this->select(FALSE)
                ->distinct(TRUE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome", "proc_codigo_sus"))
                ->where("proc.proc_codigo_sus in ('0101010044','0101020082','0101010052','0101010060','0101010079','0101010087','0101020023','0101020040')")
                ->order("proc.proc_nome ASC");

        return $this->fetchAll($sql);
    }

    /**
     * Transforma um Zend_Db_Table_Rowset_Abstract em uma string, concatenando os procedimentos com virgula
     * @param Zend_Db_Table_Rowset_Abstract $rowset
     * @return string 
     */
    public function procToStr($rowset) {
        $out = array();
        foreach ($rowset as $proc)
            $out [] = $proc->proc_nome;

        return implode(", ", $out);
    }

    /**
     *
     * @return type 
     */
    public function getItensCadastrados() {
        return $this->fetchAll("proc_cadastrado_manualmente='t'", "proc_nome DESC", 15);
    }

    public function getAll(){
        return $this->fetchAll(null,"proc_codigo DESC",15);
    }

    public function excluir($proc_codigo) {
        $item = $this->fetchRow("proc_codigo=$proc_codigo");
        if ($item)
            $item->delete();

        return true;
    }

    public function editar($proc_codigo) {
        return $this->fetchRow("proc_codigo=$proc_codigo");
    }

    public function pesquisar($dados) {
        $where = $this->select(true);
        if (is_string($dados))
            $where->where("proc_nome ilike '%$dados%'");
        if (is_double($dados))
            $where->where("proc_valor = ?", (double) $dados);
        if (is_int($dados))
            $where->where("proc_codigo = ?", (int) $dados);
        $where->limit(20);
        return $this->fetchAll($where);
    }

    /**
     *
     * @return type 
     */
    public function getProcedimentoPeloCodigoSus($proc_codigo_sus) {

        return $this->fetchRow("proc_codigo_sus = '$proc_codigo_sus'");
    }

    public function getProcedimentosComApelidos() {
        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from("procedimento")
                ->where("proc_apelido is not null");
        return $this->fetchAll($where);
    }

    public function buscarProcedimentosComApelidos($term = FALSE) {
        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"))
                ->where("proc_nome ilike '%$term%' OR proc_apelido ilike '%$term%'")
                ->where("proc_apelido is not null");
        return $this->fetchAll($where);
    }

    public function listaProcedimentosDuplicados() {
        $sql = $this->select()
                ->setIntegrityCheck(FALSE)
                ->from(array("proc" => "procedimento"), array("proc_codigo", "proc_nome"))
                ->where("proc_codigo_sus IN (SELECT proc_codigo_sus FROM procedimento where proc_codigo_sus is not null GROUP BY proc_codigo_sus HAVING count(*) > 1)");
        return $this->fetchAll($sql);
    }

}
