<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_ProcedimentoClassificacaoServico extends Elotech_Db_Table_Abstract
{

    protected $_name = 'procedimento_classificacao_servico';
    protected $_primary = 'pcs_codigo';


    public function getServicoByCod($cod = FALSE)
    {

        $sql = $this->select()
            ->distinct(TRUE)
            ->setIntegrityCheck(FALSE)
            ->from(["tbserv" => "tb_servico"], ["no_servico", "co_servico"])
            ->join(["rlps" => "rl_procedimento_servico"], "tbserv.co_servico = rlps.co_servico", "")
            ->join(["proc" => "procedimento"], "proc.proc_codigo_sus = rlps.co_procedimento", "");
        if ($cod) {
            $sql->where("proc.proc_codigo = ?", $cod);
        }
        return $this->fetchAll($sql);
    }

    public function getClassificacaoByCod($cod = FALSE)
    {

        $sql = $this->select()
            ->setIntegrityCheck(FALSE)
            ->distinct(TRUE)
            ->from(["tbsc" => "tb_servico_classificacao"], ["co_classificacao", "no_classificacao"])
            ->join(["rlps" => "rl_procedimento_servico"], "tbsc.co_servico = rlps.co_servico", "")
            ->join(["proc" => "procedimento"], "proc.proc_codigo_sus = rlps.co_procedimento", "");
        if ($cod) {
            $sql->where("proc.proc_codigo = ?", $cod);
        }
        return $this->fetchAll($sql);
    }

    public function salvar($data)
    {

        return parent::salvar($data);
    }

    public function getByProc($proc_codigo)
    {
        $sql = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(["pcs" => "procedimento_classificacao_servico"])
            ->join(["uni" => "unidade"], "pcs.uni_codigo = uni.uni_codigo", "uni_desc")
            ->where("proc_codigo = $proc_codigo")
            ->order("uni.uni_desc");
        return $this->fetchAll($sql);
    }

    public function verificaExiste($uni_codigo,$proc_codigo)
    {
        $dados = $this->fetchAll("uni_codigo = $uni_codigo AND proc_codigo = $proc_codigo");
        if(count($dados)>0){
            RETURN TRUE;
        }
        RETURN FALSE;
    }

    public function excluir($id){
        return parent::delete("pcs_codigo = $id");
    }
}
