<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_ProdutoSubgrupo extends Elotech_Db_Table_Abstract {

  protected $_name = 'produto_subgrupo';
  protected $_primary = 'pros_codigo';

  /**
   * Salvar o item, insert ou update
   * @param array $data chave=>valor
   * @return int Primary Key
   */
  public function getSubGrupos() {
    return $this->fetchAll();
  }

  public function listar() {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("subgrupo" => "produto_subgrupo"), array("pros_codigo", "pros_descricao"))
      ->order("pros_descricao");
    return $this->fetchAll($where);
  }
}
