<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_ReceitaItens extends Elotech_Db_Table_Abstract {

	protected $_name = 'itemreceita';
	protected $_primary = 'irec_codigo';
	protected $_sequence = 'seq_irec_codigo';
	protected $_dependentTables = array();

	public function salvar(array $data, $tipo = 'posto') {
		$this->addRealName(array(
			"irec_quantidade" => "quantidade",
			"irec_produto" => "produto",
			"desc_produto" => "descricao"
		));


		$this->filterDigits(array("irec_quantidade", "irec_qtde_pendente"), $data);
		$this->notEmpty(array("rec_codigo"), $data);

		if ($tipo == "externo") {
			$this->notEmpty(array("irec_produto", "desc_produto"), $data);
		} else {
			$this->maiorQueZero(array("pro_codigo"), $data);
		}

		$this->emptyToUnset($data);

		return parent::salvar($data);
	}

	public function getItens($tipo = false, $recCodigo = false, $selecionados = false) {
		$tbRec = new Application_Model_Receita();
		if($recCodigo){
			$rec = $tbRec->getReceita($recCodigo);
		}else{
			$rec = $tbRec->temReceita($tipo);
			if (!$rec) {
				return false;
			}
		}

		$codigoAtendimento = $rec['ate_codigo'];

		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->distinct()
			->from(array("i" => "itemreceita"), array("irec_codigo", "irec_recomendacao", "irec_quantidade", "UPPER(irec_produto) AS irec_produto", "UPPER(desc_produto) AS desc_produto"))
			->joinLeft(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", array("pro_nome"))
			->join(array("rec" => "receita"), "rec.rec_codigo = i.rec_codigo", array("rec_validade", "rec_data"))
			->join(array("ate" => "atendimento"), "ate.ate_codigo = rec.ate_codigo", array())
			->join(array("un" => "unidade"), "un.uni_codigo = ate.uni_codigo", array())
			->where("rec_tipo = '$tipo'")
			->where("ate.ate_codigo = $codigoAtendimento")
			->order("pro_nome");

		if ($selecionados && $selecionados != 'null' && $selecionados != null) {
			$sql->where("irec_codigo in($selecionados)");
		}
		return $this->fetchAll($sql);
	}

	public function getItensInternacao($io_codigo, $selecionados = false) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("ati" => "atendimento_internacao"), "ati.io_codigo")
			->join(array("ate" => "atendimento"), "ate.ate_codigo=ati.ate_codigo", "")
			->join(array("rec" => "receita"), "rec.ate_codigo = ate.ate_codigo", array("rec_data", "rec_validade"))
			->join(array("ite" => "itemreceita"), "rec.rec_codigo = ite.rec_codigo", array("irec_codigo", "irec_recomendacao", "irec_quantidade", "irec_produto", "desc_produto"))
			->joinLeft(array("p" => "produto"), "p.pro_codigo=ite.pro_codigo", array("pro_nome"))
			->where("io_codigo=?", $io_codigo)
			->order("rec_data");

		if ($selecionados && $selecionados != 'null' && $selecionados != null) {
			$where->where("ite.irec_codigo in($selecionados)");
		}

		return $this->fetchAll($where);
	}

	public function getHistorico($ate_codigo, $tipo = FALSE) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("i" => "itemreceita"), array("irec_codigo", "irec_recomendacao", "irec_quantidade", "irec_produto", "desc_produto"))
			->joinLeft(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", array("pro_nome"))
			->join(array("r" => "receita"), "r.rec_codigo=i.rec_codigo", "")
			->where("r.ate_codigo=?", $ate_codigo)
			->order("pro_nome");

		if ($tipo)
			$where->where("r.rec_tipo=?", $tipo);

		return $this->fetchAll($where);
	}

	public function getItem($irec_codigo) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("i" => "itemreceita"), array("irec_codigo", "irec_recomendacao", "irec_quantidade", "irec_produto", "desc_produto"))
			->joinLeft(array("p" => "produto"), "p.pro_codigo=i.pro_codigo", array("pro_nome"))
			->join(array("r" => "receita"), "r.rec_codigo=i.rec_codigo", "rec_data")
			->where("i.irec_codigo=?", $irec_codigo);

		return $this->fetchRow($where);
	}

	/**
	 * Exclui um item da receita.
	 * O métod o verifica se faz parte do agendamento atual
	 * @param int $irec_codigo
	 */
	public function excluir($irec_codigo) {
		$age_codigo = Application_Model_Agendamento::usuEmAberto()->age_codigo;

		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("i" => "itemreceita"), "")
			->join(array("r" => "receita"), "r.rec_codigo=i.rec_codigo", "rec_codigo")
			->join(array("a" => "atendimento"), "a.ate_codigo=r.ate_codigo", array("age_codigo", "usu_codigo"))
			->where("irec_codigo=?", $irec_codigo)
			->where("age_codigo=?", $age_codigo);

		$item = $this->fetchRow($where);
		if ($item) {
			$this->delete("irec_codigo=" . $irec_codigo);
			return $item;
		}
		return false;
	}

	public function receitasPorUsuario($usu_codigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("rec" => "receita"), array("rec_validade", "rec_data"))
			->join(array("itrec" => "itemreceita"), "itrec.rec_codigo=rec.rec_codigo", array("itrec.pro_codigo", "irec_recomendacao", "irec_quantidade", "irec_produto", "itrec.irec_codigo"))
			->join(array("ate" => "atendimento"), "ate.ate_codigo=rec.ate_codigo", "")
			->joinLeft(array("pro" => "produto"), "pro.pro_codigo=itrec.pro_codigo", "pro_nome")
			->where("usu_codigo=?", $usu_codigo);

		return $this->fetchAll($sql);
	}

	public function getItensReceita($rec_codigo) {
		$where = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("irec" => "itemreceita"))
			->join(array("pro" => "produto"), "pro.pro_codigo=irec.pro_codigo", array("pro_codigo", "pro_nome"))
			->join(array("rec" => "receita"), "rec.rec_codigo=irec.rec_codigo", "")
			->where("irec.rec_codigo=$rec_codigo")
			->where("rec_finalizada<>'S'")
			->where("irec_qtde_pendente > 0")
			->order("irec_codigo");
		return $this->fetchAll($where);
	}

	public function getCountHistoricoReceitaItens($idUsuario, $tipoMedicamento, $idProd = null) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["ir" => "itemreceita"], ["irec_codigo", "irec_recomendacao", "irec_quantidade", "irec_produto", "ir.pro_codigo"])
			->join(["r" => "receita"], "r.rec_codigo = ir.rec_codigo", ["rec_codigo", "rec_tipo", "rec_data"])
			->join(["a" => "atendimento"], "a.ate_codigo = r.ate_codigo", ["usu_codigo"])
			->join(["usr" => "usuarios"], "a.med_codigo = usr.usr_codigo", ["usr_nome"])
			->join(["p" => "produto"], "p.pro_codigo = ir.pro_codigo", ["p.pro_nome"])
			->join(["uni" => "unidade"], "uni.uni_codigo = a.uni_codigo", ["uni.uni_desc"])
			// ->where("r.rec_data < ?" , date('Y-m-d'))
			->where("r.rec_tipo = ?", $tipoMedicamento)
			->where("a.usu_codigo = ?", $idUsuario);
		if (!empty($idProd)) {
			$sql->where("p.pro_codigo = ?", $idProd);
		}
		$sql->order("r.rec_data DESC");
		return (count($this->fetchAll($sql)->toArray()) > 0);
	}

	public function getHistoricoReceitaItens($idUsuario, $tipoMedicamento, $idProd = null) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(["ir" => "itemreceita"], ["r.rec_data", "usr.usr_nome", "uni.uni_desc", "irec_codigo", "irec_recomendacao", "irec_quantidade", "irec_produto", "ir.pro_codigo"])
			->join(["r" => "receita"], "r.rec_codigo = ir.rec_codigo", ["rec_codigo", "rec_tipo"])
			->join(["a" => "atendimento"], "a.ate_codigo = r.ate_codigo", ["usu_codigo"])
			->join(["usr" => "usuarios"], "a.med_codigo = usr.usr_codigo", [])
			->join(["p" => "produto"], "p.pro_codigo = ir.pro_codigo", ["p.pro_nome"])
			->join(["uni" => "unidade"], "uni.uni_codigo = a.uni_codigo", [])
			->where("r.rec_tipo = ?", $tipoMedicamento)
			->where("a.usu_codigo = ?", $idUsuario);
		if (!empty($idProd)) {
			$sql->where("p.pro_codigo = ?", $idProd);
		}
		$sql->order(array("r.rec_data DESC", "usr_nome", "uni.uni_desc"));

		$itens = $this->fetchAll($sql)->toArray();
		$retorno = array();
		foreach ($itens as $item) {
			$title = date("d/m/Y", strtotime($item["rec_data"])) . " - " . $item["usr_nome"] . " - " . $item["uni_desc"];
			$retorno[$this->sanitizeString($title)][$title][] = $item;
		}
		return $retorno;
	}

	//Métod o criado para trazer apenas os itens requeridos de receita médica via internação.
	public function getReceitaMedicaDaInternacao($io_codigo, $idPaciente) {
		$where = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("ati" => "atendimento_internacao"), "")
			->join(array("ate" => "atendimento"), "ate.ate_codigo=ati.ate_codigo", "")
			->join(array("rec" => "receita"), "rec.ate_codigo = ate.ate_codigo", array())
			->join(array("ite" => "itemreceita"), "rec.rec_codigo = ite.rec_codigo", array("irec_quantidade", "irec_produto"))
			->joinLeft(array("p" => "produto"), "p.pro_codigo=ite.pro_codigo", array("pro_nome"))
			->where("io_codigo = ?", $io_codigo)
			->where("usu_codigo = ?", $idPaciente)
			->order("rec_data");
		return $this->fetchAll($where);
	}
}
