<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_RlAteTipoImovel extends Elotech_Db_Table_Abstract {

    protected $_name = 'rl_ate_tipo_imovel';
    protected $_primary = 'ati_codigo';
    protected $_sequence = 'ati_codigo_seq';

    public function getDados() {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("rati" => "rl_ate_tipo_imovel"))
                ->order(array("ati_codigo"));
        return $this->fetchAll($sql);
    }
    
    public function getAteImovel($ate_codigo = false) {
        
        $qnt = $this->verificaSeJaExisteAtendimento($ate_codigo);
        
        if($qnt[ati_codigo] > 0){
            $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("rati" => "rl_ate_tipo_imovel"),array("no_cds_tipo_imovel", "ati_codigo"))
                    ->where("ate_codigo = $ate_codigo")
                    ->order(array("ati_codigo"));
            return $this->fetchRow($sql)->toArray();
        }else{
            return false;
        }
    }
    
    public function verificaSeJaExisteAtendimento($ate_codigo = false){
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("rati" => "rl_ate_tipo_imovel"),array("ati_codigo"))
                ->joinRight(array("ate" => "atendimento"),"ate.ate_codigo = rati.ate_codigo", "ate_codigo")
                ->where("ate.ate_codigo = $ate_codigo");
        return $this->fetchRow($sql)->toArray();
    }
    
}
