<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_RlVacinaEstrategiaImunobiologico extends Elotech_Db_Table_Abstract
{

    protected $_name = 'rl_vacina_estrategia_imunobiologico';
    protected $_primary = 'rlvei_codigo';


    public function getEstrategia($tvi_codigo){
        $where = $this->select()
                    ->distinct(TRUE)
                    ->setIntegrityCheck(FALSE)
                    ->from(["rlvei"=>"rl_vacina_estrategia_imunobiologico"],"")
                    ->join(["tve"=>"tb_vacina_estrategia"],"tve.tve_codigo=rlvei.tve_codigo",["tve_codigo","tve_descricao"])
                    ->where("rlvei.tvi_codigo = $tvi_codigo")
                    ->order("tve_descricao");
        return $this->fetchAll($where);

    }

    public function getDose($tvi_codigo, $tve_codigo){
        $where = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(["rlvei"=>"rl_vacina_estrategia_imunobiologico"],"")
            ->join(["tvd"=>"tb_vacina_dose"],"tvd.tvd_codigo=rlvei.tvd_codigo",["tvd_codigo","tvd_descricao"])
            ->where("rlvei.tvi_codigo = $tvi_codigo AND rlvei.tve_codigo = $tve_codigo")
            ->order("tvd_descricao");
        return $this->fetchAll($where);

    }

}