<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Saldo extends Elotech_Db_Table_Abstract {

    protected $_schema = 'social';
    protected $_name = 'saldo';
    protected $_primary = 'sal_codigo';

    public function salvar(array $data) {
        throw new Zend_Validate_Exception("Esta tabela só pode ser manipulada via trigger", 1000);
    }

    /**
     * Informa a quantidade do produto em estoque
     * @param int $pro_codigo
     * @param int $set_codigo
     * @param string $lote
     * @param string $validade
     * @return int
     */
    public function getSaldoAtual($pro_codigo, $set_codigo = FALSE, $lote = "SEM_LOTE", $validade = "2900-12-31") {
        if (!$set_codigo) {
            $tbUsr = new Application_Model_Usuarios;
            $set_codigo = $tbUsr->getUsrAtual()->set_codigo;
        }

        $where = $this->select(TRUE)
                ->columns("sal_qtde")
                ->where("pro_codigo=?", $pro_codigo)
                ->where("set_codigo=?", $set_codigo)
                ->where("sal_qtde > 0")
                ->where("sal_lote=?", $lote)
                ->where("sal_validade=?", $validade);

        return (int) $this->fetchRow($where)->sal_qtde;
    }

    public function getLotes($pro_codigo, $set_codigo, $somenteNaoVencidos = TRUE, $enviados = FALSE) {


        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("sal" => "saldo"), array("sal_codigo", "sal_qtde", "sal_dose_lote", "sal_lote", "sal_validade", "sal_qtde as saldo_original"))
                ->join(array("pro" => "produto"), "pro.pro_codigo=sal.pro_codigo", array("pro_nome", "pro_codigo"))
                ->join(array("ite" => "itens_movimento"), "ite.pro_codigo=sal.pro_codigo AND sal.sal_lote=ite.ite_lote", array("ite_codbarras"))
                ->where("sal.set_codigo=?", $set_codigo)
                ->where("sal.sal_qtde > 0")
                ->where("sal.pro_codigo=?", $pro_codigo)
                ->order(array("sal.sal_validade", "sal.sal_qtde"));

        if ($somenteNaoVencidos) {
            $where->where("sal_validade >= CURRENT_DATE");
        }

        return $this->fetchAll($where);
    }

    public function getLotesComCodBarras($pro_codigo, $set_codigo, $ite_codbarras = FALSE, $somenteNaoVencidos = TRUE, $enviados = FALSE) {

        $where = $this->select(FALSE)
                ->distinct()
                ->setIntegrityCheck(FALSE)
                ->from(array("sal" => "saldo"), array("sal_codigo", "sal_qtde", "sal_dose_lote", "sal_lote", "sal_validade", "sal_qtde as saldo_original"))
                ->join(array("pro" => "produto"), "pro.pro_codigo=sal.pro_codigo", array("pro_nome", "pro_codigo"));
            $where->joinLeft(array("ite" => "itens_movimento"), "ite.pro_codigo=sal.pro_codigo AND sal.sal_lote=ite.ite_lote AND sal.sal_validade=ite.ite_validade AND sal.pro_codigo=ite.pro_codigo AND ite.ite_codbarras is not null AND ite.ite_codbarras <> '' AND ite.ite_codbarras <> ' '", array("ite_codbarras"));
        
        $where->where("sal.set_codigo=?", $set_codigo)
              ->where("sal.sal_qtde > 0");
        if ($pro_codigo) {
            $where->where("sal.pro_codigo=?", $pro_codigo);
        }

        if ($somenteNaoVencidos) {
            $where->where("sal_validade >= CURRENT_DATE");
        }

        if ($ite_codbarras) {
            $where->where("EXISTS(SELECT TRUE FROM itens_movimento itm WHERE itm.pro_codigo=sal.pro_codigo AND sal.sal_lote=itm.ite_lote AND sal.pro_codigo=itm.pro_codigo AND sal.sal_validade=ite.ite_validade AND itm.ite_codbarras='$ite_codbarras' AND '$ite_codbarras'     <> '' AND itm.ite_codbarras is not null LIMIT 1)");
        }
        $where->order(array("sal.sal_validade", "sal.sal_qtde"));

        return $this->fetchAll($where);
    }

    public function getSaldoPorSetor($set_codigo = FALSE) {
        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("s" => "saldo"));
        if ($set_codigo)
            $where->where("set_codigo =?", $set_codigo);

        return $this->fetchAll($where);
    }

    public function excluiSaldoPorSetor($setores = FALSE) {
        try {
            $sql = $this
                    ->getDefaultAdapter()
                    ->query("DELETE FROM social.saldo WHERE set_codigo IN ($setores)")
                    ->fetchAll();
            return $sql;
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao excluir saldo: " . $ex->getMessage());
        }
        /* $item = $this->getSaldoPorSetor($set_codigo);
          if ($item) {
          foreach ($item as $value){
          try{
          $value->delete();
          } catch (Exception $exc) {
          throw new Zend_Validate_Exception($exc->getMessage());
          }
          }
          }
          return true; */
    }

    public function relatorioPosicaoEstoqueContaContabil($exercicio, $conta = FALSE) {

        $exercicio = (int) $exercicio;

        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("a" => "social.saldo"), array("pro_codigo",
                    "sal_qtde" => "sum(sal_qtde)"))
                ->join(array("b" => "social.produto"), "a.pro_codigo = b.pro_codigo", "pro_nome")
                ->joinLeft(array("c" => "siscop.est_item"), "c.item = b.pro_codigo_elotech", array("unidade", "item"))
                ->joinLeft(array("d" => "siscop.est_classificacao"), "c.modelo = d.modelo and c.classificacao = d.classificacao", "conta_plano")
                ->joinLeft(array("f" => "siscop.plano"), "f.conta = d.conta_plano and f.exercicio = '$exercicio'", array("conta_plano_descricao" => "descricao"))
                ->where("sal_qtde != 0 and f.conta =?", $conta)
                ->group(array("d.conta_plano", "a.pro_codigo", "f.descricao", "b.pro_nome", "c.unidade", "c.item"))
                ->order("d.conta_plano");

        return $this->fetchAll($where);
    }

    public function getValorUnidadeProduto($produtoCodigo) {

        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("a" => "social.itens_movimento"), "ite_vlrunit")
                ->join(array("b" => "social.movimento"), "a.mov_codigo = b.mov_codigo", "")
                ->where("b.mov_tipo = 'E' and a.pro_codigo=?", $produtoCodigo)
                ->order("b.mov_data desc")
                ->limit(1);

        return $this->fetchRow($where);
    }

    public function getContas($exercicio) {

        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("a" => "siscop.plano"), "descricao")
                ->join(array("b" => "siscop.est_classificacao"), "a.conta = b.conta_plano", "b.conta_plano")
                ->where("b.ativo = 'S' and a.exercicio=?", $exercicio)
                ->order("a.descricao asc")
                ->group(array("b.conta_plano", "a.descricao"));

        return $this->fetchAll($where);
    }

    public function getContaNome($conta) {

        $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("a" => "siscop.plano"), array("conta_plano_descricao" => "descricao"))
                ->where("a.conta =?", $conta);
        return $this->fetchAll($where);
    }

    public function relatorioMovimentacaoClassificacaoEntrada($dataFinal = false, $dataInicio = false, $setor = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->distinct()
                ->from(array("sal" => "social.saldo"), array("saldo_total" => "sum(sal_qtde)", "valor_total" => "sum(ite_vlrtotal)"))
                ->join(array("ite" => "social.itens_movimento"), "sal.pro_codigo = ite.pro_codigo", "")
                ->join(array("mov" => "social.movimento"), "ite.mov_codigo = mov.mov_codigo", "")
                ->join(array("pro" => "social.produto"), "sal.pro_codigo = pro.pro_codigo", "")
                ->join(array("est" => "siscop.est_item"), "pro.pro_codigo_elotech = est.item", "")
                ->join(array("cla" => "siscop.est_classificacao"), "cla.classificacao = est.classificacao", array("classificacao", "descricao"))
                ->where("mov.mov_tipo = 'E' and sal.sal_qtde != 0 and sal.sal_qtde is not null")
                ->group(array("cla.classificacao", "cla.descricao"))
                ->order("cla.classificacao");
        if ($dataFinal) {
            $sql->where("mov.mov_data < '$dataFinal'");
        }
        if ($dataInicio) {
            $sql->where("mov.mov_data > '$dataInicio'");
        }
        if ($setor != '0') {
            $sql->where("mov.set_entrada = $setor or mov.set_saida = $setor");
        }
        return $this->fetchAll($sql)->toArray();
    }

    public function relatorioMovimentacaoClassificacaoSaida($dataFinal = false, $dataInicio = false, $setor = FALSE) {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->distinct()
                ->from(array("sal" => "social.saldo"), array("saldo_total" => "sum(sal_qtde)", "pro_codigo", "sal_lote"))
                ->join(array("ite" => "social.itens_movimento"), "sal.pro_codigo = ite.pro_codigo", "")
                ->join(array("mov" => "social.movimento"), "ite.mov_codigo = mov.mov_codigo", "")
                ->join(array("pro" => "social.produto"), "sal.pro_codigo = pro.pro_codigo", "")
                ->join(array("est" => "siscop.est_item"), "pro.pro_codigo_elotech = est.item", "")
                ->join(array("cla" => "siscop.est_classificacao"), "cla.classificacao = est.classificacao", array("classificacao", "descricao"))
                ->where("mov.mov_tipo = 'S' and sal.sal_qtde != 0 and sal.sal_qtde is not null")
                ->group(array("cla.classificacao", "cla.descricao", "sal.sal_lote", "sal.pro_codigo"))
                ->order(array("cla.classificacao", "sal.sal_lote", "sal.pro_codigo"));
        if ($dataFinal) {
            $sql->where("mov.mov_data < '$dataFinal'");
        }
        if ($dataInicio) {
            $sql->where("mov.mov_data > '$dataInicio'");
        }
        if ($setor != '0') {
            $sql->where("mov.set_entrada = $setor or mov.set_saida = $setor");
        }

        return $this->fetchAll($sql)->toArray();
    }

}
