<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Setor extends Elotech_Db_Table_Abstract {

	protected $_name = "setor";
	protected $_primary = "set_codigo";
	protected $_sequence = "seq_uni_codigo";

	// Métod o que retorna os 15 últimos setores
	public function getSetor() {
		$where = $this->select(FALSE)
			->setIntegrityCheck()
			->from(array("set" => "setor"), array("set_codigo", "set_nome"))
			->order(array("set_codigo DESC"))
			->limit(15);
		return $this->fetchAll($where);
	}

	// Métod o que salva os dados em BD
	public function salvar(array $data) {
		$set_codigo = parent::salvar($data);
	}

	/**
	 * Buscar os setores
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term = FALSE, $set_logado = FALSE) {
		if ($term)
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("set" => "setor"), array("set_codigo", "set_nome", "ativo"))
				->where("retira_acentos(set_nome) ilike retira_acentos('%$term%')", "S")
				->order(array("set_nome"))
				->limit(15);

		if ($set_logado == 1) {
			$tbUsr = new Application_Model_Usuarios();
			$usr = $tbUsr->getUsrAtual();
			$where->join(array("us" => "usuarios_setores"), "us.set_codigo=set.set_codigo", "")
				->where("usr_codigo=$usr->usr_codigo");
		}
		//die($where);
		$all = $this->fetchAll($where);
		$setores = array();
		foreach ($all as $usu) {
			$setores [] = array(
				"id" => $usu->set_codigo,
				"label" => $usu->set_nome.($usu->ativo == 'N' ? " - INATIVO":""),
				"data" => $usu->toArray()
			);
		}

		if (!count($setores)) {
			$setores [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("set_codigo" => "0", "set_nome" => "")
			);
		}

		return $setores;
	}

	public function buscarDestino($term = FALSE, $set_logado = FALSE) {
		if ($term)
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("set" => "setor"), array("set_codigo as set_codigo_destino", "set_nome as set_nome_destino", "ativo"))
				->where("retira_acentos(set_nome) ilike retira_acentos('%$term%')", "S")
				->order(array("set_nome"))
				->limit(15);

		if ($set_logado == 1) {
			$tbUsr = new Application_Model_Usuarios();
			$usr = $tbUsr->getUsrAtual();
			$where->join(array("us" => "usuarios_setores"), "us.set_codigo=set.set_codigo", "")
				->where("usr_codigo=$usr->usr_codigo");
		}
		//die($where);
		$all = $this->fetchAll($where);
		$setores = array();
		foreach ($all as $usu) {
			$setores [] = array(
				"id" => $usu->set_codigo_destino,
				"label" => $usu->set_nome_destino.($usu->ativo == 'N' ? " - INATIVO":""),
				"data" => $usu->toArray()
			);
		}

		if (!count($setores)) {
			$setores [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("set_codigo_destino" => "0", "set_nome_destino" => "")
			);
		}

		return $setores;
	}

	public function buscarUnidadeSetor($term = FALSE, $uni_codigo = FALSE) {

		if ($term)
			$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("set" => "setor"), array("set_codigo", "set_nome"))
				->where("retira_acentos(set_nome) ilike retira_acentos('%$term%')", "S")
				->where("ativo = 'S'")
				->order(array("set_nome"))
				->limit(15);
		if ($uni_codigo) {
			$where->where("uni_codigo in ($uni_codigo)");
		}
		$all = $this->fetchAll($where);
		$setores = array();
		foreach ($all as $usu) {
			$setores [] = array(
				"id" => $usu->set_codigo,
				"label" => $usu->set_nome,
				"data" => $usu->toArray()
			);
		}

		if (!count($setores)) {
			$setores [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("set_codigo" => "0", "set_nome" => "")
			);
		}

		return $setores;
	}

	public function selectTag($setor_logon = FALSE, $id = FALSE, $set_codigo = FALSE, $retringe_inventario = FALSE) {
		$where = $this->select(FALSE)
			->distinct()
			->setIntegrityCheck(FALSE)
			->from(array("s" => "setor"), array("set_codigo", "set_nome"))
			->where("set_estoque = 'S'")
			->where("ativo = 'S'")
			->order("set_nome");


		if ($setor_logon) {
			$tbUsr = new Application_Model_Usuarios();
			$usr_codigo = $tbUsr->getUsrAtual()->usr_codigo;
			$tbUsrSet = new Application_Model_UsuariosSetores();
			$setores = null;
			foreach ($tbUsrSet->getSetoresPorUsuario($usr_codigo) as $setor) {
				$setores .= $setor['set_codigo'] . ",";
			}
			$setores = substr($setores, 0, -1);
			$where->where("s.set_codigo in ($setores)");
		}

		if (!$id)
			$id = "set_codigo";

		if ($retringe_inventario) {
			$where->joinLeft(array("inv" => "inventario"), "s.set_codigo = inv.set_codigo", array(""));
			$where->where("s.set_codigo not in (SELECT inv.set_codigo FROM inventario AS inv WHERE (inv_status = 'A'))");
		}
		//die($where);

		return parent::selectTag($where, "set_nome", NULL, TRUE, TRUE, $id, "$id", TRUE, $set_codigo);
	}

	public function buscarSetoresPorUnidade($uni_codigo = FALSE, $usr_codigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"), array("set.set_codigo", "set.set_nome"))
			->join(array("uset" => "usuarios_setores"), "set.set_codigo=uset.set_codigo", array(""))
			->join(array("usr" => "usuarios"), "uset.usr_codigo=usr.usr_codigo", array(""))
			->join(array("uni" => "unidade"), "set.uni_codigo=uni.uni_codigo", array(""))
			->where("uni.uni_codigo =?", $uni_codigo)
			->where("usr.usr_codigo =?", $usr_codigo);
		return $this->fetchAll($sql);
	}

	public function buscaSetorPorUsuario($usr_codigo = FALSE) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"), array("set.set_codigo", "set.set_nome"))
			->join(array("uset" => "usuarios_setores"), "set.set_codigo=uset.set_codigo", array(""))
			->join(array("usr" => "usuarios"), "uset.usr_codigo=usr.usr_codigo", array(""))
			->join(array("uni" => "unidade"), "set.uni_codigo=uni.uni_codigo", array(""))
			->where("usr.usr_codigo =?", $usr_codigo);
		return $this->fetchAll($sql);
	}

	public function verificaFuncaoSetor($set_codigo = FALSE) {
		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"))
			->where("set_codigo=$set_codigo");
		return $this->fetchRow($sql);
	}

	public function verificaInventarioSetor($set_codigo = FALSE) {
		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("inv" => "inventario"));
			if($set_codigo)
				$sql->where("set_codigo = $set_codigo");
			$sql->where("inv_status = 'A'");
		return $this->fetchRow($sql);
	}

	public function getTodosSetores() {
		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"), array("set_nome", "set_codigo"));
		return $this->fetchAll($sql)->toArray();
	}

	public function getTodosSetoresQueUsamHorus() {
		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"), array("set_nome", "set_codigo"))
			->where("set_usa_horus = 'S'");
		return $this->fetchAll($sql)->toArray();
	}

	public function getSetorNomePorCodigo($codigo) {
		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"), "set_nome")
			->where("set_codigo = $codigo");
		return $this->fetchRow($sql)->toArray();
	}

	public function getParamSetorPorCodigo($codigoSetor, $param = array()) {
		$sql = $this->select()
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"), $param)
			->where("set_codigo = $codigoSetor");
		return $this->fetchRow($sql)->toArray();
	}

	public function getSetorPorCodigo($set_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("set" => "setor"))
			->join(array("uni" => "unidade"), "uni.uni_codigo = set.uni_codigo", array("uni_cnpj", "uni_cnes"))
			->where("set.set_codigo = $set_codigo");
		return $this->fetchRow($sql);
	}

	public function getSetorInventario($uni_codigo) {
		$sql = $this->select(FALSE)
			->setIntegrityCheck()
			->from(["set" => "setor"], ["set_codigo", "set_nome"])
			->where("set_estoque = 'S'")
			->where("uni_codigo = ?", $uni_codigo)
			->order("set_codigo DESC");
		return $this->fetchAll($sql);
	}

}
