<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_TbCdsFichaAtivCol extends Elotech_Db_Table_Abstract {

  protected $_name = 'tb_cds_ficha_ativ_col';
  protected $_primary = 'co_cds_ficha_ativ_col';
  protected $_sequence = 'seq_co_cds_ficha_ativ_col';

  public function getDados() {
    $tbUsr = new Application_Model_Usuarios();
    $uni_codigo = $tbUsr->getUsrAtual()->uni_codigo;

    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("tbf" => "tb_cds_ficha_ativ_col"))
      ->join(array("tac" => "tb_cds_tipo_ativ_col"), "tbf.tp_cds_ativ_col=tac.co_cds_tipo_ativ_col", array("no_cds_tipo_ativ_col"))
      ->joinLeft(array("ficha" => "esus_atividade_coletiva"), "ficha.co_cds_ficha_ativ_col = tbf.co_cds_ficha_ativ_col", array("uuid_ficha"))
      ->join(array("usr" => "usuarios"), "tbf.usr_codigo=usr.usr_codigo", array("usr_nome"))
      //->where("tbf.uni_codigo=$uni_codigo")
      ->order(array("dt_ativ_col DESC", "co_cds_ficha_ativ_col DESC"))
      ->limit(15);
    return $this->fetchAll($sql);
  }

  public function busca($busca = FALSE, $tipoBusca = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("tbf" => "tb_cds_ficha_ativ_col"))
      ->join(array("tac" => "tb_cds_tipo_ativ_col"), "tbf.tp_cds_ativ_col=tac.co_cds_tipo_ativ_col", array("no_cds_tipo_ativ_col"))
      ->joinLeft(array("ficha" => "esus_atividade_coletiva"), "ficha.co_cds_ficha_ativ_col = tbf.co_cds_ficha_ativ_col", array("uuid_ficha"))
      ->join(array("usr" => "usuarios"), "tbf.usr_codigo=usr.usr_codigo", array("usr_nome"));
    switch ($tipoBusca) {
      case 1:
        $sql->where("usr.usr_nome ILIKE '%$busca%'");
        break;
      case 2:
        $sql->where("tbf.dt_ativ_col = '$busca'");
        break;
      case 3:
        $sql->where("tbf.cod_cnes_unidade = '$busca'");
        break;
      case 4:
        $sql->where("tbf.cod_equipe_ine = '$busca'");
        break;
    }
    return $this->fetchAll($sql);
  }

  public function getDadosPorId($codFicha = FALSE) {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("tbf" => "tb_cds_ficha_ativ_col"))
      ->join(array("usr" => "usuarios"), "tbf.usr_codigo=usr.usr_codigo", array("usr_nome"))
      ->where("co_cds_ficha_ativ_col =?", $codFicha);
    return $this->fetchRow($sql);
  }

  public function salvar($dados) {
    $this->emptyToUnset($dados, FALSE);
    try {
      return parent::salvar($dados);
    } catch (Exception $ex) {
      die($ex->getMessage());
      throw new Zend_Validate_Exception("Falha ao salvar Ficha: " . $ex->getMessage());
    }
    return true;
  }

  /* Dados de Relatório */
  public function getDadosRelatorio($filtro = array()) {
    try {
      $sqlUnidade = $this->select()
        ->setIntegrityCheck(FALSE)
        ->distinct()
        ->from(array("tbfac" => "tb_cds_ficha_ativ_col"), "")
        ->join(array("uni" => "unidade"), "uni.uni_codigo = tbfac.uni_codigo  OR uni.uni_cnes = tbfac.cod_cnes_unidade::integer ", array("uni_codigo", "uni_desc", "uni_cnes"))
        ->join(array("usr" => "usuarios"), "usr.usr_codigo = tbfac.usr_codigo", "")
        ->join(array("rlficha" => "rl_cds_ficha_ativ_col_prof"), "usr.usr_codigo = rlficha.usr_codigo AND tbfac.co_cds_ficha_ativ_col = rlficha.co_cds_ficha_ativ_col", "")
        ->where("uni.uni_as IS FALSE OR uni.uni_as IS NULL")
        ->where("CASE WHEN 1=(SELECT 1 FROM usuarios where usr_acesso_unidades = 'S' and usr_codigo = ".$_SESSION{'id_login'}.") THEN 1 = 1
                            ELSE uni.uni_codigo IN (SELECT unu.uni_codigo FROM unidade_usuarios unu WHERE unu.usr_codigo = ".$_SESSION{'id_login'}.") END");
      if ($filtro['unidade'] > 0) {
        $sqlUnidade->where("uni.uni_codigo = " . $filtro['unidade']);
      }
      if ($filtro['dataInicial'] && $filtro['dataFinal']) {
        $sqlUnidade->where("tbfac.dt_ativ_col BETWEEN '" . $this->dateToBd($filtro['dataInicial']) . "' AND '" . $this->dateToBd($filtro['dataFinal']) . "'");
      }
//            die($sqlUnidade);
      $unidades = $this->fetchAll($sqlUnidade)->toArray();

      foreach ($unidades as $key_uni => $unidade) {
        $sql = $this->select()
          ->setIntegrityCheck(FALSE)
          ->distinct()
          ->from(
            array("tbfac" => "tb_cds_ficha_ativ_col"),
            array("dt_ativ_col", "hr_inicio", "hr_fim", "co_cds_ficha_ativ_col", "qt_participante_ativ",
              "equipe_ine" => "CASE COALESCE(cod_equipe_ine, 'NULL') WHEN 'NULL' THEN 'Não Informado' ELSE cod_equipe_ine END"))
          ->join(array("usr" => "usuarios"), "usr.usr_codigo = tbfac.usr_codigo", "usr.usr_nome")
          ->join(array("rlficha" => "rl_cds_ficha_ativ_col_prof"), "usr.usr_codigo = rlficha.usr_codigo AND tbfac.co_cds_ficha_ativ_col = rlficha.co_cds_ficha_ativ_col", "")
          ->joinLeft(array("esp" => "especialidade"), "esp.cod_cbo = rlficha.cbo",
            array("especialidade" => "CASE COALESCE(esp.esp_nome, 'NULL') WHEN 'NULL' THEN 'Não Informado' ELSE esp.esp_nome END"))
          ->join(array("ctpc" => "tb_cds_tipo_ativ_col"), "tbfac.tp_cds_ativ_col = ctpc.co_cds_tipo_ativ_col", "no_cds_tipo_ativ_col")
          ->where("tbfac.uni_codigo = " . $unidade['uni_codigo'] . " OR tbfac.cod_cnes_unidade::integer = " . $unidade['uni_cnes']);
        if ($filtro['atividade'] > 0) {
          $sql->where("tbfac.tp_cds_ativ_col = " . $filtro['atividade']);
        }
        if ($filtro['responsavel'] > 0) {
          $sql->where("usr.usr_codigo = " . $filtro['responsavel']);
        }
        if ($filtro['dataInicial'] && $filtro['dataFinal']) {
          $sql->where("tbfac.dt_ativ_col BETWEEN '" . $this->dateToBd($filtro['dataInicial']) . "' AND '" . $this->dateToBd($filtro['dataFinal']) . "'");
        }
        $sql->order(array("tbfac.dt_ativ_col", "usr.usr_nome"));

        $unidades[$key_uni]["responsavel"] = $this->fetchAll($sql)->toArray();
        foreach ($unidades[$key_uni]["responsavel"] as $key_res => $responsavel) {
          //Temas para reuniao
          $sqlTemasReuniao = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("cfact" => "rl_cds_ficha_ativ_col_tema"), "")
            ->join(array("act" => "tb_cds_ativ_col_tema"), "act.co_cds_ativ_col_tema = cfact.co_cds_ativ_col_tema", array("no_cds_ativ_col_tema"))
            ->where("cfact.co_cds_ficha_ativ_col =" . $responsavel['co_cds_ficha_ativ_col']);
          $temas_reuniao = $this->fetchAll($sqlTemasReuniao)->toArray();
          $unidades[$key_uni]["responsavel"][$key_res]['tema_reuniao'] = (count($temas_reuniao) > 0 ? $temas_reuniao : array(array("no_cds_ativ_col_tema" => "Não informado")));

          //Temas para saude
          $sqlTemasSaude = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("cfacp" => "rl_cds_ficha_ativ_col_pratica"), "")
            ->join(array("acp" => "tb_cds_ativ_col_pratica"), "acp.co_cds_ativ_col_pratica = cfacp.co_cds_ativ_col_pratica", array("no_cds_ativ_col_pratica"))
            ->where("cfacp.co_cds_ficha_ativ_col =" . $responsavel['co_cds_ficha_ativ_col'])
            ->where("acp.co_cds_ativ_col_pratica IN (29,19,1,4,5,7,8,10,13,14,15,6,16,17,18,21)");
          $temas_saude = $this->fetchAll($sqlTemasSaude)->toArray();
          $unidades[$key_uni]["responsavel"][$key_res]['tema_saude'] = (count($temas_saude) > 0 ? $temas_saude : array(array("no_cds_ativ_col_pratica" => "Não informado")));

          //Práticas
          $sqlPraticas = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("cfacp" => "rl_cds_ficha_ativ_col_pratica"), "")
            ->join(array("acp" => "tb_cds_ativ_col_pratica"), "acp.co_cds_ativ_col_pratica = cfacp.co_cds_ativ_col_pratica", array("no_cds_ativ_col_pratica"))
            ->where("cfacp.co_cds_ficha_ativ_col =" . $responsavel['co_cds_ficha_ativ_col'])
            ->where("acp.co_cds_ativ_col_pratica IN (20,2,23,9,11,25,26,27,28,22,3,24,12,30)");
          $praticas = $this->fetchAll($sqlPraticas)->toArray();
          $unidades[$key_uni]["responsavel"][$key_res]['praticas'] = (count($praticas) > 0 ? $praticas : array(array("no_cds_ativ_col_pratica" => "Não informado")));

          //Público alvo
          $sqlPA = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(array("rl" => "rl_cds_ficha_ativ_col_pub_alvo"), "")
            ->join(array("tcacpa" => "tb_cds_ativ_col_publico_alvo"), "tcacpa.co_cds_ativ_col_publico_alvo = rl.co_cds_ativ_col_publico_alvo", array("no_cds_ativ_col_publico_alvo"))
            ->where("rl.co_cds_ficha_ativ_col =" . $responsavel['co_cds_ficha_ativ_col']);
          $publico_alvo = $this->fetchAll($sqlPA)->toArray();
          $unidades[$key_uni]["responsavel"][$key_res]['publico_alvo'] = (count($publico_alvo) > 0 ? $publico_alvo : array(array("no_cds_ativ_col_publico_alvo" => "Não informado")));

          //Participantes
          $sqlPart = $this->select()
            ->setIntegrityCheck(FALSE)
            ->distinct()
            ->from(array("acp" => "tb_cds_ativ_col_participante"))
            ->join(array("usu" => "usuario"), "acp.usu_codigo = usu.usu_codigo", "usu_nome")
            ->where("acp.co_cds_ficha_ativ_col = " . $responsavel['co_cds_ficha_ativ_col'])
            ->order("usu_nome");
          $unidades[$key_uni]["responsavel"][$key_res]['participantes'] = $this->fetchAll($sqlPart)->toArray();
        }
      }

      return array(
        "unidades" => $unidades,
        "filtro" => $this->pesquisaDadosFiltro($filtro)
      );
    } catch (Exception $e) {
      die($e->getMessage());
    }
  }

  private function pesquisaDadosFiltro($filtro = array()) {
    $atividade = "Todas";
    $unidade = "Todas";
    $responsavel = "Todos";
    if ($filtro['atividade'] > 0) {
      $sql = $this->select()
        ->setIntegrityCheck(FALSE)
        ->from("tb_cds_tipo_ativ_col", "no_cds_tipo_ativ_col")
        ->where("co_cds_tipo_ativ_col=" . $filtro['atividade']);

      $atividade = $this->fetchRow($sql)->no_cds_tipo_ativ_col;
    }
    if ($filtro['unidade'] > 0) {
      $sql = $this->select()
        ->setIntegrityCheck(FALSE)
        ->from("unidade", "uni_desc")
        ->where("uni_codigo=" . $filtro['unidade']);

      $unidade = $this->fetchRow($sql)->uni_desc;
    }
    if ($filtro['responsavel'] > 0) {
      $sql = $this->select()
        ->setIntegrityCheck(FALSE)
        ->from("usuarios", "usr_nome")
        ->where("usr_codigo=" . $filtro['responsavel']);

      $responsavel = $this->fetchRow($sql)->usr_nome;
    }
    return array(
      "atividade" => $atividade,
      "unidade" => $unidade,
      "responsavel" => $responsavel,
      "data" => $filtro['dataInicial'] . " ~ " . $filtro['dataFinal']
    );
  }

  private function arrayToString($array = array(), $column) {
    return implode(",", array_map(function ($row) use ($column) {
      return $row[$column];
    }, $array));
  }

  private function dateToBd($date) {
    $dt = explode("/", $date);
    return $dt[2] . "-" . $dt[1] . "-" . $dt[0];
  }
}
