<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_TbCdsTipoEncamOdonto extends Elotech_Db_Table_Abstract {

  protected $_name = 'tb_cds_tipo_encam_odonto';
  protected $_primary = 'co_cds_tipo_encam_odonto';
  protected $_sequence = 'seq_co_cds_tipo_encam_odonto';

  public function getDados($tipoConsulta) {
    $arrayTipos = [
      '16',
      '12',
      '13',
      '14'
    ];

    /* A opção 17 - Alta do episódio não pode ser selecionada se no campo tiposConsultaOdonto for selecionada uma
	   das opções 1 - Primeira consulta odontológica programática ou 2 - Consulta de retorno em odontologia. */
    ($tipoConsulta != 1 && $tipoConsulta != 2 ? array_push($arrayTipos, '17') : '');

    /* A opção 15 - Tratamento concluído só pode ser selecionada se no campo tiposConsultaOdonto for selecionada uma
	   das opções 1 - Primeira consulta odontológica programática ou 2 - Consulta de retorno em odontologia. */
    ($tipoConsulta == 1 || $tipoConsulta == 2 ? array_push($arrayTipos, '15') : '');

    /*Ajuste para a ficha odontológica*/
      if(!$tipoConsulta){
          array_push($arrayTipos, '15');
      }

    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("tbl" => "tb_cds_tipo_encam_odonto"))
      ->where("co_cds_tipo_encam_odonto IN (" . implode(',', $arrayTipos) . ")")
      ->order(array("co_cds_tipo_encam_odonto"));
    return $this->fetchAll($sql);
  }

  public function getEncaminhamentos() {
    $sql = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("tbl" => "tb_cds_tipo_encam_odonto"))
      ->where("co_cds_tipo_encam_odonto NOT IN (16,12,13,14,15,17)")
      ->order(array("co_cds_tipo_encam_odonto"));
    return $this->fetchAll($sql);
  }

  public function getDadosEdit($codFicha) {
    $tpl = ($codFicha) ? " AND rl_cds_atend.ate_codigo = $codFicha" : "";
    $sql = $this->select(FALSE)->distinct()
      ->setIntegrityCheck(FALSE)
      ->from(array("tbl" => "tb_cds_tipo_encam_odonto"))
      ->joinLeft(array("rl_cds_atend" => "rl_cds_atend_odonto_tipo_encam"), "tbl.co_cds_tipo_encam_odonto=rl_cds_atend.tp_cds_encam_odonto $tpl", "co_rl_cds_atend_odonto_tipo_encam")
      ->where("co_cds_tipo_encam_odonto IN (16,12,13,14,15,17)")
      ->order(array("co_cds_tipo_encam_odonto"));
    return $this->fetchAll($sql);
  }

  public function getEncaminhamentosEdit($codFicha) {
    $tpl = ($codFicha) ? " AND rl_cds_atend.ate_codigo = $codFicha" : "";
    $sql = $this->select(FALSE)->distinct()
      ->setIntegrityCheck(FALSE)
      ->from(array("tbl" => "tb_cds_tipo_encam_odonto"))
      ->joinLeft(array("rl_cds_atend" => "rl_cds_atend_odonto_tipo_encam"), "tbl.co_cds_tipo_encam_odonto=rl_cds_atend.tp_cds_encam_odonto $tpl", "co_rl_cds_atend_odonto_tipo_encam")
      ->where("co_cds_tipo_encam_odonto NOT IN (16,12,13,14,15,17)")
      ->order(array("co_cds_tipo_encam_odonto"));
    return $this->fetchAll($sql);
  }

  public function getCondutasEncaminhamentosAtendimento($ateCodigo) {
    $sql = $this->select(FALSE)
    ->setIntegrityCheck(FALSE)
    ->from(array("atend_indiv_cond" => "rl_cds_atend_odonto_tipo_encam"))
    ->where("ate_codigo = " . $ateCodigo)
    ->order(array("tp_cds_encam_odonto"));
    return $this->fetchAll($sql);
  }

	public function getCondutasGeral() {
		$sql = $this->select(FALSE)
			->setIntegrityCheck(FALSE)
			->from(array("tbl" => "tb_cds_tipo_encam_odonto"))
			->order(array("co_cds_tipo_encam_odonto"));
		return $this->fetchAll($sql);
	}

}
