<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_TbCdsTipoVigSaudeBucal extends Elotech_Db_Table_Abstract {

    protected $_name = 'tb_cds_tipo_vig_saude_bucal';
    protected $_primary = 'co_cds_tipo_vig_saude_bucal';
    protected $_sequence = 'seq_co_cds_tipo_vig_saude_bucal';

    public function getDados() {
        $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("tbl" => "tb_cds_tipo_vig_saude_bucal"))
                ->order(array("co_cds_tipo_vig_saude_bucal"));
        return $this->fetchAll($sql);
    }

    public function getDadosEdit($codFicha)
    {
        if ($codFicha) {
            $sql = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("tbl" => "tb_cds_tipo_vig_saude_bucal"))
                ->joinLeft(array("rl_cds_atend" => "rl_cds_atend_odont_tip_vig_buc"), "tbl.co_cds_tipo_vig_saude_bucal=rl_cds_atend.tp_cds_vig_saude_bucal AND rl_cds_atend.ate_codigo = $codFicha", "co_rl_cds_atend_odont_tip_vig_buc")
                ->order(array("co_cds_tipo_vig_saude_bucal"));
        }
        return $this->fetchAll($sql);
    }

}
