<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_TbEquipe extends Elotech_Db_Table_Abstract {

    protected $_name = 'tb_equipe';
    protected $_primary = 'co_seq_equipe';
    

    public function salvar($dados) {
        try{
            return parent::salvar($dados);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao salvar equipe: ".$ex->getMessage());
        }
        return true;
    }
    
    public function getEquipePorIne($ine=FALSE){
            if(empty($ine)){
                return false;
            }
            
            $where = $this->select(FALSE)
                          ->setIntegrityCheck(FALSE)
                          ->from(array("eqp"=>"tb_equipe"),array("co_seq_equipe","no_equipe"))
                          ->where("nu_ine =?",$ine)
                          ->where("st_ativo = 'A'");
            return $this->fetchRow($where);
    }
    
     public function atualizaStatusGeral(){
        $where = $this->select()->getPart(Zend_Db_Table_Select::WHERE);
        $where = $where[0];
        $data = array('st_ativo'=> "I");
        return $this->update($data);
    }
    
    public function inativarEquipesComOMesmoIne($nu_ine = FALSE){

        $data = array(
           'st_ativo' => 'I'
        );
        $where = $this->getAdapter()->quoteInto('nu_ine = ?', $nu_ine);

        $this->update($data, $where);

        }
    
     public function verificaSeJáExiste($ine=FALSE,$uni_codigo=FALSE){
        $where = $this->select(FALSE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("teqp" => "tb_equipe"),array("qtd"=>"count(*)","co_seq_equipe"))
                      ->where("nu_ine =?",$ine)
                      ->where("uni_codigo =?",$uni_codigo)
                      ->group(array("co_seq_equipe"));
        //die($where);
        return $this->fetchRow($where);

    }
}
