<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_TipoDocumento extends Elotech_Db_Table_Abstract {

  protected $_name = 'tipo_documento';
  protected $_primary = 'td_codigo';

  public function salvar($data) {
    return parent::salvar($data);
  }

  public function excluir($id) {
    return parent::delete("td_codigo = $id");
  }

  public function buscar($term) {
    return $this->fetchAll("td_descricao ILIKE '%$term%'");
  }

  public function listar() {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("tipo" => "tipo_documento"), array("td_codigo", "td_descricao"))
      ->order("td_descricao");
    return $this->fetchAll($where);
  }

  public function getById($id) {
    return $this->fetchRow("td_codigo = $id");
  }

}
