<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_TipoProduto extends Elotech_Db_Table_Abstract {

  protected $_name = 'tipo_produtos';
  protected $_primary = 'tp_codigo';

  public function salvar($data) {
    return parent::salvar($data);
  }

  public function excluir($id) {
    return parent::delete("tp_codigo = $id");
  }

  public function buscar($term) {
    return $this->fetchAll("tp_descricao ILIKE '%$term%'");
  }

  public function listar() {
    $where = $this->select(FALSE)
      ->setIntegrityCheck(FALSE)
      ->from(array("tipo" => "tipo_produtos"), array("tp_codigo", "tp_descricao"))
      ->where("tp_status IS TRUE")
      ->order("tp_descricao");
    return $this->fetchAll($where);
  }

  public function getById($id) {
    return $this->fetchRow("tp_codigo = $id");
  }

  public function getAll() {
    return $this->fetchAll();
  }


}
