<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_TransporteLocais extends Elotech_Db_Table_Abstract {

    protected $_name = 'transporte_locais';// nome da tabela do banco
    protected $_primary = 'loc_codigo'; // pk da tabela

    public function salvar($data){
        try { 
            return parent::salvar($data);
        } catch (Exception $exc) {
            throw new Zend_Validate_Exception("Falha ao realizar a configuração! Erro: ".$exc->getMessage());
        }
    }

    public function getLocais(){
        $where  = $this->select()
                       ->setIntegrityCheck(FALSE)
                       ->from(["loc"=>"transporte_locais"])
                       ->join(["cid"=>"cidade"],"loc.cid_codigo = cid.cid_codigo",["cid_nome","uf_sigla"]);
        return $this->fetchAll($where);
    }

    public function getLocal($loc_codigo){
        $where  = $this->select()
                       ->setIntegrityCheck(FALSE)
                       ->from(["loc"=>"transporte_locais"])
                       ->join(["cid"=>"cidade"],"loc.cid_codigo = cid.cid_codigo",["cid_nome","uf_sigla"])
                       ->where("loc_codigo = $loc_codigo");
        return $this->fetchRow($where);
    }

    public function excluir($loc_codigo=FALSE){
        $item = $this->fetchRow("loc_codigo = $loc_codigo");
        if ($item)
            $item->delete();
        return true;
    }

    public function pesquisar($term){
        $where  = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(["loc"=>"transporte_locais"])
            ->join(["cid"=>"cidade"],"loc.cid_codigo = cid.cid_codigo",["cid_nome","uf_sigla"])
            ->where("loc_descricao ilike '%$term%' 
                           OR cid.cid_nome ilike '%$term%' 
                           OR loc_logradouro ilike '%$term%'
                           OR loc_bairro ilike '%$term%'");
        return $this->fetchAll($where);
    }


}
