<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_TransporteViagemLocais extends Elotech_Db_Table_Abstract {

	protected $_name = 'transporte_viagem_locais';
	protected $_primary = 'tvl_codigo';


	public function salvar(array $data) {
            try {
               return parent::salvar($data);
            } catch (Exception $exc) {
              return $exc->getMessage();
            }
	}

    public function excluir($tvl_codigo=FALSE) {
        $item = $this->fetchRow("tvl_codigo=$tvl_codigo");
        if ($item) {
            $item->delete();
        }
    }

    public function excluirByViagem($via_codigo){
        $this->delete("via_codigo=$via_codigo");
    }

    public function getLocaisEmbarque($via_codigo){
	    $where = $this->select()
                    ->setIntegrityCheck(FALSE)
                    ->from(["tvl"=>"transporte_viagem_locais"])
                    ->join(["loc"=>"transporte_locais"],"tvl.loc_codigo=loc.loc_codigo")
                    ->where("via_codigo = $via_codigo AND tvl_tipo = 'E'");
	    return $this->fetchAll($where);
    }

    public function getLocaisDesembarque($via_codigo){
        $where = $this->select()
            ->setIntegrityCheck(FALSE)
            ->from(["tvl"=>"transporte_viagem_locais"])
            ->join(["loc"=>"transporte_locais"],"tvl.loc_codigo=loc.loc_codigo")
            ->where("via_codigo = $via_codigo AND tvl_tipo = 'D'");
        return $this->fetchAll($where);
    }

}
