<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_Unidade extends Elotech_Db_Table_Abstract {

	protected $_name = 'unidade';
	protected $_primary = 'uni_codigo';
        protected $_sequence  = 'seq_uni_codigo';
	protected $_dependentTables = array('Agendamento');

	public function salvar(array $data) {
            try {
                return parent::salvar($data);
            } catch (Exception $exc) {
                throw new Zend_Validate_Exception("Falha ao cadastrar a unidade: ".$exc->getMessage());
            }
	}

        public function verificaSeJáExiste($cnes=FALSE){
            $where = $this->select(FALSE)
                          ->setIntegrityCheck(FALSE)
                          ->from(array("uni" => "unidade"),array("qtd"=>"count(*)","uni_codigo"))
                          ->where("uni_cnes = '$cnes'")
                          ->group("uni_codigo");
            return $this->fetchRow($where);

        }

	/**
	 * Buscar as unidade
	 * usado para alimentar o plugin de busca (jquery)
	 * @return json
	 */
	public function buscar($term=FALSE, $acessoLiberadoUnidades, $limit=FALSE) {

		if ($term)
			$limit = ($limit ? $limit : 15);
		  if($acessoLiberadoUnidades['acesso'] == 'S'){
        $where = $this->select(FALSE)
          ->setIntegrityCheck(FALSE)
          ->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc", "uni_tipo"))
          ->where("retira_acentos(uni_desc) ilike retira_acentos('%$term%')", "S")
          ->where("cnes_ativo != 'I'")
          ->order(array("uni_desc"))
          ->limit($limit);
      } else {
        $where = $this->select(FALSE)
          ->setIntegrityCheck(FALSE)
          ->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc", "uni_tipo"))
          ->join(array("unu" => "unidade_usuarios"), "uni.uni_codigo=unu.uni_codigo", array(""))
          ->where("retira_acentos(uni_desc) ilike retira_acentos('%$term%')", "S")
          ->where("cnes_ativo != 'I'")
          ->where("unu.usr_codigo = {$acessoLiberadoUnidades['usr_logado']}")
          ->order(array("uni_desc"))
          ->limit($limit);
      }

		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $uni) {
			$out [] = array(
				"id" => $uni->uni_codigo,
				"label" => $uni->uni_desc,
				"tipo" => $uni->uni_tipo,
				"data" => $uni->toArray()
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("uni_codigo" => "0", "uni_desc" => "")
			);
		}

		return $out;
	}

	public function buscarCidadeDaUnidade($uni_codigo) {
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("uni" => "unidade"))
				->join(array("cid" => "cidade"), "uni.uni_codigo_ibge=cid.cid_codigo_ibge")
				->where("uni_codigo = $uni_codigo")
                                ->where("cnes_ativo != 'I'");
		return $this->fetchAll($where);
	}

	public function selectTag($value=NULL, $first=NULL) {
		$where = $this->select()->where("cnes_ativo != 'I'")->order("uni_desc");
		return parent::selectTag($where, "uni_desc", NULL, $first, TRUE, NULL, NULL, NULL, $value);
	}

	/**
	 * Retorna os laboratórios, unidades ou hospitais que tenham o $term no nome.
	 * @param type $term
	 * @return stdClass
	 * @author Anderson Bernini
	 */
	public function buscarLocais($term) {
		$where = $this->select(FALSE)
				->setIntegrityCheck(FALSE)
				->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc", "prestador_servico" => "('U')", "categoria" => "('Unidade')", "uni_cnes")) // prestador_servico: U
                                ->where("cnes_ativo != 'I'")
				->where("uni_desc ilike '%$term%'")
				->order(array("uni_desc"));

		$all = $this->fetchAll($where);

		$out = array();
		foreach ($all as $med) {
			$out [] = array(
				"id" => $med->uni_codigo,
				"label" => $med->uni_desc,
				"data" => $med->toArray()
			);
		}

		if (!count($out)) {
			$out [] = array(
				"id" => 0,
				"label" => "Nenhum item encontrado",
				"data" => array("categoria" => "Nenhum item encontrado")
			);
		}

		return $out;
	}

        public function getQtdUnidadesAtivasCnes(){
            $where = $this->select(FALSE)
                          ->setIntegrityCheck(FALSE)
                          ->from(array("uni"=>"unidade"),array("COUNT(uni_codigo) AS qtd_uni"))
                          ->where("cnes_ativo != 'I'");
            return $this->fetchRow($where);
        }

        public function getUnidadePorCnes($cnes){
		$where = $this->select(FALSE)
                              ->setIntegrityCheck(FALSE)
                              ->from(array("uni"=>"unidade"),array("uni_codigo","uni_desc"))
                              ->where("cnes_ativo != 'I'")
                              ->where("uni_cnes =?",$cnes);
		return $this->fetchRow($where);
	}

    public function buscaUnidadePorNome($nome_fantasia=FALSE,$nome_fantasia_quebrado=FALSE,$razao_social=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("uni"=>"unidade"),array("uni_codigo","uni_desc"));
        foreach ($nome_fantasia_quebrado as $nome) {
            $nomes_provavel .= $nome." ";
            $sql->orWhere("uni.uni_desc ilike retira_acentos('%".trim($nomes_provavel)."%')");
        }
        return $this->fetchAll($sql);
    }

    public function getUnidade($uni_codigo=FALSE){
       $where = $this->select(FALSE)
                ->setIntegrityCheck(FALSE)
                ->from(array("uni"=>"unidade"),array("uni_codigo","uni_desc","uni_cnpj"))
                                    ->where("cnes_ativo != 'I'");

       if($uni_codigo)
           $where->where("uni_codigo=$uni_codigo");

        return $this->fetchAll($where);
	}

	public function getUnidadePorUsuario($usr_codigo){
	    $where = $this->select()
                      ->distinct(TRUE)
                      ->setIntegrityCheck(FALSE)
                      ->from(array("uni" => "unidade"), array("uni_codigo", "uni_desc", "uni_cnpj", "cnes_ativo"))
                      ->join(array("unu" => "unidade_usuarios"), "unu.uni_codigo = uni.uni_codigo")
                      ->join(array("usr" => "usuarios"), "usr.usr_codigo = unu.usr_codigo", "")
                      ->where("usr.usr_codigo = $usr_codigo");

	    return $this->fetchAll($where);
    }

    public function getCodUnidade(){
        $where = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("uni"=>"unidade"),array("uni_codigo"))
                                         ->where("cnes_ativo != 'I' or cnes_ativo is null");
        return $this->fetchAll($where);
	}
        public function importaEstabelecimentos($data){
            if(empty($data))
                return false;

            try{
                $complexidade = $data[complexidade];
                unset($data[complexidade]);
                $equipes = $data[equipes];
                unset($data[equipes]);
                $uni_valida = $this->verificaSeJáExiste($data[uni_cnes]);

                //die("ako");
                if($uni_valida->qtd > 0){
                    $data["uni_codigo"] = $uni_valida->uni_codigo;
                    $data["cnes_ativo"] = "A";
                }

                $uni_codigo = $this->salvar($data);
                $this->salvaDependenciasUnidade($uni_codigo,$complexidade,$equipes);

            }catch (Exception $exc) {
                throw new Zend_Validate_Exception( "Erro ao importar unidades".$exc->getMessage(), 1000);
            }
            return true;

        }

        private function salvaDependenciasUnidade($uni_codigo=FALSE,$complexidade=FALSE,$equipes=FALSE){
            $tbUnc = new Application_Model_UnidadeComplexidade();
            $tbEqp = new Application_Model_TbEquipe();

            foreach ($complexidade as $comp){
                $data_comp = array("co_complexidade"=>$comp[co_complexidade],
                                   "uni_codigo" => $uni_codigo);

                $unc_valida = $tbUnc->verificaSeJáExiste($comp[co_complexidade], $uni_codigo);
                if($unc_valida->qtd > 0){
                    $data_comp["unc_codigo"] = $unc_valida->unc_codigo;
                    $data_comp["unc_ativo"] = "A";
                }
                $tbUnc->salvar($data_comp);
            }
            foreach ($equipes as $eqp){
                $data_eqp = array("tp_equipe"=>$eqp[tp_equipe],
                                   "no_equipe"=>$eqp[no_equipe],
                                   "nu_ine" => $eqp[nu_ine],
                                   "ds_area" => $eqp[ds_area],
                                   "uni_codigo" => $uni_codigo);

                $co_valida = $tbEqp->verificaSeJáExiste($eqp[nu_ine],$uni_codigo);
                if($co_valida->qtd > 0){
                    $data_eqp["co_seq_equipe"] = $co_valida->co_seq_equipe;
                    $data_eqp["st_ativo"] = "A";
                }
                $tbEqp->inativarEquipesComOMesmoIne($eqp[nu_ine]);
                $tbEqp->salvar($data_eqp);
            }
            return true;
        }

        public function atualizaStatusGeral(){
            $where = $this->select()->getPart(Zend_Db_Table_Select::WHERE);
            $where = $where[0];
            $data = array('cnes_ativo'=> "I");
            return $this->update($data, $where);
        }

        public function unidadeSemCnes(){
            $sql = $this->select(FALSE)
                       ->setIntegrityCheck(FALSE)
                       ->from(array("uni"=>"unidade"))
                       ->where("uni_cnes is null")
                       ->where("cnes_ativo != 'I' or cnes_ativo is null");
            return $this->fetchAll($sql);
        }

        public function getUnidades(){
            $where = $this->select(FALSE)
                          ->setIntegrityCheck(FALSE)
                          ->from(array("uni" => "unidade"))
                          ->where("cnes_ativo = 'A'")
                          ->order("uni_desc");
            return $this->fetchAll($where);
        }

        public function getTodasUnidadesOrdenadoPorCnesAtivo(){

            $where = $this->select(FALSE)
                          ->setIntegrityCheck(FALSE)
                          ->from(array("uni" => "unidade"))
                          ->where("uni.uni_as IS FALSE OR uni.uni_as IS NULL")
                          ->order("cnes_ativo")
                          ->order("uni_desc");

            return $this->fetchAll($where);

        }

}
