<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_UsuarioAnexos extends Elotech_Db_Table_Abstract {

    protected $_name = 'usuario_anexos';
    protected $_primary = 'ua_codigo';

    public function salvar(array $data) {
        return parent::salvar($data);
    }

    public function getAnexosByUsuario($usu_codigo){
        $where = $this->select()
                    ->setIntegrityCheck(FALSE)
                    ->from(array("ua"=>"usuario_anexos"))
                    ->join(array("td"=>"tipo_documento"),"ua.td_codigo = td.td_codigo")
                    ->join(array("usu"=>"usuario"),"ua.usu_codigo = usu.usu_codigo", ["usu_codigo", "usu_nome"])
                    ->where("ua.usu_codigo = $usu_codigo");
        return $this->fetchAll($where);
    }

    public function excluir($ua_codigo){
            return parent::delete("ua_codigo = $ua_codigo");
    }

    public function getCaminho($ua_codigo){
        $where = $this->select()
            ->from(array("ua"=>"usuario_anexos"),"ua_caminho")
            ->where("ua.ua_codigo = $ua_codigo");
        return $this->fetchRow($where);
    }

}
