<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_UsuarioCriancas extends Elotech_Db_Table_Abstract {

    protected $_name = 'usuario_crianca_responsavel';
    protected $_primary = 'co_seq_usuario_crianca_responsavel';
    protected $_sequence = 'usuario_crianca_responsavel_co_seq_usuario_crianca_responsa_seq';
    
    public function salvar($dados) {
        try{
            return parent::salvar($dados);
        } catch (Exception $ex) {
            die($ex->getMessage());
            throw new Zend_Validate_Exception("Falha ao salvar Usuário: ".$ex->getMessage());
        }
    }
    
    public function excluirPorUsuario($usuCod){
        $item = $this->fetchAll("usu_codigo=$usuCod");
        if($item){
            foreach($item as $value) {
                $value->delete();
            }
        }
    }
    
    public function getDadosPorUsuario($usuCod=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("usuc"=>"usuario_crianca_responsavel"),array("co_pergunta_detalhe"))
                    ->where("usu_codigo =?",$usuCod);
        return $this->fetchAll($sql);
    }
}
