<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_UsuarioDoencaPulmonar extends Elotech_Db_Table_Abstract {

    protected $_name = 'usuario_doenca_pulmonar';
    protected $_primary = 'co_seq_usuario_doenca_pulmonar';
    protected $_sequence = 'usuario_doenca_pulmonar_co_seq_usuario_doenca_pulmonar_seq';
    
    public function salvar($dados) {
        try{
            return parent::salvar($dados);
        } catch (Exception $ex) {
            die($ex->getMessage());
            throw new Zend_Validate_Exception("Falha ao salvar Usuário: ".$ex->getMessage());
        }
    }
    
    public function excluirPorUsuario($usuCod){
        $item = $this->fetchAll("usu_codigo=$usuCod");
        if($item){
            foreach($item as $value) {
                $value->delete();
            }
        }
    }
    
    public function getDadosPorUsuario($usuCod=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("udp"=>"usuario_doenca_pulmonar"),array("co_pergunta_detalhe"))
                    ->where("usu_codigo =?",$usuCod);
        return $this->fetchAll($sql);
    }
}
