<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");

class Application_Model_UsuarioInfoSociodemo extends Elotech_Db_Table_Abstract {

    protected $_name = 'usuario_info_sociodemo';
    protected $_primary = 'co_seq_usuario_info_sociodemo';
    
    public function salvar($dados) {
        try{
            return parent::salvar($dados);
        } catch (Exception $ex) {
            die($ex->getMessage());
            throw new Zend_Validate_Exception("Falha ao salvar Usuário: ".$ex->getMessage());
        }
    }
    
    public function excluirPorUsuario($usuCod){
        $item = $this->fetchAll("usu_codigo=$usuCod");
        if($item){
            foreach($item as $value) {
                $value->delete();
            }
        }
    }
    
    public function getDadosPorUsuario($usuCod=FALSE){
        $sql = $this->select(FALSE)
                    ->setIntegrityCheck(FALSE)
                    ->from(array("uis"=>"usuario_info_sociodemo"))
                    ->where("usu_codigo =?",$usuCod);
        return $this->fetchAll($sql);
    }

    public function getInfo($usuCod=FALSE){
        $sql = $this->select(FALSE)
            ->setIntegrityCheck(FALSE)
            ->from(array("uis"=>"usuario_info_sociodemo"),array("co_seq_usuario_info_sociodemo"))
            ->where("usu_codigo =?",$usuCod);
        //die($sql);
        return $this->fetchAll($sql);
    }

}
