<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_UsuariosEquipe extends Elotech_Db_Table_Abstract {

    protected $_name = 'usuarios_equipe';
    protected $_primary = "ueq_codigo";
    

    public function salvar($dados) {
       //echo "<pre>".print_r($dados,1);
        try{
            return parent::salvar($dados);
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao salvar Usuario equipe: ".$ex->getMessage());
        }
        return true;
    }
    
     public function excluirTodosCnes(){
         //die("?");
        try{
            $sql = $this
                ->getDefaultAdapter()
                ->query("DELETE FROM usuarios_equipe WHERE usr_codigo IN (
                                            SELECT DISTINCT
                                                usr_codigo
                                            FROM
                                                usuarios
                                            WHERE
                                                 usr_mestre is null or usr_mestre = 'N')")
                ->fetchAll();
            return $sql;
        } catch (Exception $ex) {
            throw new Zend_Validate_Exception("Falha ao excluir item: ".$ex->getMessage());
        }
    }

    public function getEquipePorUnidadeUsuario($usr_codigo, $uni_codigo){
        $where = $this->select()
                        ->setIntegrityCheck(FALSE)
                        ->from(["ueq"=>"usuarios_equipe"])
                        ->join(["eq"=>"tb_equipe"],"ueq.co_equipe = eq.co_seq_equipe","co_seq_equipe")
                        ->where("ueq.usr_codigo = $usr_codigo")
                        ->where("eq.uni_codigo = $uni_codigo AND eq.st_ativo = 'A'");
        return $this->fetchRow($where);

    }
    
}
