<?php

Zend_Loader::loadClass("Elotech_Db_Table_Abstract");
class Application_Model_Viagem extends Elotech_Db_Table_Abstract {

    protected $_name = 'viagem';
    protected $_primary = 'via_codigo';
    protected $_sequence = 'viagem_via_codigo_seq';

    /**
     * Persiste um item (insert ou update)
     * @param array $data array de chave=>valor, cada chave corresponde a um atributo
     * @return int primary key do item (nextVal para insert)
     */
    public function salvar(array $data) {
        $this->valoresPadrao($data);
        $this->notEmpty(array("via_data"), $data);
        $this->emptyToUnset($data);
      // echo "<pre>".  print_r($data,1);die();
        return parent::salvar($data);
    }

    /**
    * Valores padrão do insert/update
    * @param array $data valores do insert
    */
    private function valoresPadrao(&$data) {
       $tbUsr = new Application_Model_Usuarios();
       $data['usr_codigo_cadastro'] = $tbUsr->getUsrAtual()->usr_codigo;

   }
    public function getViagens($limit = FALSE){
      $where = $this->select(FALSE)
              ->setIntegrityCheck(FALSE)
              ->from(array("via"=>"viagem"),array("via_data","via_codigo","via_local","via_hora", "via_motivo"))
              ->join(array("usr"=>"usuarios"),"usr.usr_codigo=via.usr_codigo" ,"usr_nome")
              ->joinLeft(array("cid1"=>"cidade"),"via.cid_codigo_origem = cid1.cid_codigo", ["cid_nome_origem"=>"cid_nome"])
              ->joinLeft(array("cid2"=>"cidade"),"via.cid_codigo_destino = cid2.cid_codigo", ["cid_nome_destino"=>"cid_nome"])
              ->join(array("vei"=>"veiculo"), "vei.vei_codigo=via.vei_codigo","vei_descricao");
      if ($limit) {
        $where->limit($limit);
      }
      $where->order("via.via_data DESC");
        //  die($where);
      return $this->fetchAll($where);


   }

    public function getViagem($via_codigo = FALSE){
      $where = $this->select(FALSE)
              ->setIntegrityCheck(FALSE)
              ->from(array("via"=>"viagem"),array("via_data","via_codigo","via_local","via_hora","via_motivo", "cid_codigo_origem", "cid_codigo_destino","via_km"))
              ->join(array("usr"=>"usuarios"),"usr.usr_codigo=via.usr_codigo" ,array("usr_nome","usr_codigo"))
              ->joinLeft(array("cid1"=>"cidade"),"via.cid_codigo_origem = cid1.cid_codigo", ["cid_nome_origem"=>"cid_nome"])
              ->joinLeft(array("cid2"=>"cidade"),"via.cid_codigo_destino = cid2.cid_codigo", ["cid_nome_destino"=>"cid_nome"])
              ->join(array("vei"=>"veiculo"), "vei.vei_codigo=via.vei_codigo",array("vei_descricao","vei_codigo","vei_tipo_veiculo", "vei_capacidade"));
      if($via_codigo){
          $where->where("via_codigo=?",$via_codigo);
      }

      return $this->fetchRow($where);


   }
    /**
     * Exclui uma Viagem
     * @param int $vei_codigo Código da Viagem
     * @return Zend_Db_Table_Row_Abstract
     */
    public function excluir($via_codigo=FALSE) {
            $item = $this->fetchRow("via_codigo=$via_codigo");
            if ($item) {
                    $item->delete();
            }
    }
    /**
     * Busca Veiculo
     * @param int $dados Dados poder ser o nome do setor ou a descricai da Veiculo
     * @return Zend_Db_Table_Row_Abstract
     */
    public function pesquisar($dados=FALSE, $limit=FALSE) {
            $where = $this->select(FALSE)
                            ->setIntegrityCheck(FALSE)
                            ->from(array("vei"=>"veiculo"),array("vei_codigo","vei_descricao","vei_placa","vei_capacidade"))
                            ->join(array("via"=>"viagem"),"vei.vei_codigo = via.vei_codigo",array("via_codigo","via_data","via_local","via_hora", "via_motivo"))
                            ->joinLeft(array("cid1"=>"cidade"),"via.cid_codigo_origem = cid1.cid_codigo", ["cid_nome_origem"=>"cid_nome"])
                            ->joinLeft(array("cid2"=>"cidade"),"via.cid_codigo_destino = cid2.cid_codigo", ["cid_nome_destino"=>"cid_nome"])
                            ->join(array("usr"=>"usuarios"), "via.usr_codigo=usr.usr_codigo","usr_nome");
            if (is_string($dados)){
                    $where->where("vei_descricao ilike '%$dados%' or vei_placa ilike '%$dados%' or usr_nome ilike '%$dados%' or CAST(via_data AS VARCHAR) ilike '%" . date('Y-m-d', strtotime(str_replace('/', '-', $dados))) . "%'");
            }

            if ($limit) {
                    $where->limit(15);
            }

            return $this->fetchAll($where);
    }
   /**
     * Busca quantidade de viagem por periodo e carro
     * @param int $dados Dados poder ser o nome do setor ou a descricai da Veiculo
     * @return Zend_Db_Table_Row_Abstract
     */
    public function getViagemPorVeiculo($vei_codigo = FALSE,$data_ini = FALSE, $data_fim = FALSE) {
            $where = $this->select(FALSE)
                            ->setIntegrityCheck(FALSE)
                            ->from(array("via"=>"viagem"),array("count(via.via_codigo) as total"))
                            ->join(array("vei"=>"veiculo"),"vei.vei_codigo = via.vei_codigo" ,"vei_descricao")
                            ->group("vei_descricao")
                            ->order("vei_descricao");
            if ($vei_codigo)
                    $where->where("vei.vei_codigo=?",$vei_codigo);
            if ($data_ini) {
                   $where->where("via_data>=?",$data_ini);
            }
            if ($data_fim) {
                   $where->where("via_data<=?",$data_fim);
            }

            return $this->fetchAll($where);
    }
    /**
     * Busca quantidade de viagem por periodo e motorista
     * @param int $usr_codig motorista
     * @param date $data_ini data inicial
     * @param date $data_fim data final
     * @return Zend_Db_Table_Row_Abstract
     */
    public function getViagemPorMotorista($usr_codigo = FALSE,$data_ini = FALSE, $data_fim = FALSE) {
          $where = $this->select(FALSE)
                            ->distinct()
                            ->setIntegrityCheck(FALSE)
                            ->from(array("via"=>"viagem"),array("count(via.via_codigo) as total"))
                            ->join(array("usr"=>"usuarios"),"usr.usr_codigo=via.usr_codigo",array("usr.usr_codigo","usr.usr_nome"))
                            ->group(array("usr.usr_codigo","usr_nome"))
                            ->order("usr_nome");
            if ($usr_codigo)
                    $where->where("via.usr_codigo=?",$usr_codigo);
            if ($data_ini) {
                   $where->where("via_data>=?",$data_ini);
            }
            if ($data_fim) {
                   $where->where("via_data<=?",$data_fim);
            }


            return $this->fetchAll($where);
    }

	public function getViagemPorEncaminhamento($data_inicial = FALSE, $data_final = FALSE, $vei_codigo = FALSE, $usu_codigo = FALSE){
		// Montagem da consulta sql
		$sql = $this->select(FALSE)
					->setIntegrityCheck(FALSE)
					->from(array("via"=>"viagem"), array("via.via_data","via.via_hora","via.via_motivo","via.via_local"))
					->join(array("vei"=>"veiculo"),"via.vei_codigo = vei.vei_codigo",array("vei.vei_descricao"))
					->join(array("usua"=>"usuarios"),"via.usr_codigo = usua.usr_codigo",array("usua.usr_nome"))
					->join(array("viau"=>"viagem_usuario"),"via.via_codigo = viau.via_codigo",array("viau.viausu_codigo"))
					->join(array("usu"=>"usuario"),"viau.usu_codigo = usu.usu_codigo",array("usu.usu_nome","usu.usu_rg"))
					->join(array("cid"=>"cidade"),"viau.cid_codigo_origem = cid.cid_codigo",array("cid.cid_nome as cid_origem"))
					->join(array("cida"=>"cidade"),"viau.cid_codigo_destino = cida.cid_codigo",array("cida.cid_nome as cida_destino"));
		// Validações
		if($vei_codigo){
			$sql->where("vei.vei_codigo=?",$vei_codigo);
		}

		if($data_inicial){
			$sql->where("via.via_data>=?",$data_inicial);
		}

		if($data_final){
			$sql->where("via.via_data<=?",$data_final);
		}

		if($usu_codigo){
		    $sql->where("usu.usu_codigo=?",$usu_codigo);
        }

		// Listando por ordem de data
		$sql->order("via.via_data");


		// Retornando os dados da consulta
		return $this->fetchAll($sql);
	}

	public function getAcompanhantesViagem($viausu_codigo){
		$sql = $this->select(FALSE)
					->setIntegrityCheck(FALSE)
					->from(array("usu"=>"usuario"),array("usu.usu_nome","usu.usu_rg"))
					->join(array("usua"=>"usuario_acompanhante"),"usu.usu_codigo = usua.usu_codigo","")
					->where("usua.viausu_codigo=?",$viausu_codigo);
		return $this->fetchAll($sql);
	}

}
