<?php

abstract class Util {
    //CONSTANTES DE RECEPÇÃO
    const RECEPCIONADO = 'R';
    const RECEPCIONADO_PRE = 'RP'; //RECEPCIONADO COM PRÉ CONSULTA
    //CONSTANTES DE PRÉ-CONSULTA
    const PRE_CONSULTA = 'P';
    const PRE_CONSULTA_FINAL = 'PF';
    //CONSTANTES DE ATENDIMENTO
    const ATEND_INICIADO = 'E';
    const ATEND_INICIADO_MED = 'EM';
    const EM_ATENDIMENTO = 'A';
    const ATENDIM_FINAL = 'AF'; //ATENDIMENTO FINALIZADO
    //CONSTANTES DE RETORNO
    const AGUARD_RETORNO = 'AR'; //AGUARDANDO RETORNO
    const RETORNO_ATENDIM = 'RA'; //RETORNO DE ATENDIMENTO
    //CONSTANTE AGENTIC
    const URL_AGENTIC = 'http://localhost/WebSocialSaude/rest/saude/agentic';

    public static function alteraStatusAgendamento($age_codigo, $status) {
        try {
            $data = array(
                "age_codigo" => $age_codigo,
                "age_status" => $status,
                "usr_cod_status" => $_SESSION['id_login'],
                "datahora_status" => date('Y-m-d H:i:s')
            );

            if ($status === self::RECEPCIONADO || $status === self::RECEPCIONADO_PRE) {
                $data['usr_cod_status'] = null;
                $data['age_atendido'] = 'S';
            }

            if ($status === self::PRE_CONSULTA_FINAL) {
                $data['usr_cod_status'] = null;
            }

            $tbAge = new Application_Model_Agendamento();
            $tbAge->salvarAgendamento($data);
        } catch (Exception $ex) {
            die($ex->getMessage());
        }
    }

    public static function chamada($data) {
        try {
            $tbChamada = new Application_Model_Chamada();
            $chamada = $tbChamada->getChamadaPorAgendamento($data['age_codigo']);

            if($chamada){
                $data['cha_codigo'] = $chamada;
            }

            $tbChamada->salvar($data);
        } catch (Exception $e) {
            die($e->getMessage());
        }
    }

    public static function sendRequestAgentic($data, $tipo, $endpoint) {
        $url = 'http://mandaguari.saude.elotech.com.br/WebSocialSaude/rest/saude/agentic';
        $params = self::createParams($data, $tipo);
        if (!empty($params)) {
            $ch = curl_init($url.$endpoint);
            curl_setopt($ch, CURLOPT_HTTPHEADER, [
                'Content-Type: application/json',
                'Authorization: Bearer '.$params['access_token'],
            ]);
            curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            curl_setopt($ch, CURLINFO_HEADER_OUT, TRUE);
            $response = json_decode(curl_exec($ch));
            curl_close($ch);
            return !empty($response->response->dados[0]->codigo) ? $response->response->dados[0]->codigo : NULL;
        }

        return NULL;
    }

    public static function createParams($data, $tipo) {
        // 'codigoEmpresa' => 9, CODIGO DA ELOTECH
        if ($tipo == 'paciente') {
            return json_encode([
                'access_token' => $data['access_token'],
                'codigoPrestador' => $data['usu_codigo'],
                'codigoEmpresa' => '9',
                'ativo' => true,
                'usaFacebook' => true,
                'usaWhatsapp' => true,
                'usaTelegram' => true,
                'usaSms' => true,
                'atualizar' => false,
                'dataCadastro' => date('Y-m-d', strtotime(str_replace('/', '-', $data['usu_data_cad']))) . 'T00:00:00',
                'dataAlteracao' => date('Y-m-d', strtotime(str_replace('/', '-', $data['usu_data_cad']))) . 'T00:00:00',
                'dataNascimento' => date('Y-m-d', strtotime(str_replace('/', '-', $data['usu_datanasc']))) . 'T00:00:00',
                'nome' => strtoupper($data['usu_nome']),
                'celular' => str_replace(' ', '', $data['usu_celular']),
                'email' => $data['usu_email'],
                'estado' => $data['uf_sigla'],
                'cidade' => $data['cid_nome'],
                'planoSaude' => $data['usu_desc_plano_saude']
            ]);
        } elseif ($tipo == 'medico') {
            return json_encode([
                'access_token' => $data['access_token'],
                'codigoPrestador' => $data['usr_codigo'],
                'codigoEmpresa' => 9,
                'nome' => strtoupper($data['usr_nome']),
                'celular' => $data['usr_celular'],
                'email' => $data['usr_email'],
                'especialidade' => trim($data['esp_nome']),
                'conselhoProfissional' => $data['con_descricao'],
                'numeroConselho' => $data['usr_num_conselho'],
                'dataCadastro' => date('Y-m-d') . 'T00:00:00',
                'dataAlteracao' => date('Y-m-d') . 'T00:00:00',
                'ativo' => true,
                'estado' => $data['uf_sigla'],
                'cidade' => $data['cid_nome'],
            ]);
        } elseif ($tipo == 'medicoExterno') {
            return json_encode([
                'access_token' => $data['access_token'],
                'nome' => strtoupper($data['med_nome']),
                'dataCadastro' => date('Y-m-d') . 'T00:00:00',
                'dataAlteracao' => date('Y-m-d') . 'T00:00:00',
                'ativo' => true,
                'codigoPrestador' => $data['med_codigo'].'000',
                'codigoEmpresa' => 9,
                'especialidade' => 'Profissional Externo',
                'conselhoProfissional' => 'CRM',
                'numeroConselho' => '0',
                'estado' => 'PR',
                'cidade' => !empty($data['med_end_cidade']) ? $data['med_end_cidade'] : 'Mandaguari',
            ]);
        } elseif ($tipo == 'agendamento') {
            return json_encode([
                'access_token' => $data['access_token'],
                'dataAlteracao' => date('Y-m-d') . 'T00:00:00',
                'dataCadastro' => date('Y-m-d') . 'T00:00:00',
                'dataAgendamento' => date('Y-m-d', strtotime(str_replace('/', '-', $data['age_data']))) . 'T00:00:00',
                'celular' => str_replace(' ', '', $data['paciente']['usu_celular']),
                'hora' => $data['age_horario'],
                'tipo' => 'PENDENTE',
                'status' => 'ENVIADO',
                'realizada' => 'false',
                'codigoEmpresa' => 9,
                'codigoPaciente' => $data['paciente']['usu_codigo'],
                'codigoMedico' => $data['med_codigo'],
                'codigoPrestador' => $data['age_codigo'],
            ]);
        } elseif ($tipo == 'agendamentoExterno') {
            return json_encode([
                'access_token' => $data['access_token'],
                'dataAlteracao' => date('Y-m-d') . 'T00:00:00',
                'dataCadastro' => date('Y-m-d') . 'T00:00:00',
                'dataAgendamento' => date('Y-m-d', strtotime(str_replace('/', '-', $data['age_data']))) . 'T00:00:00',
                'celular' => str_replace(' ', '', $data['paciente']['usu_celular']),
                'hora' => $data['age_horario'],
                'tipo' => 'PENDENTE',
                'status' => 'ENVIADO',
                'realizada' => 'false',
                'codigoEmpresa' => 9,
                'codigoPaciente' => $data['paciente']['usu_codigo'],
        'codigoMedico' => $data['med_codigo'].'000',
                'codigoPrestador' => $data['agee_codigo'],
            ]);
        } elseif ($tipo == 'agendamentoConveniado') {
            return json_encode([
                'access_token' => $data['access_token'],
                'dataAlteracao' => date('Y-m-d') . 'T00:00:00',
                'dataCadastro' => date('Y-m-d') . 'T00:00:00',
                'dataAgendamento' => date('Y-m-d', strtotime(str_replace('/', '-', $data['age_data']))) . 'T00:00:00',
                'celular' => str_replace(' ', '', $data['paciente']['usu_celular']),
                'hora' => '08:00',
                'tipo' => 'PENDENTE',
                'status' => 'ENVIADO',
                'realizada' => 'false',
                'codigoEmpresa' => 9,
                'codigoPaciente' => $data['paciente']['usu_codigo'],
        'codigoMedico' => $data['med_codigo'].'000',
                'codigoPrestador' => $data['agei_codigo'],
            ]);
        }

        return NULL;
    }
    public static function gerarToken(){
        $url = 'http://mandaguari.saude.elotech.com.br/WebSocialSaude/rest/saude/agentic';
        $params = json_encode(
            [
                'username'=>'elotech@elotech.com.br',
                'password'=> 'agentic',
                'grant_type'=>'password'
            ]
        );
        $ch = curl_init($url . '/token/gerar');
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($params),
        ]);
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, TRUE);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
        curl_setopt($ch, CURLINFO_HEADER_OUT, TRUE);
        $response = json_decode(curl_exec($ch));
        curl_close($ch);

        return $response;
    }

}
