<?php

require_once __DIR__ . '/../../Util.php';

class Agenda_AgendaController extends Zend_Controller_Action
{

  public function init()
  {
    $this->view->title = "Fazer Agendamento";
  }

  public function indexAction()
  {
    // action body
  }

  public function novoAction()
  {
    $fiusu_codigo = $this->_request->getParam("fiusu_codigo", FALSE);
    if ($fiusu_codigo) {
      $this->view->fiusu_codigo = $fiusu_codigo;
    }
  }

  public function selecionarDataAction()
  {
    $this->_helper->layout->disableLayout();

    $coni_codigos = $this->_getParam("procs", FALSE);
    $this->view->data_inicial = $this->_getParam("de", date("Y-m-d"));

    if (!$coni_codigos)
      return $this->_helper->viewRenderer->setNoRender(true);

    $coni_codigos = explode(",", $coni_codigos);

    $tbAge = new Application_Model_Agenda();
    $tbConI = new Application_Model_ConvenioItens();
    $this->view->data_final = $tbAge->calculaDataFinal($this->view->data_inicial);

    $this->view->vagas = $tbAge->getVagas($coni_codigos, $this->view->data_inicial, $this->view->data_final);

    $this->view->nomeProcs = $tbConI->getNomeProcedimentos($coni_codigos);
  }

  public function selecionarDataNovoAction()
  {
    $this->_helper->layout->disableLayout();

    $coni_codigos = $this->_getParam("procs", FALSE);
    $this->view->data_inicial = $this->_getParam("de", date("Y-m-d"));

    if (!$coni_codigos)
      return $this->_helper->viewRenderer->setNoRender(true);

    $coni_codigos = explode(",", $coni_codigos);

    $tbAge = new Application_Model_Agenda();
    $tbConI = new Application_Model_ConvenioItens();
    $this->view->data_final = $tbAge->calculaDataFinal($this->view->data_inicial);


    $this->view->vagas = $tbAge->getVagasNovo($coni_codigos, $this->view->data_inicial, $this->view->data_final);

    $this->view->nomeProcs = $tbConI->getNomeProcedimentos($coni_codigos);
    $this->view->valorProcs = $tbConI->getValorProcedimentos($coni_codigos);
  }

  /**
  * Salvar
  * Acessar por post/ajax
  * @return json
  */
  public function salvarAction()
  {
    if ($this->_request->isPost()) {
      $dados = array(
        "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
        "usr_codigo_medico" => $this->_request->getPost("usr_codigo_medico", FALSE),
        "ate_codigo" => $this->_request->getPost("ate_codigo", FALSE),
        "interno" => $this->_request->getPost("interno", FALSE),
        "itens" => $this->_request->getPost("coni", array())
      );

      try {
        $tbAge = new Application_Model_Agenda();
        $age_codigo = $tbAge->salvar($dados);
        $this->view->dados = array("success" => TRUE, "age_codigo" => $age_codigo);
      } catch (Zend_Validate_Exception $exc) { // Exceção de validação
        $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => $exc->getMessage(), "code" => $exc->getCode());
      } catch (Zend_Exception $exc) { // Exceção de login
        $this->view->dados = array("success" => FALSE, "titulo" => "Faça login", "mensagem" => $exc->getMessage(), "code" => $exc->getCode());
      }

      return $this->render("dados", NULL, TRUE);
    } else {
      $this->_redirect("/agenda/agenda");
    }
  }

  public function salvarnovoAction()
  {
    if ($this->_request->isPost()) {
      $dados = array(
        "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
        "usr_codigo_medico" => $this->_request->getPost("usr_codigo_medico", FALSE),
        "ate_codigo" => $this->_request->getPost("ate_codigo", FALSE),
        "interno" => $this->_request->getPost("interno", FALSE),
        "uni_codigo" => $this->_request->getPost("uni_codigo", FALSE),
        "itens" => $this->_request->getPost("coni", array()),
        "fiusu_codigo" => $this->_request->getPost("fiusu_codigo", FALSE)
      );

      try {
        if ($dados['fiusu_codigo'] != "") {
          $tbFilausu = new Application_Model_FilasUsuario();
          $aux = $tbFilausu->getdados($dados['fiusu_codigo']);
          $tbFilaProc = new Application_Model_FilasUsuarioProcedimento();
          $procedimentos = $tbFilaProc->listar($dados['fiusu_codigo']);
          if (($dados['usr_codigo_medico'] != $aux->usr_codigo) && ($dados['usr_codigo_medico'] != $aux->med_codigo)) {
            $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => "Profissional Solicitante diferente do cadastrado na Fila de Espera!");
            return $this->render("dados", NULL, TRUE);
          }
          if ($dados['usu_codigo'] != $aux->usu_codigo) {
            $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => "Usuário diferente do cadastrado na Fila de Espera!");
            return $this->render("dados", NULL, TRUE);
          }
          if ($dados['uni_codigo'] != $aux->uni_codigo) {
            $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => "Unidade Solicitante diferente do cadastrado na Fila de Espera!");
            return $this->render("dados", NULL, TRUE);
          }
          $proc = false;

          foreach ($dados['itens'] as $key => $item) {
            $conv = new Application_Model_ConvenioItens();
            foreach ($procedimentos as $procedimento){
              if ($conv->busca($key)->proc_codigo == $procedimento->proc_codigo) {
                $proc = true;
              }
            }
          }

          if (!$proc){
            $this->view->dados = array(
              "success" => FALSE,
              "titulo" => "Erro", "mensagem" => "Procedimento(s) diferente(s) do(s) cadastrado(s) na Fila de Espera!"
            );
            return $this->render("dados", NULL, TRUE);
          }
          $age_codigo = (new Application_Model_Agenda())->salvar($dados);

          $status = "SA";
          $tbFila = new Application_Model_Filas();
          $tbFilausu->setStatus($dados['fiusu_codigo'], $status);
          $aux = $tbFilausu->getdados($dados['fiusu_codigo']);
          $tbFila->ordenaFilaAction($aux->fila_codigo);
          $this->view->dados = array("success" => TRUE, "age_codigo" => $age_codigo, "fila_codigo" => $aux->fila_codigo);
        }
        else {
          $age_codigo = (new Application_Model_Agenda())->salvar($dados);

          $this->view->dados = array("success" => TRUE, "age_codigo" => $age_codigo);
        }

        if ((new Application_Model_Configuracao())->getConfig('ENVIO_MENSAGENS_AUTOMATICAS')) {
          $itens = (new Application_Model_AgendaItens())->getItensPorAgenda($age_codigo);
          $arrayAgentic = [];
          foreach ($itens as $key => $item) {
            $arrayAgentic = [
              'access_token' => $_SESSION['access_token'],
              'age_data' => $item->agei_data,
              'med_codigo' => $item->med_codigo,
              'agei_codigo' => $item->agei_codigo,
              'paciente' => (new Application_Model_Usuario())->getUsuarioPorId($dados['usu_codigo'])->toArray(),
            ];

            $agei_codigo = Util::sendRequestAgentic($arrayAgentic, 'agendamentoConveniado', '/agendamento/cadastrar');
          }
        }
      } catch (Zend_Validate_Exception $exc) { // Exceção de validação
        $this->view->dados = array("success" => FALSE, "titulo" => "Erro", "mensagem" => $exc->getMessage(), "code" => $exc->getCode());
      } catch (Zend_Exception $exc) { // Exceção de login
        $this->view->dados = array("success" => FALSE, "titulo" => "Faça login", "mensagem" => $exc->getMessage(), "code" => $exc->getCode());
      }

      return $this->render("dados", NULL, TRUE);
    } else {
      $this->_redirect("/agenda/agenda/novo");
    }
  }

  public function imprimirAction()
  {
    $age_codigo = $this->_getParam("age", FALSE);
    $coletados = $this->_getParam("coletados", FALSE);
    $this->_helper->layout->setLayout("modelo-print");

    $tbAge = new Application_Model_Agenda();
    $tbUsr = new Application_Model_Usuarios();
    $tbUsuario = new Application_Model_Usuario();
    $tbConv = new Application_Model_Convenio();

    $age = $tbAge->getAgendamento($age_codigo, $coletados);
    $dadosUsuario = $tbUsuario->getUsuarioPorId($age->current()->usu_codigo);

    $this->view->cnsUsuario = $dadosUsuario["usu_cartao_sus"];
    $this->view->dataNascUsuario = $dadosUsuario["usu_datanasc"];
    $this->view->telefoneUsuario = $dadosUsuario["usu_telefone"];
    $this->view->emissor = $tbUsr->getUsrAtual()->usr_nome;
    $this->view->codigo = $tbAge->geraCodigoBarras($age_codigo);
    $this->view->usu_codigo = $age->current()->usu_codigo;
    $this->view->usu_nome = $age->current()->usu_nome;
    $this->view->unidade = $age->current()->uni_desc;
    $this->view->age = $age;
    $this->view->medico = ($age->current()->usr_nome ? $age->current()->usr_nome : $age->current()->medico_e);
    $this->view->orientacoes = $tbAge->getOrientacoes($age_codigo);
    $this->view->observacao = $tbConv->getConvenioPorAgendamento($age_codigo)->observacao;
    $this->view->coletados = $coletados;
    $this->view->coni_valor = 102.03;
  }

  /**
  * Histórico de agendamento de exames por paciente
  */
  public function historicoAction()
  {
    $this->_helper->layout->disableLayout();

    $usu_codigo = $this->_getParam("usu", FALSE);
    if (!$usu_codigo)
      return $this->_redirect("/agenda/agenda");

    $tbAge = new Application_Model_Agenda();
    $this->view->itens = $tbAge->getHistoricoDeExamesTela($usu_codigo);
  }

  public function excluirAction()
  {
    $this->_helper->layout->disableLayout();
    $this->_helper->viewRenderer->setNoRender(true);

    $agei_codigo = $this->_request->getPost("agei_codigo", FALSE);
    if (!$agei_codigo)
      return $this->_redirect("/agenda/agenda");

    $tbAgei = new Application_Model_AgendaItens();
    $fiusu_codigo = $tbAgei->getAgendamentoFila($agei_codigo)->fiusu_codigo;
    $tbAgei->excluir($agei_codigo);
    $tbFilausu = new Application_Model_FilasUsuario();

    if($fiusu_codigo){
      $status = "ES";
      $tbFila = new Application_Model_Filas();
      $tbFilausu->setStatus($fiusu_codigo,$status);
      $aux = $tbFilausu->getdados($fiusu_codigo);
      $tbFila->ordenaFilaAction($aux->fila_codigo);
    }
  }

}
