<?php

class Agenda_ConvenioItensController extends Zend_Controller_Action {

	public function init() {
		$this->view->title = "Itens do Convênios";
	}

	/* -----------------------------------------------------------------
	 * METODOS CONVENIOS ITENS AGENDAMENTO ESTABELECIMENTOS DE SAUDE
	 * ----------------------------------------------------------------*/
	public function agendamentoEstabelecimentosDeSaudeProfissionaisAction() {
		$conv_codigo = $this->carregaDadosEstabelecimentosDeSaude();
		$tbConv = new Application_Model_Convenio();
		$tbConI = new Application_Model_ConvenioItens();
		$this->view->fds = $tbConv->atendeSabadoEDomingo($conv_codigo);
		// Tratamento de Avisos
		if ($this->_getParam("aviso") != "") {
			$this->view->erro = $this->retornaAvisosAction($this->_getParam("aviso"));
		}
	}

	public function agendamentoEstabelecimentosDeSaudeProfissionaisItensAction() {
		$conv_codigo = $this->_getParam("conv", FALSE);
		if (!$conv_codigo)
			return $this->_redirect("/agenda/convenio");
		$tbConI = new Application_Model_ConvenioItens();
		$tbConv = new Application_Model_Convenio();
		$this->view->prestador = $tbConv->getDadosAgendamentoEstabelecimentoDeSaude($conv_codigo)->prestador_servico;
		$this->view->itens = $tbConI->buscarPeloConvenio($conv_codigo);
	}

	public function editarAgendamentoEstabelecimentosDeSaudeProfissionaisAction() {
		$conv_codigo = $this->carregaDadosEstabelecimentosDeSaude();
		$coni_codigo = $this->_getParam("id", 0);
		//die($coni_codigo);
		if (!$coni_codigo)
			return $this->_redirect("/agenda/convenio-itens");
		$tbConi = new Application_Model_ConvenioItens();
		$tbDias = new Application_Model_ConvenioDiasSemana();
		$tbDiasAge = new Application_Model_ConvenioDiasSemanaAgendamento();
		$tbHora = new Application_Model_ConvenioHorarios();

		$this->view->itens = $tbConi->buscarPeloConvenio($conv_codigo);

		$this->view->dados = $tbConi->buscaEstabelecimentoDeSaude($coni_codigo);

		$this->view->dadosDia = $tbDiasAge->listaDadosPordia($coni_codigo);

		// Refazer
		//$this->view->atende = $tbDias->getDiasDeAtendimentoArray($coni_codigo);

		$this->view->hora = $tbHora->getHorariosEstabelecimentoDeSaudeArray($coni_codigo);

		$tbConv = new Application_Model_Convenio();
		$this->view->fds = $tbConv->atendeSabadoEDomingo($conv_codigo);
		return $this->render("agendamento-estabelecimentos-de-saude-profissionais");
	}

	public function excluirAgendamentoEstabelecimentosDeSaudeProfissionaisAction() {
		$id = (int)$this->_getParam("id", 0);
		$conv = (int)$this->_getParam("conv", 0);

		if (!$id) {
			return $this->_redirect("/agenda/convenio/agendamento-novo-vinculo-estabelecimento-de-saude");
		}

		$tbHora = new Application_Model_ConvenioHorarios();
		$tbHora->excluir($id);
		//add
		$tbHoraDias = new Application_Model_ConvenioHorariosDias();
		$tbHoraDias->excluirPorConiCodigo($id);

		$tbDias = new Application_Model_ConvenioDiasSemanaAgendamento();
		$tbDias->excluir($id);

		//add
		$tbGradeHora = new Application_Model_GradeHorario();
		$tbGradeHora->excluir($id);
		//add
		$tbGradeDia = new Application_Model_GradeDia();
		$tbGradeDia->excluir($id);
		//add
		$tbGradePeriodo = new Application_Model_GradePeriodo();
		$tbGradePeriodo->excluirPorConiCodigo($id);

		$tbConi = new Application_Model_ConvenioItens();
		$tbConi->excluir($id);

		return $this->_redirect("/agenda/convenio-itens/agendamento-estabelecimentos-de-saude-profissionais/conv/$conv");
	}

	private function carregaDadosEstabelecimentosDeSaude() {
		$conv_codigo = $this->_getParam("conv", FALSE);
		if (!$conv_codigo) {
			return $this->_redirect("agenda/convenio/agendamento-novo-vinculo-estabelecimento-de-saude");
		}
		$tbConv = new Application_Model_Convenio();
		$this->view->conv = $tbConv->getDadosAgendamentoEstabelecimentoDeSaude($conv_codigo);
		return $conv_codigo;
	}

	public function retornaAvisosAction($aviso) {
		switch ($aviso) {
			case "1":
				return "Agenda do profissional já foi criada para esta unidade, por favor realize a sua edição!";
				break;
			case "2":
				return "Agenda do profissional editada com sucesso!<br /> Por favor verifique se algum agendamento foi perdido para as proximas datas! <a href=" . $this->view->baseUrl() . "/agenda/recepcao" . ">Clique aqui para verificar</a>";
				break;
		}
	}


	/* -----------------------------------------------------------------
	 * METODOS CONVENIOS
	 * ----------------------------------------------------------------*/

	public function indexAction() {
		$mensagemErro = $this->_getParam("erro", FALSE);
		if ($mensagemErro) {
			$this->view->erro = $mensagemErro;
		}
		$conv_codigo = $this->carregaDadosConvenio();
		$tbConv = new Application_Model_Convenio();
		$tbConI = new Application_Model_ConvenioItens();
		$tbGruex = new Application_Model_GrupoExame();
		$this->view->grupos = $tbGruex->getGrupos();
		$this->view->fds = $tbConv->atendeSabadoEDomingo($conv_codigo);
		$this->carregaOrientacoes();

	}

	public function carregaOrientacoes($itens) {
		$tbConiOri = new Application_Model_ConvenioItensOrientacao();
		$this->view->orientacoes = $tbConiOri->buscarOrientacoesExames($itens);
	}

	public function itensAction() {
		$conv_codigo = $this->_getParam("conv", FALSE);
		if (!$conv_codigo)
			return $this->_redirect("/agenda/convenio");

		$tbConI = new Application_Model_ConvenioItens();
    $tbConv = new Application_Model_Convenio();
    $tbUsr = new Application_Model_Usuarios();

    $acessoLiberadoUnidades['acesso'] = $tbUsr->getUsrAtual()->usr_acesso_unidades;
    $acessoLiberadoUnidades['usr_logado'] = $tbUsr->getUsrAtual()->usr_codigo;

    $this->view->prestador = $tbConv->buscarPeloConv($conv_codigo, $acessoLiberadoUnidades)->prestador_servico;
		$this->view->itens = $tbConI->buscarPeloConvenio($conv_codigo);
	}

	public function getDadosConiCodigoAction() {
		$tbConvIte = new Application_Model_ConvenioItens();
		$coni_codigo = $this->_request->getPost("coni_codigo");
		$this->view->dados = $tbConvIte->getNomeProfissional($coni_codigo)->usr_codigo;
		return $this->render("dados", NULL, TRUE);
	}

  public function getDadosConvenioItemAction() {
    $tbConvIte = new Application_Model_ConvenioItens();
    $coni_codigo = $this->_request->getPost("coni_codigo");
    $this->view->dados = $tbConvIte->buscarGenerico(FALSE, $coni_codigo)->toArray();
    return $this->render("dados", NULL, TRUE);
  }

	/* -----------------------------------------------------------------
	* OUTROS METODOS DE CONVENIO QUE NAO SEI SE ESTA SENDO USADO
	* ----------------------------------------------------------------*/

	public function buscarAction() {
		$conv_codigo = $this->_getParam("conv_codigo", FALSE);
		$term = $this->_getParam("term", FALSE);
		$tbConI = new Application_Model_ConvenioItens();
		$this->view->dados = $tbConI->buscaSelectProcedimento($conv_codigo, $term);
		//echo "<pre>".  print_r($res,1);

		return $this->render("dados", NULL, TRUE);
		//$this->view->itens = $res;
	}

	/**
	 * Listar os procedimentos* de um convenio
	 * Chamar por post
	 * @param int conv_codigo
	 * @return json
	 */
	public function procedimentosAjaxAction() {

		$conv_codigo = $this->_request->getPost("conv_codigo", FALSE);
		if (!$conv_codigo)
			return $this->_redirect("/agenda/convenio/novo");

		$tbConvI = new Application_Model_ConvenioItens();

		$this->view->dados = $tbConvI->buscarPeloConvenio($conv_codigo, "S")->toArray();

		return $this->render("dados", NULL, TRUE);
	}

	private function carregaDadosConvenio() {
		$conv_codigo = $this->_getParam("conv", FALSE);
		if (!$conv_codigo) {
			return $this->_redirect("/agenda/convenio/novo");
		}
    $tbConv = new Application_Model_Convenio();
    $tbUsr = new Application_Model_Usuarios();

    $acessoLiberadoUnidades['acesso'] = $tbUsr->getUsrAtual()->usr_acesso_unidades;
    $acessoLiberadoUnidades['usr_logado'] = $tbUsr->getUsrAtual()->usr_codigo;

		$this->view->conv = $tbConv->buscarPeloConv($conv_codigo, $acessoLiberadoUnidades);
		return $conv_codigo;
	}

	public function editarAction() {
		$conv_codigo = $this->carregaDadosConvenio();
		$coni_codigo = (int)$this->_getParam("id", 0);
		if (!$coni_codigo)
			return $this->_redirect("/agenda/convenio-itens");
		$tbConi = new Application_Model_ConvenioItens();
		$tbDias = new Application_Model_ConvenioDiasSemana();
		$tbHora = new Application_Model_ConvenioHorarios();
		$tbConiOri = new Application_Model_ConvenioItensOrientacao();

		$this->view->itens = $tbConi->buscarPeloConvenio($conv_codigo);
		$this->view->dados = $tbConi->busca($coni_codigo);
		$this->view->itens->orientacoes = $tbConiOri->buscarPeloConvenioItem($coni_codigo);


		$this->view->atende = $tbDias->getDiasDeAtendimentoArray($coni_codigo);

		$this->view->hora = $tbHora->getHorariosArray($coni_codigo);
		$tbGruex = new Application_Model_GrupoExame();
		$this->view->grupos = $tbGruex->getGrupos();

		$tbConv = new Application_Model_Convenio();
		$this->view->fds = $tbConv->atendeSabadoEDomingo($conv_codigo);

		$iOri = array();
		foreach ($this->view->itens->orientacoes as $ori) {
			$iOri[] = $ori->ori_exa_codigo;
		}

		$this->carregaOrientacoes($iOri);

		return $this->render("index");
	}

	public function excluirAction() {
		$id = (int)$this->_getParam("id", 0);
		$conv = (int)$this->_getParam("conv", 0);
		$mensagemErro = "";

		if (!$id) {
			return $this->_redirect("/agenda/convenio-itens");
		}
		try {
			$tbConi = new Application_Model_ConvenioItens();
			$checaVinculo = $tbConi->checaVinculo($id);
			if ($checaVinculo['vinculo'] > 1) {
				$mensagemErro = "Esse item não pode ser excluído, pois o mesmo possui vínculo com outros registros";
				throw new Exception();
			}

			$tbHora = new Application_Model_ConvenioHorarios();
			$tbHora->excluir($id);

			$tbDias = new Application_Model_ConvenioDiasSemana();
			$tbDias->excluir($id);

			$tbConi->excluir($id);
		} catch (Exception $exception) {
			return $this->_redirect("/agenda/convenio-itens/index/conv/$conv/erro/$mensagemErro");
		}
		if ($this->_getParam("json", FALSE)) {
			$this->view->dados = array("success" => TRUE);
			return $this->render("dados", NULL, TRUE);
		}

		return $this->_redirect("/agenda/convenio-itens/index/conv/$conv");
	}

	public function carregaConvenioHorariosAction() {
		$coni_codigo = $this->_getParam("coni_codigo", false);
		$tbConHor = new Application_Model_ConvenioHorarios();
		$this->view->dados = $tbConHor->getHorariosConvenioItem($coni_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function carregaEspecialidadeAction() {
		$usr_codigo = $this->_getParam("usr_codigo", false);
		$conv_codigo = $this->_getParam("conv_codigo", false);
		$uni_codigo = $this->_getParam("uni_codigo", false);
		$tbMes = new Application_Model_MedicoEspecialidade();
		$this->view->dados = $tbMes->getEspecialidadePorMedico($usr_codigo, $uni_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function carregaEspecialidadePorConvenioAction() {
		$conv_codigo = $this->_getParam("conv_codigo", false);
		$usr_codigo = $this->_getParam("usr_codigo", false);
		$tbMes = new Application_Model_MedicoEspecialidade();
		$this->view->dados = $tbMes->getEspecialidadePorConvenio($conv_codigo, $usr_codigo)->toArray();
		return $this->render("dados", NULL, TRUE);
	}

	public function salvarAction() {

		$dados = $this->_request->getPost();
//		die(json_encode($dados));
		$tbConi = new Application_Model_ConvenioItens();
		$tbCondi = new Application_Model_ConvenioDiasSemanaAgendamento();
		$tbConHor = new Application_Model_ConvenioHorarios();
		// Validando Inserção do Convenio Itens
		// Verifica se não e edição
		if ($dados["coni_codigo"] == "" && $dados["conv_codigo"] != "" && $dados["esp_codigo"] != "" && $dados["usr_codigo"] != "") {
			// Se não for edição, verifica se esta duplicado
			$confere = $tbConi->confereConvItens($dados["conv_codigo"], $dados["esp_codigo"], $dados["usr_codigo"]);
			if ($confere->qtd_conv > 0) {
				return $this->_redirect("agenda/convenio-itens/agendamento-estabelecimentos-de-saude-profissionais/conv/" . $dados["conv_codigo"] . "/aviso/01");
			}
		}
		// Salvando o convenio itens
		$array_convenio_itens = array(
			"coni_codigo" => $dados["coni_codigo"],
			"usr_codigo" => $dados["usr_codigo"],
			"esp_codigo" => $dados["esp_codigo"],
			"coni_alerta" => $dados["coni_alerta"],
			"conv_codigo" => $dados["conv_codigo"],
			"coni_tipo_origem" => "P",
			"coni_tipo_prestador" => "Q",
			"coni_data_inicio" => ($dados["data_inicio"] ? $dados["data_inicio"] : NULL),
			"coni_data_termino" => ($dados["data_termino"] ? $dados["data_termino"] : NULL),
			"coni_ativo" => ($dados["coni_ativo"] ? $dados["coni_ativo"] : "S")
		);

		$coni_codigo = ($dados["coni_codigo"] ? $dados["coni_codigo"] : FALSE);
		try {
			$coni_codigo = $tbConi->salvar($array_convenio_itens);
		} catch (Zend_Validate_Exception $exc) {
			die($exc->getMessage());
		}

		$age = $this->preparaDados($dados['dias-semana']);

		$tbConHor->excluir($coni_codigo);
		foreach ($age as $key => $dado) {
			$data_convenio_dias_semanas_agendamento = array(
				"condi_age_dia" => $key,
				"coni_codigo" => $coni_codigo
			);
			try {
				$condi_age_codigo = $tbCondi->salvar($data_convenio_dias_semanas_agendamento);
				foreach ($dado as $keydias => $dadodias) {
					$data_convenio_horarios = array(
						"condi_age_codigo" => $condi_age_codigo,
						"coni_codigo" => $coni_codigo,
						"hora_inicial" => $dadodias['hora_inicial'],
						"hora_final" => $dadodias['hora_final'],
						"conh_intervalo" => $dadodias['conh_intervalo'],
						"conh_encaixe" => $dadodias['conh_encaixe'],
						"conh_cota_dia" => $dadodias['conh_cota_dia']);
					try {
						$hora_codigo = $tbConHor->salvar($data_convenio_horarios);
					} catch (Exception $e) {
						die($e->getMessage());
					}
				}
			} catch (Exception $e) {
				die($e->getMessage());
			}
		}

		$this->view->dialog = array("Confirmação", "Encaminhamento registrado com sucesso!", 300, 140);
		return $this->_redirect("agenda/convenio-itens/agendamento-estabelecimentos-de-saude-profissionais/conv/" . $this->_request->getPost("conv_codigo") . "$aviso2");
	}

	private function preparaDados($dados) {
		foreach ($dados as $ds_key => $ds_dado) {
			foreach ($ds_dado as $t_key => $t_dado) {
				foreach ($t_dado as $key => $dado) {
					$age[$ds_key][$key][$t_key] = $dado;
				}
			}
		}
		return $age;
	}


	public function salvarProcedimentoLaboratorioAction() {
		// Validando se esta vindo dados via post
		if ($this->_request->isPost()) {
			// Criando o array com os dados para inserir no banco
			$tbGruex = new Application_Model_GrupoExame();
			$this->view->grupos = $tbGruex->getGrupos();
			$dados = array(
				"proc_codigo" => $this->_request->getPost("proc_codigo", NULL),
				"esp_codigo" => $this->_request->getPost("esp_codigo", NULL),
				"usr_codigo" => $this->_request->getPost("usr_codigo", NULL),
				"conv_codigo" => $this->_request->getPost("conv_codigo", FALSE),
				"coni_codigo" => $this->_request->getPost("coni_codigo", FALSE),
				"coni_valor" => $this->_request->getPost("coni_valor", NULL),
				"coni_cota_mes" => $this->_request->getPost("coni_cota_mes", -1),
				"coni_cota_dia" => $this->_request->getPost("coni_cota_dia", -1),
				"coni_cota_mes_original" => $this->_request->getPost("coni_cota_mes_original", -1),
				"coni_cota_dia_original" => $this->_request->getPost("coni_cota_dia_original", -1),
				"coni_tipo_origem" => $this->_request->getPost("prestador", "P"),
				"coni_tipo_prestador" => $this->_request->getPost("coni_tipo_prestador", "Q"),
				"coni_ativo" => $this->_request->getPost("coni_ativo"),
				"coni_encaixe" => $this->_request->getPost("coni_encaixe", NULL),
				"coni_intervalo" => $this->_request->getPost("coni_intervalo", NULL),
				"tipo_form" => "P",
				"gruex_codigo" => ($this->_request->getPost("gruex_codigo") != "" ? $this->_request->getPost("gruex_codigo") : null),
				"orientacoes" => (count($this->_request->getPost("orientacoes-selecionadas")) > 0 ? $this->_request->getPost("orientacoes-selecionadas") : null)
			);
			// Verifica se tem as datas se tiver inclui
			if ($this->_request->getPost("coni_data_inicio")) {
				$dados["coni_data_inicio"] = $this->_request->getPost("coni_data_inicio");
			}
			if ($this->_request->getPost("coni_data_termino")) {
				$dados["coni_data_termino"] = $this->_request->getPost("coni_data_termino");
			}

			try {

				// Chamando o model de convenio itens
				$tbConv = new Application_Model_ConvenioItens();
				//Checando se o procedimento inserido ja existe para esse convenio
				$checaProcedimento = $tbConv->checaProcedimento($dados["proc_codigo"], $dados["conv_codigo"]);
				//die($checaProcedimento);
				if ($checaProcedimento && empty($dados["coni_codigo"])) {
					$mensagemErro = "Já existe uma configuração para esse procedimento nesse convênio";
					throw new Exception();
				}
				// Enviando os dados para salvar no banco
				$coni_codigo = $tbConv->salvar($dados);
				// Remove os horarios dos conv?nios pra atualizar posteriormente
				$tbHora = new Application_Model_ConvenioHorarios();
				$tbHora->excluir($coni_codigo);
				// Colocando os horarios em array e salvando em banco
				for ($i = 1; $i <= $this->_request->getPost("qtd_hr", 0); $i++) {
					$dadosHora = array(
						"coni_codigo" => $coni_codigo,
						"hora_inicial" => $this->_request->getPost("hr_inicio" . $i, FALSE),
						"hora_final" => $this->_request->getPost("hr_fim" . $i, FALSE)
					);
					$tbHora->salvar($dadosHora);
				}
				// Chamando o model de dias da semana
				$tbDias = New Application_Model_ConvenioDiasSemana();
				// Removendo os dias cadastrados, para atualizar posteriormente
				$tbDias->excluir($coni_codigo);
				$dias = $this->_request->getPost("dias", 0);
				foreach ($dias as $value) {
					$dadosDias = array(
						"coni_codigo" => $coni_codigo,
						"condi_dia" => $value);
					$tbDias->salvar($dadosDias);
				}

				// Redirecionando a pagina, tratamento de erros
				return $this->_redirect("/agenda/convenio-itens/index/conv/" . $dados["conv_codigo"]);
				// Tratamento de erro
			} catch (Zend_Validate_Exception $exc) {
				$this->view->erro = $exc->getMessage();
				$this->view->dados = (object)$dados;
				$this->carregaDadosConvenio();
				return $this->render("index");
			} catch (Exception $exception) {
				$this->view->erro = $mensagemErro;
				$this->view->dados = (object)$dados;
				$this->carregaDadosConvenio();
				return $this->render("index");
			}

		} else {
			$this->_redirect("/agenda/convenio/novo");
		}
	}

	public function acessoLiberadoConvenioAction(){
		$conv_codigo = $this->_getParam("conv", FALSE);

    $tbConv = new Application_Model_Convenio();
    $tbUsr = new Application_Model_Usuarios();

    $acessoLiberadoUnidades['acesso'] = $tbUsr->getUsrAtual()->usr_acesso_unidades;
    $acessoLiberadoUnidades['usr_logado'] = $tbUsr->getUsrAtual()->usr_codigo;

		$dados = $tbConv->buscarPeloConv($conv_codigo, $acessoLiberadoUnidades);

		$this->view->dados = $dados;
		return $this->render("dados", NULL, TRUE);
	}
}
