<?php

require_once __DIR__ . '/../../Util.php';

class Agendamento_AgendamentoController extends Zend_Controller_Action {

  public function historicoAction() {
    $this->_helper->layout->disableLayout();
    $usu_codigo = $this->_getParam("usu", FALSE);
    if (!$usu_codigo) {
      return $this->_redirect("/agendamento/index");
    }

    $tbAge = new Application_Model_Agendamento();
    $this->view->itens = $tbAge->getHistoricoPorUsuario($usu_codigo);
  }

  public function selecionarDataAction() {
    $this->_helper->layout->disableLayout();
    // Passa por get código do usuário, código do convênio item e data inicial
    $usr_codigo = $this->_getParam("prof", FALSE);
    $coni_codigo = $this->_getParam("coni_codigo", FALSE);
    $this->view->data_inicial = $this->_getParam("de", date("Y-m-d"));
    // Se não tiver usuário ele reinderiza a página
    if (!$usr_codigo) {
      return $this->_helper->viewRenderer->setNoRender(true);
    }
    $tbAge = new Application_Model_Agendamento();
    $tbConI = new Application_Model_ConvenioItens();
    // Efetua calculo de data final de acordo com o número de dias implicito na configuração AGENDA_MOSTRAR_N_OPCOES
    $this->view->data_final = $tbAge->calculaDataFinal($this->view->data_inicial);
    $this->view->coni_codigo = $coni_codigo;
    // Array de datas com a quantidade de vagas disponível encaminhado para a view
    $this->view->vagas = $tbAge->getVagas($coni_codigo, $this->view->data_inicial, $this->view->data_final);
    // Pega nome do profissional e encaminha para view
    $this->view->nomeProf = $tbConI->getNomeProfissional($coni_codigo);
  }

  public function selecionarHorarioAction() {
    $this->_helper->layout->disableLayout();
    // Passa por get código do convênio, código do convênio item e data inicial
    $conv_codigo = $this->_getParam("conv_codigo", FALSE);
    $coni_codigo = $this->_getParam("coni_codigo", FALSE);
    $this->view->data_inicial = $this->_getParam("ds", date("Y-m-d"));
    // Se código do convênio item não existir redireciona a página
    if (!$coni_codigo) {
      return $this->_helper->viewRenderer->setNoRender(true);
    }

    $tbAge = new Application_Model_Agendamento();
    $tbConI = new Application_Model_ConvenioItens();
    $tbConH = new Application_Model_ConvenioHorarios();
    $tbConvAge = new Application_Model_ConvenioDiasSemanaAgendamento();
    $tbFun = new Application_Model_Funcoes();
    $tbGrap = new Application_Model_GradePeriodo();
    // Criar array de horários com hora inicial e final, se for exceção pega da grade periodo, se não pega da tabela de convenio_horários
    $atendeQueDia = $tbFun->diaSemana($this->view->data_inicial);
    $condiAgeCod = $tbConvAge->getDadosDia($coni_codigo, $atendeQueDia)->condi_age_codigo;
    $turnos = $tbGrap->getPeriodosGrade($coni_codigo, $this->view->data_inicial);

    if ($condiAgeCod && count($turnos)==0) {
      $condiAgeEnc = $tbConH->getIntervalosNovo($condiAgeCod);
    } else {
      $condiAgeEnc = $tbGrap->getPeriodosGrade($coni_codigo, $this->view->data_inicial);
    }
    $horarios = $tbGrap->getHorariosDia($coni_codigo, $this->view->data_inicial, $condiAgeCod);
    //print_r($horarios);
    // Calcula quantidade de intervalo dos horários e joga em um array
    $quantidades = $tbFun->calculaQuantidadePorIntervalo($horarios, $coni_codigo, $this->view->data_inicial, $condiAgeCod);
    //print_r($quantidades);
    // Realiza um arry de distribuição de horários pela quantidade, horarios e etc ..
    $distribuicao = $tbFun->distribuicao($quantidades, $horarios, $coni_codigo, $this->view->data_inicial, $condiAgeCod);

    if ($this->view->data_inicial == date('Y-m-d')) {
      $this->view->distribuicao = $distribuicao;
      // Verifica se tem encaixe na tabela de convênio itens
      $this->view->encaixe = $condiAgeEnc;
    } else {
      for ($i = 0; $i < count($distribuicao); $i++) {
        $distribuicaonovo[$i] = array_slice($distribuicao[$i], 0, $condiAgeEnc[$i]['conh_cota_dia']);
      }
      $this->view->distribuicao = $distribuicaonovo;
    }
  }

  public function confereHorarioAction() {
    $this->_helper->layout->disableLayout();
    // Passa por get código do convênio, código do convênio item e data inicial
    //$usr_codigo = $this->_getParam("prof", FALSE);
    $conv_codigo = $this->_getParam("conv_codigo", FALSE);
    $coni_codigo = $this->_getParam("coni_codigo", FALSE);
    // Transforma o horário e quebra em duas casas
    $horarioGet = explode("-", $this->_getParam("horario", FALSE));
    $horario = $horarioGet[0] . ":" . $horarioGet[1];

    $tbConvHorDia = new Application_Model_ConvenioHorariosDias();
    if ($tbConvHorDia->confereSeHorarioExiste($horario) >= 1) {
      return true;
    } else {
      return false;
    }
  }

  public function buscarEspecialidadePorConiAction() {
    $this->_helper->layout->disableLayout();

    $coni_codigo = $this->_getParam("coni_codigo", FALSE);

    $tbConI = new Application_Model_ConvenioItens();
    $this->view->dados = $tbConI->getEspecialidadeConvenioItens($coni_codigo)->toArray();

    return $this->render("dados", NULL, TRUE);
  }

  public function buscarProcedimentoPorEspecialidadeAction() {
    $this->_helper->layout->disableLayout();

    $esp_codigo = $this->_getParam("esp_codigo", FALSE);

    $tbAgen = new Application_Model_Agendamento;
    $this->view->dados = $tbAgen->buscarProcedimentoPorEspecialidade($esp_codigo)->toArray();

    return $this->render("dados", NULL, TRUE);
  }

  public function salvarAction() {
    $tbAge = new Application_Model_Agendamento();
    $tbEsp = new Application_Model_Especialidade();
    $tbUsr = new Application_Model_Usuarios();
    $tbConv = new Application_Model_Convenio();

    $session = new Zend_Session_Namespace();
    $session->dados = $this->_request->getPost();
    $horario_de_encaixe = $this->_request->getPost("horario_de_encaixe", FALSE);
    if ($horario_de_encaixe == "S") {
      $uni_codigo = $tbUsr->getUsrAtual();
      if ($uni_codigo->uni_codigo != $this->_request->getPost("codigo_convenio", FALSE)) {
        $unidade = $tbConv->getUnidadePorConvenio($this->_request->getPost("codigo_convenio", FALSE));
        $this->view->dados = [
          "success" => FALSE,
          "titulo" => "Aviso",
          "mensagem" => "As vagas de encaixe são de uso exclusivo da " . $unidade->uni_desc
        ];
        return $this->render("dados", NULL, TRUE);
      }

      if ($this->_request->getPost("age_data", FALSE) != date("Y-m-d")) {
        $this->view->dados = [
          "success" => FALSE,
          "titulo" => "Aviso",
          "mensagem" => "As vagas de encaixe só podem ser utilizadas no dia da consulta!"
        ];
        return $this->render("dados", NULL, TRUE);
      }
    }

    $dados = [
      "fiusu_codigo" => $this->_request->getPost("fiusu_codigo", FALSE),
      "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
      "age_paciente" => $this->_request->getPost("usu_nome", FALSE),
      "age_horario" => $this->_request->getPost("age_horario", FALSE),
      "age_data" => $this->_request->getPost("age_data", FALSE),
      "coni_codigo" => $this->_request->getPost("coni_codigo", FALSE),
      "esp_codigo" => $this->_request->getPost("esp_codigo", FALSE),
      "proc_codigo" => $this->_request->getPost("proc_codigo", FALSE),
      "coni_codigo" => $this->_request->getPost("coni_codigo", FALSE),
      "uni_codigo" => $this->_request->getPost("codigo_convenio", FALSE),
      "med_codigo" => $this->_request->getPost("usr_codigo_medico", FALSE),
      "esp_codigo" => $tbEsp->getEspecialidadePorConvenio($this->_request->getPost("esp_codigo", FALSE))->esp_codigo,
      "age_atendido" => "N",
      "dt_cadastro" => "NOW()",
      "tat_codigo" => $this->_request->getPost("tat_codigo", FALSE),
      "tp_cod" => ($this->_request->getPost("tp_cod") != "" ? $this->_request->getPost("tp_cod") : "")
    ];

    $horario_vago = $tbAge->verificaHorario($this->_request->getPost("coni_codigo", FALSE), $this->_request->getPost("age_data", FALSE), $this->_request->getPost("age_horario", FALSE));
    $tem_agendamento = $tbAge->verificaSeTemAgendamento($this->_request->getPost("coni_codigo", FALSE), $this->_request->getPost("age_data", FALSE), $this->_request->getPost("usu_codigo", FALSE));
    $espConfig = $this->_request->getPost("esp_codigo_config");

    if ($tbEsp->getEspecialidade($espConfig)->esp_mais_agendamento) {
      $this->salvaOuNao($dados);
    } else {
        if($horario_vago->quantidade >0){
            $this->view->dados = [
                "success" => FALSE,
                "titulo" => "Aviso",
                "mensagem" => "Horário indisponível, selecione outro horário!"
            ];
        } elseif ($tem_agendamento->quantidade > 0) {
        $this->view->dados = [
          "success" => FALSE,
          "titulo" => "Aviso",
          "mensagem" => "Este paciente já possui agendamento para esta data!"
        ];
      } else {
        $this->salvaOuNao($dados);
      }
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function salvaOuNao(array $dados) {
    $tbAge = new Application_Model_Agendamento();
    try {
      if ($dados['fiusu_codigo'] != "") {
        $status = "SA";
        $tbFilausu = new Application_Model_FilasUsuario();
        $tbFilaProc = new Application_Model_FilasUsuarioProcedimento();
        $procedimento = $tbFilaProc->listar($dados['fiusu_codigo']);
        $filaUsu = $tbFilausu->getdados($dados['fiusu_codigo']);
        if ($dados['usu_codigo'] != $filaUsu->usu_codigo) {
          $this->view->dados = [
            "success" => FALSE,
            "titulo" => "Erro",
            "mensagem" => "Usuário diferente do cadastrado na Fila de Espera"
          ];
          return;
        }
        if ($dados['esp_codigo'] != $filaUsu->esp_codigo) {
          $this->view->dados = [
            "success" => FALSE,
            "titulo" => "Erro",
            "mensagem" => "Especialidade diferente do cadastrado na Fila de Espera"
          ];
          return;
        }
        if ($dados['proc_codigo'] != $procedimento[0]->proc_codigo) {
          $this->view->dados = [
            "success" => FALSE,
            "titulo" => "Erro",
            "mensagem" => "Procedimento diferente do cadastrado na Fila de Espera"
          ];
          return;
        }
        $tbFila = new Application_Model_Filas();
        $tbFilausu->setStatus($dados['fiusu_codigo'], $status);
        $aux = $tbFilausu->getdados($dados['fiusu_codigo']);
        $tbFila->ordenaFilaAction($aux->fila_codigo);
      }
      $age_codigo = $tbAge->salvar($dados);

      if ((new Application_Model_Configuracao())->getConfig('ENVIO_MENSAGENS_AUTOMATICAS')) {
        $tbUsr = new Application_Model_Usuarios();
        $tbUsu = new Application_Model_Usuario();
        $dados['age_codigo'] = $age_codigo;
        $dados['paciente'] = $tbUsu->getUsuarioPorId($dados['usu_codigo']);
        $dados["access_token"] = $_SESSION['access_token'];
        $dados["age_codigo_agentic"] = Util::sendRequestAgentic($dados, 'agendamento', '/agendamento/cadastrar');
        unset($dados['paciente']);
        unset($dados['access_token']);

        $age_codigo = $tbAge->salvar($dados);
      }

      $this->view->dados = [
        "success" => TRUE,
        "age_codigo" => $age_codigo,
        "fila_codigo" => $aux->fila_codigo
      ];
    } catch (Zend_Validate_Exception $exc) { // Exceção de validação
      $this->view->dados = [
        "success" => FALSE,
        "titulo" => "Erro",
        "mensagem" => $exc->getMessage(),
        "code" => $exc->getCode()
      ];
    }
  }

  public function imprimirAction() {
    $age_codigo = $this->_getParam("age", FALSE);
    $this->_helper->layout->setLayout("modelo-print");
    $tbAge = new Application_Model_Agendamento();
    $age = $tbAge->getAgendamento($age_codigo);

    if ($this->_getParam("p_horario", FALSE)) {
      $this->view->p_horario = $this->_getParam("p_horario", FALSE);
    } else {
      $tbConf = new Application_Model_Configuracao();
      if ($tbConf->getConfig("IMPRIMIR_PRIMEIRO_HORARIO")) {
        $tbConvAge = new Application_Model_ConvenioDiasSemanaAgendamento();
        $tbFun = new Application_Model_Funcoes();
        $tbGrap = new Application_Model_GradePeriodo();
        // Criar array de horários com hora inicial e final, se for exceção pega da grade periodo, se não pega da tabela de convenio_horários
        $atendeQueDia = $tbFun->diaSemana($age->age_data);
        $condiAgeCod = $tbConvAge->getDadosDia($age->coni_codigo, $atendeQueDia)->condi_age_codigo;
        $horarios = $tbGrap->getHorariosDia($age->coni_codigo, $age->age_data, $condiAgeCod)->toArray();
        $primeiro_horario = "";
        foreach ($horarios as $horario) {
          $arr_hora = explode(":", $horario['hora_inicial']);
          $hora = $arr_hora[0] . $arr_hora[1];

          $arr_p_hora = explode(":", $primeiro_horario);
          $p_hora = $arr_p_hora[0] . $arr_p_hora[1];
          if ($hora < $p_hora || $p_hora == "") {
            $primeiro_horario = $horario['hora_inicial'];
          }
        }
        $this->view->p_horario = $primeiro_horario;
      } else {
        $this->view->p_horario = $age->age_horario;
      }
    }
    $this->view->usr_tipo_medico = $age->usr_tipo_medico;
    $this->view->codigo = $age_codigo;
    $this->view->usu_codigo = $age->usu_codigo;
    $this->view->usu_prontuario = $age->usu_prontuario;
    $this->view->usu_nome = $age->usu_nome;
    $this->view->usu_datanasc = $age->usu_datanasc;
    $this->view->usu_cartao_sus = $age->usu_cartao_sus;
    $this->view->usu_mae = $age->usu_mae;
    $this->view->domicilio = $age;
    $this->view->age = $age;
  }

  public function getAgendamentoAction() {
    $age_codigo = $this->_getParam("age", null);
    $tbAge = new Application_Model_Agendamento();
    $row = $tbAge->getAgendamento($age_codigo)->age_codigo;
    die($row);
  }

  public function getAgendamentoFilaAction() {
    $fiusu_codigo = $this->_getParam("fiusu_codigo");
    $tbAge = new Application_Model_Agendamento();
    $age = $tbAge->getDadosAgendamentoFila($fiusu_codigo);

    $this->view->dados = array(
      "success" => TRUE,
      "agendamento" => $age->age_codigo,
      "uni_codigo" => $age->uni_codigo,
      "usr_codigo" => $age->med_codigo,
      "esp_codigo" => $age->esp_codigo,
      "age_data" => $age->age_data,
      "data_inicial" => $age->age_data,
      "conv_codigo" => $age->uni_codigo,
      "coni_codigo" => $age->coni_codigo);
    $this->render("dados", NULL, TRUE);
  }

  public function getDadosAgendamentoInternoAction() {
    $age = (new Application_Model_Agendamento())->getDadosAgendamentoInterno($this->_getParam("age_codigo"));

    $this->view->dados = [
      "dataAlteracao" => TRUE,
      "dataCadastro" => $age->age_codigo,
      "dataAgendamento" => $age->uni_codigo,
      "celular" => $age->med_codigo,
      "hora" => $age->esp_codigo,
      "tipo" => $age->age_data,
      "status" => $age->age_data,
      "realizada" => $age->uni_codigo,
      "codigoEmpresa" => $age->coni_codigo,
      "codigoPaciente" => $age->coni_codigo,
      "codigoMedico" => $age->coni_codigo,
      "codigoPrestador" => $age->coni_codigo,
      // "access_token" => $_SESSION['access_token'],
    ];
    $this->render("dados", NULL, TRUE);
  }

  public function getFaltasPorPacienteAction() {
    $tbAge = new Application_Model_Agendamento();
    $tbConfig = new Application_Model_Configuracao();

    $qtd_dias = $tbConfig->getConfig('ALERTA_AGENDAMENTO_QTD_DIAS');
    $usu_codigo = $this->_request->getPost("usu_codigo");
    $retorno['msg'] = $tbConfig->getConfig('ALERTA_AGENDAMENTO_TEXTO');
    $retorno['falta'] = $tbAge->buscarFaltasPaciente($usu_codigo, $qtd_dias)->toArray();

    $this->view->dados = $retorno;
    return $this->render("dados", NULL, TRUE);
  }
}
