<?php

class Atendimento_AtendimentoSimplificadoController extends Zend_Controller_Action {

  public function indexAction() {
    $tbAcessosFichaEsus = new Application_Model_AcessosFichaEsus();
    $tbUsr = new Application_Model_Usuarios();
    $tbEsp = new Application_Model_Especialidade();
    $usr = $tbUsr->getUsrAtual();
    $tipo = $this->_getParam("tipo");
    $valida = $this->_getParam("valida");
    $this->view->tipo = $tipo;
    $this->view->usr_digitador = $usr->usr_digitador;
    if ($usr->usr_digitador == 'N' && !$valida) {
      if (!$usr->esp_codigo) {
        return $this->_redirect("/atendimento/atendimento-simplificado/erro");
      } else {
        $especialidade = $tbEsp->getEspecialidade($usr->esp_codigo);
        if (!$tbAcessosFichaEsus->getAcessosFichaEsus($especialidade->cod_cbo, $tipo) && $usr->usr_digitador == 'N') {
          return $this->_redirect("/atendimento/atendimento-simplificado/erro");
        }
      }
    }

    $this->view->valida = $valida;
    $this->_helper->layout->setLayout("simples");
    $tbVisistaMotivo = new Application_Model_TbCdsVisitaDomMotivo();
    $tbVisistaDesfecho = new Application_Model_TbCdsVisitaDomDesfecho();
    $tbCiap = new Application_Model_TbCiap();
    $tbTa = new Application_Model_TipoAtendimento();
    $this->view->motivosPt01 = $tbVisistaMotivo->getMotivosParte01();
    $this->view->motivosPt02 = $tbVisistaMotivo->getMotivosParte02();
    $this->view->buscaAtiva = $tbVisistaMotivo->getBuscaAtiva();
    $this->view->acompanhamento = $tbVisistaMotivo->getAcompanhamento();
    $this->view->desfechos = $tbVisistaDesfecho->getDesfecho();
    $this->view->ciap = $tbCiap->getCiaps();
    $this->view->tipo_atendimento = $tbTa->getTiposDeAtendimento();

    $unidade_controle = $this->_getParam("unidade_controle");
    $this->view->unidade_controle = $unidade_controle;

    $uni_codigo_controle = $this->_getParam("uni_codigo_controle");
    $this->view->uni_codigo_controle = $uni_codigo_controle;

    $this->view->tipo = $tipo;

    $data_controle = $this->_getParam("data_controle");
    $data_controle = explode('-', $data_controle);
    $data_controle = implode('/', $data_controle);
    $this->view->data_controle = $data_controle;

    $usr_nome_controle = $this->_getParam("usr_nome_controle");
    $this->view->usr_nome_controle = $usr_nome_controle;

    $usr_codigo_controle = $this->_getParam("usr_codigo_controle");
    $this->view->usr_codigo_controle = $usr_codigo_controle;

    $esp_codigo_controle = $this->_getParam("esp_codigo_controle");
    $this->view->esp_codigo_controle = $esp_codigo_controle;

    $ate_tipo_atendimento_controle = $this->_getParam("ate_tipo_atendimento_controle");
    $this->view->ate_tipo_atendimento_controle = $ate_tipo_atendimento_controle;

    $ateCodigo = $this->_request->getParam("ate_codigo");
    $ageCodigo = $this->_request->getParam("age_codigo");
    //Este fica fora para executar o else
    $tbLocal = new Application_Model_TbLocalAtend();

    $tbCti = new Application_Model_TbCdsTipoImovel();
    $this->view->tipo_imovel = $tbCti->getDados();
    $this->view->ate_codigo = $ateCodigo;
    if ($ateCodigo) {
      //buscar o atendimento
      $tbAte = new Application_Model_Atendimento();
      $atendimento = $tbAte->buscar($ateCodigo);
      $tbAge = new Application_Model_Agendamento();
      $agendamento = $tbAge->getDadosAgendamentoUsuario($ageCodigo);
      $tbProc = new Application_Model_ProcedimentoAtendimento();
      $procedimento = $tbProc->getAtendimentoPorAteCodigo($ateCodigo);


      //procedimentos ficha
      $procedimentoEsus = $tbProc->getProcEsusPorAteCodigo($ateCodigo);
      foreach ($procedimentoEsus as $procEsus) {
        switch ($procEsus->proc_codigo_sus) {
          case "ABPG007":
            $this->view->curativo_especial = TRUE;
            break;
          case "ABEX022":
            $this->view->teste_olhinho = TRUE;
            break;
          case "ABPG040":
            $this->view->teste_proteinuria = TRUE;
            break;
          case "ABPG028":
            $this->view->adm_intramuscular = TRUE;
            break;
          case "ABPG029":
            $this->view->adm_endovenosa = TRUE;
            break;
          case "ABPG031":
            $this->view->adm_topica = TRUE;
            break;
          case "ABPG032":
            $this->view->adm_penicilina = TRUE;
            break;
          case "ABPG041":
            $this->view->adm_subcutanea = TRUE;
            break;
        }
      }

      //dados pre-natal
      $tbAtePre = new Application_Model_AtendimentoPrenatal();
      $dadosPreNatal = $tbAtePre->getDados($ateCodigo);
      $this->view->pre_natal = $dadosPreNatal;
      $tbDadosUsu = new Application_Model_UsuarioDados();
      $dadosUsu = $tbDadosUsu->buscaDadosUsuario($atendimento->usu_codigo);
      $this->view->dadosUsuario = $dadosUsu;

      //local
      $this->view->selectLocais = $tbLocal->selectTag($atendimento->co_local_atend);
      //manda o atendimento para a view adequar o formulario correto
      $this->view->atendimento = $atendimento;
      $this->view->uni_tipo = $atendimento->uni_tipo;

      //busca as ciaps do atendimento, e manda para a view
      $rlAteCiap = new Application_Model_RlCdsAtendIndividualCiap();
      $ciapsDoAtendimento = $rlAteCiap->getCiapAtendimento($ateCodigo);
      $this->view->ciap_selecionados = $ciapsDoAtendimento;
      //conduta do atendimento
      $tbCond = new Application_Model_RlCdsAtendIndividualCondut();
      $condutasDoAtendimento = $tbCond->getDadosPorAtendimento($ateCodigo);
      $this->view->condutasDoAtendimento = $condutasDoAtendimento;
      // motivos visita

      if ($atendimento->ate_tipo == "V") {
        $tbRati = new Application_Model_RlAteTipoImovel();
        $var = $tbRati->getAteImovel($ateCodigo);
        $this->view->tipo_imovel_atendimento = $var['no_cds_tipo_imovel'];

        $tbVisita = new Application_Model_TbCdsVisitaDomiciliar();
        $visita = $tbVisita->getVisitaDoAtendimento($ateCodigo);
        $rlVisitaMotivo = new Application_Model_RlCdsVisitaDomMotivo();
        $motivosDoAte = $rlVisitaMotivo->getMotivosDoAtendimento($visita->co_seq_cds_visita_domiciliar);
        $this->view->motivosDoAte = $motivosDoAte;
        $this->view->visita = $visita;
      }

      $this->view->agendamento = $agendamento;

      if (count($procedimento) > 0) {
        $this->view->procedimento = $procedimento;
        $this->view->cids = $this->findListCidsFromAtendimento($procedimento);
      }
    } else {
      //caso não for uma edição, o tipo do atendimento recebe A(atendimento individual) como padrão
      $this->view->tipo_atendimento = "A";
      $this->view->selectLocais = $tbLocal->selectTag();
    }

    $tbConf = new Application_Model_Configuracao();

    if ($tbConf->getConfig("GRUPO_DOENCAS") == 1) {
      $tbGruDoen = new Application_Model_GrupoDeDoencas();
      $this->view->grupo_doencas = $tbGruDoen->listaGrupoDeDoencasCid();
    }
    // Válida CID10
    $tbConf = new Application_Model_Configuracao();
    if ($tbConf->getConfig("CID_OBRIGATORIO")) {
      $this->view->cid_obrigatorio = true;
    }

  }

  public function erroAction() {
    $this->view->title = "Acesso restrito";
  }

  private function findListCidsFromAtendimento($procedimento) {
    $tbCid = new Application_Model_Cid();
    return $tbCid->getDadosPorAtendimento($procedimento[0]->ate_codigo);
  }

  public function formAtendimentoSimplificadoAction() {
    $tbConf = new Application_Model_Configuracao();
    $tbLocal = new Application_Model_TbLocalAtend();
    $tbTipoCond = new Application_Model_TbCdsTipoConduta();
    $tbUsr = new Application_Model_Usuarios();
    $tbCid = new Application_Model_Cid();
    $cids = $tbCid->buscarTodos();
    $tipo = $this->_getParam("tipo");
    $this->view->tipo = $tipo;
    $usr = $tbUsr->getUsrAtual();
    $this->view->usuario = $usr;
    $this->view->cids_principal = $cids;
    $tbTa = new Application_Model_TipoAtendimento();
    $this->view->cadastro_aise = $tbConf->getConfig("CADASTRO_AISE");
    $this->view->conduta = $tbTipoCond->getDados();
    $this->view->encaminhamentos = $tbTipoCond->getDadosEncaminhamento();
    $this->view->tipo_atendimento01 = $tbTa->getTiposDeAtendimento01();
    $this->view->tipo_atendimento02 = $tbTa->getTiposDeAtendimento02();
    //die($usr->usr_nome." - ".$usr->usr_restringe_atendimento_simplificado);
    if ($usr->usr_restringe_atendimento_simplificado == 'S') {
      $this->view->restringir = 1;

    } else {
      $this->view->restringir = 0;
    }
    $this->view->unidade_controle = $usr->uni_desc;
    $this->view->uni_codigo_controle = $usr->uni_codigo;
    $this->view->usr_nome_controle = $usr->usr_nome;
    $this->view->usr_codigo_controle = $usr->usr_codigo;

    $ateCodigo = $this->_getParam("ate_codigo");
    $this->view->requisicao_exames = FALSE;
    if ($ateCodigo) {
      $rlAteCiap = new Application_Model_RlCdsAtendIndividualCiap();
      $ciapsDoAtendimento = $rlAteCiap->getCiapAtendimento($ateCodigo);
      $tbRequisicaoExame = new Application_Model_RequisicaoExame();
      $this->view->requisicao_exames = $tbRequisicaoExame->getHistoricoExame($ateCodigo);
      $this->view->ciap_selecionados = $ciapsDoAtendimento;
    }

  }

  public function salvarAction() {
    $this->view->tipo = $this->_getParam("tipo");
    $valida = $this->_getParam("valida");
    if ($this->_request->getParam("ate_codigo")) {
      $editar = TRUE;
      $ate_codigo = $this->_request->getParam("ate_codigo");
      $age_codigo = $this->_request->getParam("age_codigo");
    }
    $tbUsuarios = new Application_Model_Usuarios();
    $tbAge = new Application_Model_Agendamento();
    $tbUsu = new Application_Model_Usuario();
    $tbDom = new Application_Model_Domicilio();
    $tbAte = new Application_Model_Atendimento();
    $tbAteProc = new Application_Model_ProcedimentoAtendimento();
    $tbDadosUsu = new Application_Model_UsuarioDados();
    $tbAtePre = new Application_Model_AtendimentoPrenatal();
    $dadosUsuarios = $tbUsuarios->getUsrAtual();

    // Salvar Agendamento, por causa da estrutura do BPA
    $dadosAge = array(
      "age_codigo" => $age_codigo,
      "age_data" => $this->_request->getPost("data_atendimento", FALSE) != "" ? $this->_request->getPost("data_atendimento", FALSE) : "NOW()",
      "age_horario" => date("H:i"),
      "tat_codigo" => $this->_request->getPost("tat_codigo", FALSE),
      "med_codigo" => $this->_request->getPost("usr_codigo", FALSE),
      "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
      "age_status" => 'A',
      "age_atendido" => 'A',
      "age_paciente" => $this->_request->getPost("usu_nome", FALSE),
      "uni_codigo" => $dadosUsuarios->uni_codigo,
      "esp_codigo" => $this->_request->getPost("esp_codigo", FALSE),
      "usr_codigo_cad" => $dadosUsuarios->usr_codigo,
      "dt_cadastro" => $this->_request->getPost("data_atendimento", FALSE) != "" ? $this->_request->getPost("data_atendimento", FALSE) : "NOW()",
      "dt_atualizacao" => "NOW()",
      "age_data_atend" => "NOW()",
      "age_emergencia" => 'N',
      "usr_cod_status" => $_SESSION['id_login']
    );

    //Dados do paciente que podem ser alterados na ficha
    $dadosUsu = array(
      "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
      "usu_tem_diabete" => $this->_request->getPost("diabetico", FALSE),
      "usu_esta_gestante" => $this->_request->getPost("gestante", FALSE),
      "usu_tem_hipertensao" => $this->_request->getPost("hipertensao", FALSE),
      "usu_ate_dom_mod" => $this->_request->getPost("usu_ate_dom_mod", NULL),
      "risco_idoso" => $this->_request->getPost("risco_idoso", FALSE),
      "risco_crianca" => $this->_request->getPost("risco_crianca", FALSE),
      "risco_diabetes" => $this->_request->getPost("risco_diabetes", FALSE),
      "risco_gestacao" => $this->_request->getPost("risco_gestacao", FALSE),
      "risco_hipertensao" => $this->_request->getPost("risco_hipertensao", FALSE),
      "risco_psico" => $this->_request->getPost("risco_psico", FALSE)
    );

    //Dados do domiclio estratificado
    $dadosDom = array(
      "dom_codigo" => $this->_request->getPost("dom_codigo", FALSE),
      "estrat_risco_familiar" => $this->_request->getPost("estrat_risco_familiar", FALSE)
    );

    if ($this->view->tipo == 'vd') {
      unset($dadosAge['tat_codigo']);
    }
    Zend_Db_Table::getDefaultAdapter()->beginTransaction();
    try {
      if (!$this->_request->getParam("age_codigo")) {
        $ageCodigo = $tbAge->salvarAgendamento($dadosAge);
      } else {
        $ageCodigo = $this->_request->getParam("age_codigo");
      }

      if ($this->_request->getPost("usu_codigo")) {
        $tbUsu->salvar($dadosUsu);
      } else {
        return false;
      }

      if ($this->_request->getPost("dom_codigo")) {
        $tbDom->salvarDomicilio($dadosDom);
      }

      $dadosCid = $this->_request->getPost("cid_codigo", NULL);

      // Salvar Atendimento
      $dadosAte = array(
        "ate_codigo" => $ate_codigo,
        "ate_data" => $this->_request->getPost("data_atendimento", FALSE) != "" ? $this->_request->getPost("data_atendimento", FALSE) : "NOW()",
        "ate_hora" => date("H:i"),
        "ate_reclamacao" => $this->_request->getPost("agee_observacao", FALSE),
        "med_codigo" => $this->_request->getPost("usr_codigo", FALSE),
        "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
        "usr_equipe_codigo" => $this->_request->getPost("cod_equipe", NULL),
        "age_codigo" => $ageCodigo,
        "ate_valor_proc" => "0.00",
        "uni_codigo" => $this->_request->getPost("uni_codigo", FALSE),
        "ate_data_insert" => "NOW()",
        "ate_simplificado" => TRUE,
        "co_local_atend" => $this->_request->getPost("co_local_atend", FALSE),
        "ate_nasf_aval" => ($this->_request->getPost("ate_nasf_aval") != "" ? "t" : "f"),
        "ate_nasf_proc" => ($this->_request->getPost("ate_nasf_proc") != "" ? "t" : "f"),
        "ate_nasf_presc" => ($this->_request->getPost("ate_nasf_presc") != "" ? "t" : "f"),
        "ate_tipo" => ($this->_request->getPost("ate_tipo_atendimento", false)),
        "turno" => ($this->_request->getPost("turno", false)),
        "st_fora_area" => ($this->_request->getPost("st_fora_area") != "" ? "t" : "f"),
        "microarea" => ($this->_request->getPost("usu_microarea")),
        "st_visita_compartilhada" => ($this->_request->getPost("st_visita_compartilhada") != "" ? "t" : "f"),
        "cd10_codigo" => $dadosCid[0],
        "cd10_codigos" => $dadosCid[1],
        "cd10_codigot" => $dadosCid[2],
        "vd_peso" => ($this->_request->getPost("vd_peso", NULL) ? $this->_request->getPost("vd_peso", NULL) : NULL),
        "vd_altura" => ($this->_request->getPost("vd_altura", NULL) ? $this->_request->getPost("vd_altura") * 100 : NULL),
        "ate_peso" => ($this->_request->getPost("ate_peso", NULL) ? $this->_request->getPost("ate_peso", NULL) : NULL),
        "ate_altura" => ($this->_request->getPost("ate_altura", NULL) ? $this->_request->getPost("ate_altura") * 100 : NULL),
        "ate_rac_saude" => ($this->_request->getPost("ate_rac_saude", NULL) ? $this->_request->getPost("ate_rac_saude", NULL) : NULL),
        "ate_perimetro_cefalico" => ($this->_request->getPost("ate_perimetro_cefalico", NULL) ? $this->_request->getPost("ate_perimetro_cefalico", NULL) : NULL),
        "vacinacao_em_dia" => $this->_request->getPost("vacinacao_em_dia", NULL),
        "aleitamento_materno" => ($this->_request->getPost("aleitamento_materno", NULL) ? $this->_request->getPost("aleitamento_materno", NULL) : NULL)
      );

      // Salva atendimento
      $ateCodigo = $tbAte->salvarAtendimento($dadosAte);
      // Salva Dados da visita
      if ($this->_request->getPost("ate_tipo_atendimento", FALSE) == "V") {
        $tbRati = new Application_Model_RlAteTipoImovel();
        $tbPk = $tbRati->getAteImovel($ateCodigo);
        $dadosRati = array(
          'no_cds_tipo_imovel' => $this->_request->getPost("tipo_imovel"),
          'ate_codigo' => $ateCodigo
        );
        if ($tbPk) {
          $dadosRati['ati_codigo'] = $tbPk['ati_codigo'];
        }
        $tbRati->salvar($dadosRati);

        $this->salvaDadosVisita($this->_request->getPost(), $ateCodigo);
      }
      // Salva Ciap
      $pre_natal = $this->_request->getPost("consulta_pre_natal", FALSE);
      $puerperio = $this->_request->getPost("consulta_puerperio", FALSE);
      $ciaps = $this->_request->getPost("ciap-selecionados", 'F');
      $tbCiap = new Application_Model_TbCiap();

      //Salva Dados Atendimento Pré-Natal
      $dum = $this->_request->getPost("dum", NULL);
      $atp_codigo = $this->_request->getPost("atp_codigo", NULL);
      $tbCid = new Application_Model_Cid();
      $dadosAtePre = array();
      if ($atp_codigo) {
        $dadosAtePre['atp_codigo'] = $atp_codigo;
      }
      $cidsPuerpera = $tbCid->buscarCidsPuerpera();
      $cidsPreNatal = $tbCid->buscarCidsPreNatal();

      foreach ($cidsPuerpera as $cidsP) {
        foreach ($dadosCid as $cid) {
          if ($cid == $cidsP['cd10_codigo']) {
            $dadosAtePre['tipo_consulta'] = 2;
          }
        }
      }
      foreach ($cidsPreNatal as $cidsPre) {
        foreach ($dadosCid as $cid) {
          if ($cid == $cidsPre['cd10_codigo']) {
            $dadosAtePre['tipo_consulta'] = 1;
          }
        }
      }

      if ($pre_natal == 'S') {
        $dadosAtePre['tipo_consulta'] = 1;
      }
      if ($puerperio == 'S') {
        $dadosAtePre['tipo_consulta'] = 2;
      }
      $idade_gestacional = $this->_request->getPost("idade_gestacional", NULL);
      $gravidez_planejada = $this->_request->getPost("gravidez_planejada", NULL);

      if ($dum || $idade_gestacional || $gravidez_planejada || $pre_natal == 'S' || $puerperio == 'S') {
        if ($dum) {
          $dadosAtePre['dum'] = $dum;
          $dadosAtePre['tipo_consulta'] = 1;
        }
        if ($idade_gestacional) {
          $dadosAtePre['idade_gestacional'] = $idade_gestacional;
        }
        if ($gravidez_planejada) {
          $dadosAtePre['gravidez_planejada'] = $gravidez_planejada;
        }
        $dadosAtePre['ate_codigo'] = $ateCodigo;
        $tbApn = new Application_Model_AtendimentoPrenatal();
        $ultimaConsulta = $tbApn->checaUltimaConsulta($this->_request->getPost("usu_codigo", FALSE));
        if ($ultimaConsulta->tipo_consulta == 1) {
          $numeroGestacao = $tbAtePre->checaNumeroGestacao($this->_request->getPost("usu_codigo", FALSE));
        } else {
          $numeroGestacao = ($this->_request->getPost("numero_gestacao") + 1);
        }
        $dadosAtePre['numero_gestacao'] = $numeroGestacao;
        $tbAtePre->salvar($dadosAtePre);
      }


      //Salvando UsuarioDados(Pré-Natal)
      $gestas_previas = $this->_request->getPost("gestas_previas");
      $partos = $this->_request->getPost("partos");
      $usd_codigo = $tbDadosUsu->buscaDadosUsuario($this->_request->getPost("usu_codigo", FALSE));
      $usuDados = array();

      if ($usd_codigo) {
        $usuDados['usd_codigo'] = $usd_codigo->usd_codigo;
      }

      if ($gestas_previas || $partos) {
        if ($gestas_previas) {
          $usuDados['gestas_previas'] = $gestas_previas;
        }
        if ($partos) {
          $usuDados['partos'] = $partos;
        }
        $usuDados['usu_codigo'] = $this->_request->getPost("usu_codigo", FALSE);
        if ($this->_request->getPost("vacinacao_em_dia") != "") {
          $usuDados['vacinacao_em_dia'] = $this->_request->getPost("vacinacao_em_dia", FALSE);
        }
        $tbDadosUsu->salvar($usuDados);
      }

      if ($pre_natal == 'S' && !(in_array($tbCiap->buscarCiapPreNatal("ABP001"), $ciaps))) {
        $ciaps[] = $tbCiap->buscarCiapPreNatal("ABP001");
      } elseif ($puerperio == 'S' && !(in_array($tbCiap->buscarCiapPreNatal("ABP002"), $ciaps))) {
        $ciaps[] = $tbCiap->buscarCiapPreNatal("ABP002");
      }

      $this->salvaCiap($ciaps, $ateCodigo);
      // Salva dados conduta
      if ($this->_request->getPost("conduta", "F")) {
        $this->salvarCondutas($this->_request->getPost("conduta", "F"), $ateCodigo);
      }

      // Salvar Procedimentos dos atendimentos
      // Deleta todos os atendimentos do atendimento evitando duplicar procedimento
      $tbProc = new Application_Model_Procedimento();
      $tbAteProc->excluirProcedimentosAtendimento($ateCodigo);
      $procEsus[] = $this->_request->getPost("curativo_especial");
      $procEsus[] = $this->_request->getPost("teste_olhinho");
      $procEsus[] = $this->_request->getPost("teste_proteinuria");
      $procEsus[] = $this->_request->getPost("adm_intramuscular");
      $procEsus[] = $this->_request->getPost("adm_endovenosa");
      $procEsus[] = $this->_request->getPost("adm_topica");
      $procEsus[] = $this->_request->getPost("adm_penicilina");
      $procEsus[] = $this->_request->getPost("adm_subcutanea");

      $dadosProcAte = $this->_request->getPost("procedimento", FALSE);
      $cids = $this->_request->getPost("cid", FALSE);
      $controleCid = 0;

      //procedimentos da ficha
      foreach ($procEsus as $proc) {
        $aux = $tbProc->getProcedimentoPeloCodigoSus($proc);
        if ($aux) {
          $dados = array(
            "ate_codigo" => $ateCodigo,
            "proc_codigo" => $aux->proc_codigo,
            "usr_codigo" => $this->_request->getPost("usr_codigo", FALSE),
            "cd10_codigo" => null
          );

          $tbAteProc->salvarProcedimentosAtendimento($dados);
        }

      }
      //procedimentos normais
      foreach ($dadosProcAte as $procAte) {

        $codigoCid = $cids[$controleCid];
        $controleCid = $controleCid + 1;

        $dadosProcAte = array(
          "ate_codigo" => $ateCodigo,
          "proc_codigo" => $procAte,
          "usr_codigo" => $this->_request->getPost("usr_codigo", FALSE),
          "cd10_codigo" => $codigoCid
        );


        $tbAteProc->salvarProcedimentosAtendimento($dadosProcAte);
      }

      $tbRequisicaoExame = new Application_Model_RequisicaoExame();
      $dadosRequisicaoExames = $this->_request->getPost("exame", FALSE);
      $examesSolicitado = $this->_request->getPost("exame_solicitado", FALSE);
      $examesAvaliado = $this->_request->getPost("exame_avaliado", FALSE);

      $tbRequisicaoExame->excluirAteCodigo($ateCodigo);

      if ($dadosRequisicaoExames != null && $dadosRequisicaoExames != "") {
        foreach ($dadosRequisicaoExames as $exameAte) {

          $exaAvaliado = null;
          $exaSolicitado = null;

          foreach ($examesSolicitado as $exa) {
            if (substr($exa, 1, strlen($exa) - 1) == $exameAte) {
              $exaSolicitado = substr($exa, 0, 1);
              //$exaAvaliado = null;
              break;
            }
          }

          foreach ($examesAvaliado as $exa) {
            if (substr($exa, 1, strlen($exa) - 1) == $exameAte) {
              $exaAvaliado = substr($exa, 0, 1);
              //$exaSolicitado = null;
              break;
            }
          }

          $dadosRequisicaoExames = array(
            "ate_codigo" => $ateCodigo,
            "proc_codigo" => $exameAte,
            "usr_codigo_solicitante" => $this->_request->getPost("usr_codigo", FALSE),
            "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
            "req_observacao" => $this->_request->getPost("agee_observacao", FALSE),
            "proc_avaliado" => $exaAvaliado,
            "proc_solicitado" => $exaSolicitado
          );

          $tbRequisicaoExame->salvar($dadosRequisicaoExames);
        }
      }

      $unidade_controle = $this->_request->getParam("uni_desc");
      $uni_codigo_controle = $this->_request->getParam("uni_codigo");
      $data_controle = $this->_request->getParam("data_atendimento");
      $data_controle = explode('/', $data_controle);
      $data_controle = implode('-', $data_controle);
      $usr_nome_controle = $this->_request->getParam("usr_nome");
      $usr_codigo_controle = $this->_request->getParam("usr_codigo");
      $esp_codigo_controle = $this->_request->getParam("esp_codigo");
      $ate_tipo_atendimento_controle = $this->_request->getParam("ate_tipo_atendimento");

      Zend_Db_Table::getDefaultAdapter()->commit();
      if (!$valida)
        return $this->_redirect("/atendimento/atendimento-simplificado/index/unidade_controle/" . $unidade_controle . "/uni_codigo_controle/" . $uni_codigo_controle . "/data_controle/" . $data_controle . "/usr_nome_controle/" . $usr_nome_controle . "/usr_codigo_controle/" . $usr_codigo_controle . "/esp_codigo_controle/" . $esp_codigo_controle . "/ate_tipo_atendimento_controle/" . $ate_tipo_atendimento_controle . "/tipo/" . $this->_getParam("tipo"));
      else {
        if ($this->view->tipo == 'ai')
          return $this->_redirect("programas-federais/atendimento-individual/inconsistencias");
        else if ($this->view->tipo == 'vd')
          return $this->_redirect("programas-federais/visita-domiciliar/inconsistencias");
        else if ($this->view->tipo == 'p')
          return $this->_redirect("programas-federais/ficha-procedimento/inconsistencias");
        else
          return $this->_redirect("/atendimento/atendimento-simplificado/index/unidade_controle/" . $unidade_controle . "/uni_codigo_controle/" . $uni_codigo_controle . "/data_controle/" . $data_controle . "/usr_nome_controle/" . $usr_nome_controle . "/usr_codigo_controle/" . $usr_codigo_controle . "/esp_codigo_controle/" . $esp_codigo_controle . "/ate_tipo_atendimento_controle/" . $ate_tipo_atendimento_controle . "/tipo/" . $this->_getParam("tipo"));
      }

    } catch (Exception $exc) {
      Zend_Db_Table::getDefaultAdapter()->rollBack();
      $this->view->dados = $exc->getMessage();
      return $this->render("dados", NULL, TRUE);
    }
  }

  public function salvaDadosVisita($data, $ate_codigo) {
    $tbVisista = new Application_Model_TbCdsVisitaDomiciliar();
    $data_visita = array("st_acompanhada_outro_prof" => null,
      "ate_codigo" => $ate_codigo,
      "co_cds_visita_dom_desfecho" => $data['visita_desfecho']);
    $co_seq_cds_visita_domiciliar = $tbVisista->salvar($data_visita);
    $this->salvarMotivosVisita($data['visita_motivo'], $co_seq_cds_visita_domiciliar);
    return true;
  }

  public function salvarCondutas($post = FALSE, $ateCod = FALSE) {
    $tbCond = new Application_Model_RlCdsAtendIndividualCondut();
    foreach ($post as $val) {
      $dados = "";
      $dados = array(
        "ate_codigo" => $ateCod,
        "tp_cds_conduta" => $val
      );
      try {
        $tbCond->salvar($dados);
      } catch (Exception $exc) {
        return $exc->getMessage();
      }
    }
  }

  public function salvarMotivosVisita($data, $cod_visita) {
    $rlVisitaMotivo = new Application_Model_RlCdsVisitaDomMotivo();
    $array = array();
    foreach ($data as $itens) {
      $array = array("co_cds_visita_domiciliar" => $cod_visita,
        "co_cds_visita_dom_motivo" => $itens);
      $cod_motivo_visita = $rlVisitaMotivo->salvar($array);

    }
    return true;
  }

  private function salvaCiap($data, $ate_codigo) {
    $rlAteCiap = new Application_Model_RlCdsAtendIndividualCiap();
    $dados = array();
    $rlAteCiap->limpaCiapAtendimento($ate_codigo);

    foreach ($data as $item) {
      $dados = array("ate_codigo" => $ate_codigo,
        "co_ciap" => $item);
      $rlAteCiap->salvar($dados);
    }
    return true;
  }

  public function listaAtendimentosSimplificadosAction() {
    $tbAte = new Application_Model_Atendimento();
    $busca = $this->_request->getPost("busca", FALSE);
    $tipo = $this->_getParam("tipo");
    $this->view->tipo = $tipo;
    $tipoBusca = $this->_request->getPost("tipo_busca", FALSE);
    $this->view->dados = $tbAte->listaAtendimentosSimplificados($busca, $tipoBusca);
    $tbUsr = new Application_Model_Usuarios();
    $usr_atual = $tbUsr->getUsrAtual();
    $this->view->usr_mestre = $usr_atual->usr_mestre;
    $this->view->usr_codigo = $usr_atual->usr_codigo;
  }

  public function excluirAtendimentoSimplificadoAction() {
    $ateCodigo = $this->_request->getParam("ate_codigo");
    $ageCodigo = $this->_request->getParam("age_codigo");
    // Excluindo os procedimentos do atendimento
    $tbProcAte = new Application_Model_ProcedimentoAtendimento();
    $tbProcAte->excluirProcedimentosAtendimento($ateCodigo);

    $tbAteCond = new Application_Model_RlCdsAtendIndividualCondut();
    $tbAteCond->excluirPorAtendimento($ateCodigo);

    $tbAteCiap = new Application_Model_RlCdsAtendIndividualCiap();
    $tbAteCiap->limpaCiapAtendimento($ateCodigo);
    // Excluindo o atendimento
    $tbEvd = new Application_Model_EsusVisitaDomiciliar();
    $tbEvd->excluir($ateCodigo);

    $tbReq = new Application_Model_RequisicaoExame();
    $where = "ate_codigo=$ateCodigo";
    $reqExames = $tbReq->fetchAll($where);

    foreach ($reqExames as $req) {
      $tbReq->excluir($req['req_codigo']);
    }

    $tbAte = new Application_Model_Atendimento();
    $tbAte->excluir($ateCodigo);

    // Excluindo o agendamento
    $tbAge = new Application_Model_Agendamento();
    $tbAge->excluir($ageCodigo);
    $tipo = $this->_getParam("tipo");
    $this->view->tipo = $tipo;
    $this->_redirect("atendimento/atendimento-simplificado/index/tipo/$tipo/#tabs2-2");

  }

  public function listaCidsAtendimentoAction() {
    $tbAte = new Application_Model_Atendimento();
    $codAtend = $this->_request->getPost("codAtend");
    $this->view->dados = $tbAte->listaCidsAtendimento($codAtend)->toArray();
    return $this->render("dados", NULL, TRUE);
  }

  public function getCidAtendimentoAction() {
    $age_codigo = Application_Model_Agendamento::usuEmAberto()->age_codigo;
    $tbAte = new Application_Model_Atendimento();
    $codAtend = $tbAte->getCodigoAtendimentoPorAgendamento($age_codigo)->ate_codigo;
    $cidCodigo = $tbAte->listaCidsAtendimento($codAtend)->cd10_codigo;
    $cidDesc = $tbAte->listaCidsAtendimento($codAtend)->cd10_codigo_desc;
    $dadosCid = array(
      "cidCodigo" => $cidCodigo,
      "cidDesc" => $cidDesc
    );
    $this->view->dados = $dadosCid;
    return $this->render("dados", NULL, TRUE);
  }

  public function atualizarCidsAction() {
    $tbAte = new Application_Model_Atendimento();
    $contCid = 0;
    $dadosAtuCids = array(
      "ate_codigo" => $this->_request->getPost("ate_codigo"),
    );
    $dadosAte = $tbAte->verificaCidsLivres($this->_request->getPost("ate_codigo"));
    //Verifica qual campo cid está livre e atualiza apenas o primeiro que estiver
    if (empty($dadosAte->cd10_codigo)) {
      if ($contCid == 0) {
        $dadosAtuCids["cd10_codigo"] = $this->_request->getPost("cd10_codigo");
        $tbAte->atualizaCids($dadosAtuCids);
        $contCid++;
      }
    }
    if (empty($dadosAte->cd10_codigos)) {
      if ($contCid == 0) {
        $dadosAtuCids["cd10_codigos"] = $this->_request->getPost("cd10_codigo");
        $tbAte->atualizaCids($dadosAtuCids);
        $contCid++;
      }
    }
    if (empty($dadosAte->cd10_codigot)) {
      if ($contCid == 0) {
        $dadosAtuCids["cd10_codigot"] = $this->_request->getPost("cd10_codigo");
        $tbAte->atualizaCids($dadosAtuCids);
        $contCid++;
      }
    }
    return $this->render("dados", NULL, TRUE);
  }

  public function excluirCidsAction() {
    $tbAte = new Application_Model_Atendimento();
    $codAte = $this->_request->getPost("ate_codigo");
    $codCid = $this->_request->getPost("cd10_codigo");
    $qtdRegCid10 = $tbAte->getQtdRegistrosAtendCid10($codAte, $codCid)->qtd_reg_cid10;
    $qtdRegCid10s = $tbAte->getQtdRegistrosAtendCid10s($codAte, $codCid)->qtd_reg_cid10s;
    $qtdRegCid10t = $tbAte->getQtdRegistrosAtendCid10t($codAte, $codCid)->qtd_reg_cid10t;
    if ($qtdRegCid10 == 1) {
      $dadosAtuCids = array(
        "ate_codigo" => $codAte,
        "cd10_codigo" => NULL
      );
    }
    if ($qtdRegCid10s == 1) {
      $dadosAtuCids = array(
        "ate_codigo" => $codAte,
        "cd10_codigos" => NULL
      );
    }
    if ($qtdRegCid10t == 1) {
      $dadosAtuCids = array(
        "ate_codigo" => $codAte,
        "cd10_codigot" => NULL
      );
    }
    $tbAte->atualizaCids($dadosAtuCids);
    return $this->render("dados", NULL, TRUE);
  }

}
