<?php

require_once __DIR__ . '/../../Util.php';

class AgendamentoExternoController extends Zend_Controller_Action {

  public function init() {
    $this->_helper->acl->allow(NULL, array('itens'));
    $this->view->title = "Agendamento Externo";
  }

  public function indexAction() {
    $fiusu_codigo = $this->_request->getParam("fiusu_codigo", FALSE);
    if ($fiusu_codigo) {
      $this->view->fiusu_codigo = $fiusu_codigo;
    }
  }

  public function editarAction() {
    $agee_codigo = $this->_getParam("id", FALSE);
    $fiusu_codigo = $this->_getParam("fiusu_codigo", FALSE);
    if ($fiusu_codigo) {
      $tbAgee = new Application_Model_AgendamentoExterno();
      $this->view->dados = $tbAgee->buscarFila($fiusu_codigo);
      $this->view->fiusu_codigo = $fiusu_codigo;
      $this->render("index");
    } else {
      if (!$agee_codigo)
        $this->_redirect("/agendamento-externo");

      $tbAgee = new Application_Model_AgendamentoExterno();
      $this->view->dados = $tbAgee->buscar($agee_codigo);
      $this->render("index");
    }
  }

  public function salvarAction() {
    if ($this->_request->isPost()) {
      $arquivo = file_get_contents($_FILES['agee_anexo']['tmp_name']);
      $anexo = pg_escape_bytea($arquivo);
      $anexonome = $_FILES['agee_anexo']['name'];
      $anexotipo = $_FILES['agee_anexo']['type'];

      $dados = array(
        "fiusu_codigo" => $this->_request->getPost("fiusu_codigo", FALSE),
        "agee_codigo" => $this->_request->getPost("agee_codigo", FALSE),
        "usu_codigo" => $this->_request->getPost("usu_codigo", FALSE),
        "esp_codigo" => $this->_request->getPost("esp_codigo", FALSE),
        "med_codigo" => $this->_request->getPost("med_codigo", FALSE),
        "proc_codigo" => $this->_request->getPost("proc_codigo", FALSE),
        "usr_codigo_solicitante" => $this->_request->getPost("usr_codigo_solicitante", FALSE),
        "interno" => $this->_request->getPost("interno", FALSE),
        "med_codigo_prestador" => $this->_request->getPost("med_codigo_prestador", FALSE),
        "agee_situacao" => $this->_request->getPost("agee_situacao", 0),
        "agee_data" => $this->_request->getPost("agee_data", FALSE),
        "agee_data_pedido" => $this->_request->getPost("agee_data_pedido", FALSE),
        "agee_hora" => $this->_request->getPost("agee_hora", FALSE),
        "agee_valor" => $this->_request->getPost("agee_valor", 0),
        "agee_num_reg" => $this->_request->getPost("agee_num_reg", FALSE),
        "agee_observacao" => $this->_request->getPost("agee_observacao", FALSE),
        "grau_risco" => $this->_request->getPost("grau_risco", FALSE),
      );

      $outros = array(
        "buscar1" => $this->_request->getPost("buscar1", ""),
        "usu_nome" => $this->_request->getPost("usu_nome", ""),
        "usu_carto_sus" => $this->_request->getPost("usu_carto_sus", ""),
        "usu_datanasc" => $this->_request->getPost("usu_datanasc", ""),
        "usu_end_rua" => $this->_request->getPost("usu_end_rua", ""),
        "esp_nome" => $this->_request->getPost("esp_nome", ""),
        "med_destino" => $this->_request->getPost("med_destino", ""),
        "proc_nome" => $this->_request->getPost("proc_nome", ""),
        "usr_nome" => $this->_request->getPost("usr_nome", ""),
        "med_prestador" => $this->_request->getPost("med_prestador", "")
      );

      try {
        $tbAgee = new Application_Model_AgendamentoExterno();
        $agee_codigo = $tbAgee->salvar($dados);

        if ((new Application_Model_Configuracao())->getConfig('ENVIO_MENSAGENS_AUTOMATICAS')) {
          $tbMed = new Application_Model_Medico();
          $tbUsu = new Application_Model_Usuario();
          $dados['agee_codigo'] = $agee_codigo;
          $dados['paciente'] = $tbUsu->getUsuarioPorId($dados['usu_codigo']);
          $dados['access_token'] = $_SESSION['access_token'];
          $dados['age_data'] = $dados['agee_data'];
          $dados['age_horario'] = $dados['agee_hora'];
          $dados["agee_codigo_agentic"] = Util::sendRequestAgentic($dados, 'agendamentoExterno', '/agendamento/cadastrar');
          unset($dados['age_data']);
          unset($dados['age_horario']);
          unset($dados['paciente']);
          unset($dados['access_token']);
        }
          $agee_sit = $tbAgee->getDados($agee_codigo)->agee_situacao;
          if ($agee_sit == 2) {
            $this->view->print = $agee_codigo;
          }

          if ($_FILES['agee_anexo']['name'] <> '') {
            $path = $_SESSION['linkroot'] . $_SESSION['comum'] . "library/conf/";
            $arq = "dbConfig";
            $ext = ".xml";
            $completePath = $path . $arq . $ext;

            $xml = simplexml_load_file($completePath);
            $host = base64_decode($xml->conexao->host);
            $banco = base64_decode($xml->conexao->dbname);
            $porta = base64_decode($xml->conexao->porta);
            $user = base64_decode($xml->conexao->user);
            $pass = base64_decode($xml->conexao->password);
            $conn = base64_decode($xml->conexao->typeconn);
            $adapter = base64_decode($xml->conexao->adapter);

            $conexaoString = "host=$host dbname=$banco port=$porta user=$user password=$pass options='--client_encoding=UTF8'";
            $conexao = pg_connect($conexaoString);
            pg_set_client_encoding($conexao, UNICODE);

            $sql = "UPDATE agendamento_externo SET agee_anexo = '$anexo',
          agee_nomeanexo = '$anexonome',
          agee_tipoanexo = '$anexotipo'
          WHERE agee_codigo = " . $agee_codigo;
            $result = pg_query($conexao, $sql);
            if (!$result) {
              throw new Exception();
            }
            $anexo = pg_fetch_array($result);
          }
          if ($dados['fiusu_codigo'] != "") {
            switch ($dados['agee_situacao']) {
              case 0:
                $status = "SA";
                break;
              case 1:
                $status = "ES";
                break;
              case 2:
                $status="SA";
                break;
              case 3:
                $status="ES";
                break;
              case 4:
                $status = "CA";
                $motivo = "Paciente Faltoso";
                break;
              case 5:
                $status = "SA";
                break;
            }
            $tbFilausu = new Application_Model_FilasUsuario();
            $tbFila = new Application_Model_Filas();
            $filaUsu = $tbFilausu->getdados($dados['fiusu_codigo']);
            $tbFilausu->setStatus($dados['fiusu_codigo'], $status, $motivo);
            $fila = $filaUsu->fila_codigo;
            $tbFila->ordenaFilaAction($fila);

            $this->view->dados = array("success" => TRUE, "mensagem" => "Agendamento realizado com sucesso!", "agee_codigo" => $agee_codigo, "fila_codigo" => $fila);
            $this->render("dados", NULL, TRUE);
          } else {
            $this->view->dados = array("success" => TRUE, "mensagem" => "Agendamento realizado com sucesso!", "agee_codigo" => $agee_codigo);
            $this->render("dados", NULL, TRUE);
          }

      } catch (Zend_Validate_Exception $exc) {
        $this->view->erro = $exc->getMessage();
        $this->view->dados = (object)array_merge($dados, $outros);
        $this->render("index");
      }
    } else {
      $this->_redirect("/agendamento-externo");
    }
  }

  public function itensAction() {
    // Para usar com ajax, desabilitar o layout
    $this->_helper->layout()->disableLayout();

    $usu_codigo = $this->_getParam("usu_codigo", FALSE);
    if (!$usu_codigo)
      return false;

    $tbAgee = new Application_Model_AgendamentoExterno();
    $this->view->itens = $tbAgee->getHistorico($usu_codigo);
  }

  public function imprimirAction() {
    $copias = $this->_getParam("copias", FALSE);
    if ($copias == "1") {
      Zend_Layout::getMvcInstance()->setLayout("print");
    } else {
      Zend_Layout::getMvcInstance()->setLayout("print_duasvias");
    }
    $this->view->title = "Imprimir Encaminhamento";

    $agee_codigo = $this->_getParam("id", FALSE);
    if (!$agee_codigo)
      return $this->_redirect("/agendamento-externo");

    $tbAgee = new Application_Model_AgendamentoExterno();
    $this->view->dados = $tbAgee->imprimir($agee_codigo);
  }

  public function baixaranexoAction() {
    $this->_helper->layout->disableLayout();
    $this->_helper->viewRenderer->setNoRender(true);

    $agee_codigo = $this->_getParam("id", FALSE);
    if (!$agee_codigo)
      return $this->_redirect("/agendamento-externo");

    $path = $_SESSION['linkroot'] . $_SESSION['comum'] . "library/conf/";
    $arq = "dbConfig";
    $ext = ".xml";
    $completePath = $path . $arq . $ext;

    $xml = simplexml_load_file($completePath);
    $host = base64_decode($xml->conexao->host);
    $banco = base64_decode($xml->conexao->dbname);
    $porta = base64_decode($xml->conexao->porta);
    $user = base64_decode($xml->conexao->user);
    $pass = base64_decode($xml->conexao->password);
    $conn = base64_decode($xml->conexao->typeconn);
    $adapter = base64_decode($xml->conexao->adapter);

    $conexaoString = "host=$host dbname=$banco port=$porta user=$user password=$pass options='--client_encoding=UTF8'";
    $conexao = pg_connect($conexaoString);
    pg_set_client_encoding($conexao, UNICODE);

    $sql = "SELECT agee_anexo, agee_nomeanexo, agee_tipoanexo, octet_length(agee_anexo) as agee_size
    FROM agendamento_externo
    WHERE agee_codigo = " . $agee_codigo . "
    ";
    $result = pg_query($conexao, $sql);
    if (!$result) {
      die("Falha em executar a query!");
    }

    $anexo = pg_fetch_array($result);

    $nomeArquivo = $anexo['agee_nomeanexo'];
    $dados = pg_unescape_bytea($anexo['agee_anexo']);

    // Será chamado o arquivo para download
    header("Content-type: {$anexo['agee_tipoanexo']}");
    header('Content-Disposition: attachment; filename="' . $nomeArquivo . '"');
    echo $dados;
    exit;
  }

  public function excluirAction() {
    $this->_helper->layout->disableLayout();
    $this->_helper->viewRenderer->setNoRender(true);

    $agee = $this->_getParam("id", FALSE);
    if (!$agee)
      return $this->_redirect("/agendamento-externo");

    $tbAgee = new Application_Model_AgendamentoExterno();
    $tbAgee->excluir($agee);
  }

}
