<?php

class GuicheController extends Zend_Controller_Action {

    public function init() {
        $this->view->title = "Guichê de Atendimento";
        $this->_helper->acl->allow(NULL, array('index'));
    }

    public function indexAction() {
        $this->_helper->layout->setLayout("sem-aba");
    }

    public function carregaDadosIniciaisAction(){
        $tbUsr = new Application_Model_Usuarios();
        $this->view->dados = $tbUsr->getUsrAtual();
        return $this->render("dados", NULL, TRUE);
    }

    public function retornaVideoAction() {
        $tbUpv = new Application_Model_UploadVideo();
        $videos = $tbUpv->retornaVideo();
        $this->view->dados = $videos;
        return $this->render("dados", NULL, TRUE);
    }

    public function buscarChamadasAction() {
        $uni_codigo = $this->_getParam("uni_codigo");

        $tbCha = new Application_Model_Chamada();
        $chamadas = $tbCha->buscarChamadas($uni_codigo)->toArray();
        $this->view->dados = array();
        if(count($chamadas) > 0){
            $this->view->dados = $chamadas;
        }
        return $this->render("dados", NULL, TRUE);
    }

    public function getLastIndexAction() {
        $_SESSION[modulo] = "WebSocialSaude/"; $_SESSION[root] = $_SERVER[DOCUMENT_ROOT] . "/"; $_SESSION[linkroot] = "http://" . $_SERVER[HTTP_HOST] . "/"; $_SESSION[comum] = "WebSocialComum/"; $_SESSION[modulo] = "WebSocialSaude/"; require_once $_SESSION[root].$_SESSION[modulo]."sessao_controller.php";
        $sessao = new TempoSessao();
        $sessao->primeiraPagina();

        $uni_codigo = $this->_getParam("uni_codigo");

        // Verifica se houve chamada
        $tbCha = new Application_Model_Chamada();
        $index = $tbCha->getIndex($uni_codigo)->toArray();
        $this->view->dados = $index;
        return $this->render("dados", NULL, TRUE);
    }

    public function alteraStatusAction() {
        $this->_helper->layout->disableLayout();
        $this->_helper->viewRenderer->setNoRender(true);
        $age_codigo = $this->_getParam("age_codigo");
        $tbCha = new Application_Model_Chamada();
        $tbCha->encerrarChamada($age_codigo);
        $this->render("index");
    }

    public function chamarAction() {
        $age_codigo = $this->_getParam("age_codigo");
        $tbAge = new Application_Model_Agendamento();
        $dados = $tbAge->getDadosAgendamentoUsuario($age_codigo);
        $tbUsr = new Application_Model_Usuarios();
        $usuario_atual = $tbUsr->getUsrAtual();
        $setor = $usuario_atual->esp_nome;
        if($usuario_atual->set_nome){
            $set = explode('-',$usuario_atual->set_nome);
           $setor = $set[0];
        }
        if (trim($dados->usr_cod_status) === trim($_SESSION[id_login])) {
            $dataCha = array(
                "age_codigo" => $age_codigo,
                "cha_usu_prontuario" => $dados->usu_prontuario,
                "cha_paciente" => $dados->age_paciente,
                "cha_profissional" => $usuario_atual->usr_nome,
                "cha_setor" => $setor,
                "uni_codigo" => $usuario_atual->uni_codigo,
                "cha_status" => "C",
                "cha_chamar" => true
            );
            Util::chamada($dataCha);
            $this->render("index");
        }
    }

    public function faltouAction(){
        $age_codigo = $this->_getParam("age_codigo");
        $tbAge = new Application_Model_Agendamento();
        $dataCha = array(
            "age_codigo" => $age_codigo,
            "cha_status" => "F",
            "nao_altera_data" => 1
        );

        Util::chamada($dataCha);
        $this->render("index");
    }

    public function lerAction() {
        $usu_nome = $this->_getParam("usu_nome", "maria");
        $tbCha = new Application_Model_Chamada();
        $chamadas = $tbCha->ler($usu_nome);
        //echo "<pre>".print_r($chamadas,1); die();
        $this->view->dados = $chamadas;
        return $this->render("dados", NULL, TRUE);

    }

}

